pico-8 cartridge // http://www.pico-8.com
version 8
__lua__
-- petscii-inspired live-drawing tool
-- 2016 m.wisniowski / nodepond.com

spra={}
crs={} -- drawing cursor
crs.x=0
crs.y=0
tscr={} -- tile select cursor
tscr.x=0
tscr.y=0
tscr.sel=128
t=0
startscreen=true
tile_select_mode=false
show_menu=false
menu_selected=0
drawing_mode=false
draw_btn_down=false -- needed for undo
-- undo handling
undos={}
cur_undo={}

function _init()
 cartdata("nodepond_lifedraw")
end

function _update()
 if startscreen == true then
  update_introscreen()
 else
  update_drawingmode()
 end
end

function update_drawingmode()
 t+=1
 if drawing_mode then
  if btnp(0) then crs.x-=1;t=0 end
  if btnp(1) then crs.x+=1;t=0 end
  if btnp(2) then crs.y-=1;t=0 end
  if btnp(3) then crs.y+=1;t=0 end
  crs.x = crs.x%16
  crs.y = crs.y%16
 end
 if show_menu then
  --handle menu
  if btnp(2) then menu_selected-=1 end
  if btnp(3) then menu_selected+=1 end
  if btnp(0) then show_menu=false;drawing_mode=true end
  if btnp(1) then show_menu=false;drawing_mode=true end
  menu_selected = menu_selected%6
 end
 if tile_select_mode then
  if btnp(0) then tscr.x-=1;t=0 end
  if btnp(1) then tscr.x+=1;t=0 end
  if btnp(2) then tscr.y-=1;t=0 end
  if btnp(3) then tscr.y+=1;t=0 end
  tscr.x = tscr.x%16
  tscr.y = tscr.y%16
 end

 -- handle undo. save current but to stack
 if draw_btn_down then
  if btn(4)==false then
   draw_btn_down = btn(4)
   if count(cur_undo) > 0 then
    add_cur_undo_to_buf()
   end
  end
 end
 if btnp(5) then
  if count(cur_undo) > 0 then
   add_cur_undo_to_buf()
  end
 end

 -- handle menu
 if btnp(5) then
  if show_menu==false and tile_select_mode==false then
    show_menu=true
    menu_selected=0
    drawing_mode=false
    menucol = flr(rnd(11)+5)
  elseif tile_select_mode then
    tile_select_mode=false
    tscr.sel=tscr.y*16+tscr.x
    drawing_mode=true
  else
    show_menu=false
    if menu_selected==0 then
      tile_select_mode = true
    end
    if menu_selected==1 then
      -- undo
      undo()
      drawing_mode=true
    end
    if menu_selected==2 then
      -- save
      save_image()
      drawing_mode=true
    end
    if menu_selected==3 then
      -- load
      load_image()
      drawing_mode=true
    end
    if menu_selected==4 then
      -- clear
      clear_screen(tscr.sel)
      drawing_mode=true
      -- assign a new drawing tile
      tscr.y+=1;tscr.x+=1;
      tscr.sel=tscr.y*16+tscr.x
    end
    if menu_selected==5 then
      -- back
      drawing_mode=true
    end
  end
 end

 -- do drawing stuff,
 -- but only at draw-mode
 if btn(4) then
  if drawing_mode then
   draw_btn_down=true
   put_tile(crs.x, crs.y, tscr.sel, false)
  end
 end
end

function update_introscreen()
 if btnp(2) then
  for i=0,255 do
	  add(spra,rnd(255))
	 end
	  startscreen=false
   drawing_mode=true
	end
	if btnp(3) then
  for i=0,255 do
	  add(spra,0)
	 end
	  startscreen=false
   drawing_mode=true
	end
end

function _draw()
 if startscreen == true then
  draw_introscreen()
 else
  draw_drawingmode()
 end
end

function draw_introscreen()
 cls()
 print("lifedraw v0.03", 10, 10, 8)
 print("by nodepond", 10, 18, 2)
 print("press up for random", 10, 104, 8)
 print("press down for blank screen", 10, 112, 8)
end

function draw_drawingmode()
	cls()
	if tile_select_mode then
	 draw_tileselect()
	else
   for i=0,255 do
    local x=i%16
    local y=flr(i/16)
    spr(spra[i+1], x*8,y*8)
   end
   draw_cursor()
  end

  --draw menu
  if show_menu then
   local mx=32
   local my=32
   rectfill(mx,my,96,96,menucol)
   print("menu", mx+8,my+2, 0)
   print("select tile", mx+8,my+1+16, 0)
   print("undo", mx+8,my+1+8+16, 0)
   print("save", mx+8,my+1+16+16, 0)
   print("load", mx+8,my+1+24+16, 0)
   print("clear", mx+8,my+1+32+16, 0)
   print("back", mx+8,my+1+40+16, 0)
   palt(7, true)
   palt(0, false)
   spr(2,mx, my+menu_selected*8+16)
   palt(7, false)
   palt(0, true)
  end
end

function put_tile(x,y,tile,from_undo)
 if from_undo==false then
  add_to_cur_undo(x,y,spra[(y*16+x)+1])
 end
 spra[(y*16+x)+1] = tile
end

function draw_tileselect()
	cls()
	for i=0,255 do
  local x=i%16
  local y=flr(i/16)
   spr(i, x*8,y*8)
 end
 draw_tile_cursor()
end

function draw_cursor()
 spr(tscr.sel, crs.x*8, crs.y*8)
 if t%56 < 28 then
  spr(1, crs.x*8, crs.y*8)
 end
end

function draw_tile_cursor()
 if t%56 < 28 then
  spr(1, tscr.x*8, tscr.y*8)
 end
end

function clear_screen(tilenum)
 cur_scr_to_undo()
 for i=0,255 do
  spra[i+1]=tilenum
 end
end

function save_image()
 for i=0,255 do
  poke(0x5e00+i,spra[i+1])
 end
end

function load_image()
 cur_scr_to_undo()
 for i=0,255 do
  spra[i+1] = peek(0x5e00+i)
 end
end

function undo()
 if count(undos) > 0 then
  local u_a=undos[count(undos)]
  for u in all(u_a) do
  --for u in all(cur_undo) do
   put_tile(u[1],u[2],u[3],true)
  end
  del(undos,u_a)
 end
end

function add_to_cur_undo(x,y,tile)
 local new_tile=true
 -- is tile alrealy in bufffer?
 for u in all(cur_undo) do
  if u[1]==x and
     u[2]==y then
     --stop()
   new_tile = false
  end
 end
 if new_tile then add(cur_undo, {x,y,tile}) end
end

function add_cur_undo_to_buf()
 if count(undos) > 50 then
  del(undos,undos[1])
 end
 add(undos, cur_undo)
 cur_undo={}
end

function cur_scr_to_undo()
 for i=0,255 do
  local x=i%16
  local y=flr(i/16)
  add_to_cur_undo(x,y,spra[i+1])
 end
 add_cur_undo_to_buf()
end
__gfx__
00000000000000007777777700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000007770777700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000007007007770077700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000770007770007700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000770007770077700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000007007007770777700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000007777777700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000007777777700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
11111111000000011000000011111111111111111100110000000000111100000011001111001100110000000000001100000000000000000001100000011000
11111111000000111100000011111110011111111100110000000000111100001001100110011001111000000000011100000000000000000001100000011000
11111111000001111110000011111100001111110011001100100100111100001100110000110011011100000000111000000000000000000001110000111000
11111111000011111111000011111000000111110011001100011000111100000110011001100110001110000001110000000111111000000000111111110000
11111111000111111111100011110000000011111100110000011000000011110011001111001100000111000011100000001111111100000000011111100000
11111111001111111111110011100000000001111100110000100100000011111001100110011001000011100111000000011100001110000000000000000000
11111111011111111111111011000000000000110011001100000000000011111100110000110011000001111110000000011000000110000000000000000000
11111111111111111111111110000000000000010011001100000000000011110110011001100110000000111100000000011000000110000000000000000000
22222222000000022000000022222222222222222200220000000000222200000022002222002200220000000000002200000000000000000002200000022000
22222222000000222200000022222220022222222200220000000000222200002002200220022002222000000000022200000000000000000002200000022000
22222222000002222220000022222200002222220022002200200200222200002200220000220022022200000000222000000000000000000002220000222000
22222222000022222222000022222000000222220022002200022000222200000220022002200220002220000002220000000222222000000000222222220000
22222222000222222222200022220000000022222200220000022000000022220022002222002200000222000022200000002222222200000000022222200000
22222222002222222222220022200000000002222200220000200200000022222002200220022002000022200222000000022200002220000000000000000000
22222222022222222222222022000000000000220022002200000000000022222200220000220022000002222220000000022000000220000000000000000000
22222222222222222222222220000000000000020022002200000000000022220220022002200220000000222200000000022000000220000000000000000000
33333333000000033000000033333333333333333300330000000000333300000033003333003300330000000000003300000000000000000003300000033000
33333333000000333300000033333330033333333300330000000000333300003003300330033003333000000000033300000000000000000003300000033000
33333333000003333330000033333300003333330033003300300300333300003300330000330033033300000000333000000000000000000003330000333000
33333333000033333333000033333000000333330033003300033000333300000330033003300330003330000003330000000333333000000000333333330000
33333333000333333333300033330000000033333300330000033000000033330033003333003300000333000033300000003333333300000000033333300000
33333333003333333333330033300000000003333300330000300300000033333003300330033003000033300333000000033300003330000000000000000000
33333333033333333333333033000000000000330033003300000000000033333300330000330033000003333330000000033000000330000000000000000000
33333333333333333333333330000000000000030033003300000000000033330330033003300330000000333300000000033000000330000000000000000000
44444444000000044000000044444444444444444400440000000000444400000044004444004400440000000000004400000000000000000004400000044000
44444444000000444400000044444440044444444400440000000000444400004004400440044004444000000000044400000000000000000004400000044000
44444444000004444440000044444400004444440044004400400400444400004400440000440044044400000000444000000000000000000004440000444000
44444444000044444444000044444000000444440044004400044000444400000440044004400440004440000004440000000444444000000000444444440000
44444444000444444444400044440000000044444400440000044000000044440044004444004400000444000044400000004444444400000000044444400000
44444444004444444444440044400000000004444400440000400400000044444004400440044004000044400444000000044400004440000000000000000000
44444444044444444444444044000000000000440044004400000000000044444400440000440044000004444440000000044000000440000000000000000000
44444444444444444444444440000000000000040044004400000000000044440440044004400440000000444400000000044000000440000000000000000000
55555555000000055000000055555555555555555500550000000000555500000055005555005500550000000000005500000000000000000005500000055000
55555555000000555500000055555550055555555500550000000000555500005005500550055005555000000000055500000000000000000005500000055000
55555555000005555550000055555500005555550055005500500500555500005500550000550055055500000000555000000000000000000005550000555000
55555555000055555555000055555000000555550055005500055000555500000550055005500550005550000005550000000555555000000000555555550000
55555555000555555555500055550000000055555500550000055000000055550055005555005500000555000055500000005555555500000000055555500000
55555555005555555555550055500000000005555500550000500500000055555005500550055005000055500555000000055500005550000000000000000000
55555555055555555555555055000000000000550055005500000000000055555500550000550055000005555550000000055000000550000000000000000000
55555555555555555555555550000000000000050055005500000000000055550550055005500550000000555500000000055000000550000000000000000000
66666666000000066000000066666666666666666600660000000000666600000066006666006600660000000000006600000000000000000006600000066000
66666666000000666600000066666660066666666600660000000000666600006006600660066006666000000000066600000000000000000006600000066000
66666666000006666660000066666600006666660066006600600600666600006600660000660066066600000000666000000000000000000006660000666000
66666666000066666666000066666000000666660066006600066000666600000660066006600660006660000006660000000666666000000000666666660000
66666666000666666666600066660000000066666600660000066000000066660066006666006600000666000066600000006666666600000000066666600000
66666666006666666666660066600000000006666600660000600600000066666006600660066006000066600666000000066600006660000000000000000000
66666666066666666666666066000000000000660066006600000000000066666600660000660066000006666660000000066000000660000000000000000000
66666666666666666666666660000000000000060066006600000000000066660660066006600660000000666600000000066000000660000000000000000000
77777777000000077000000077777777777777777700770000000000777700000077007777007700770000000000007700000000000000000007700000077000
77777777000000777700000077777770077777777700770000000000777700007007700770077007777000000000077700000000000000000007700000077000
77777777000007777770000077777700007777770077007700700700777700007700770000770077077700000000777000000000000000000007770000777000
77777777000077777777000077777000000777770077007700077000777700000770077007700770007770000007770000000777777000000000777777770000
77777777000777777777700077770000000077777700770000077000000077770077007777007700000777000077700000007777777700000000077777700000
77777777007777777777770077700000000007777700770000700700000077777007700770077007000077700777000000077700007770000000000000000000
77777777077777777777777077000000000000770077007700000000000077777700770000770077000007777770000000077000000770000000000000000000
77777777777777777777777770000000000000070077007700000000000077770770077007700770000000777700000000077000000770000000000000000000
88888888000000088000000088888888888888888800880000000000888800000088008888008800880000000000008800000000000000000008800000088000
88888888000000888800000088888880088888888800880000000000888800008008800880088008888000000000088800000000000000000008800000088000
88888888000008888880000088888800008888880088008800800800888800008800880000880088088800000000888000000000000000000008880000888000
88888888000088888888000088888000000888880088008800088000888800000880088008800880008880000008880000000888888000000000888888880000
88888888000888888888800088880000000088888800880000088000000088880088008888008800000888000088800000008888888800000000088888800000
88888888008888888888880088800000000008888800880000800800000088888008800880088008000088800888000000088800008880000000000000000000
88888888088888888888888088000000000000880088008800000000000088888800880000880088000008888880000000088000000880000000000000000000
88888888888888888888888880000000000000080088008800000000000088880880088008800880000000888800000000088000000880000000000000000000
99999999000000099000000099999999999999999900990000000000999900000099009999009900990000000000009900000000000000000009900000099000
99999999000000999900000099999990099999999900990000000000999900009009900990099009999000000000099900000000000000000009900000099000
99999999000009999990000099999900009999990099009900900900999900009900990000990099099900000000999000000000000000000009990000999000
99999999000099999999000099999000000999990099009900099000999900000990099009900990009990000009990000000999999000000000999999990000
99999999000999999999900099990000000099999900990000099000000099990099009999009900000999000099900000009999999900000000099999900000
99999999009999999999990099900000000009999900990000900900000099999009900990099009000099900999000000099900009990000000000000000000
99999999099999999999999099000000000000990099009900000000000099999900990000990099000009999990000000099000000990000000000000000000
99999999999999999999999990000000000000090099009900000000000099990990099009900990000000999900000000099000000990000000000000000000
aaaaaaaa0000000aa0000000aaaaaaaaaaaaaaaaaa00aa0000000000aaaa000000aa00aaaa00aa00aa000000000000aa0000000000000000000aa000000aa000
aaaaaaaa000000aaaa000000aaaaaaa00aaaaaaaaa00aa0000000000aaaa0000a00aa00aa00aa00aaaa0000000000aaa0000000000000000000aa000000aa000
aaaaaaaa00000aaaaaa00000aaaaaa0000aaaaaa00aa00aa00a00a00aaaa0000aa00aa0000aa00aa0aaa00000000aaa00000000000000000000aaa0000aaa000
aaaaaaaa0000aaaaaaaa0000aaaaa000000aaaaa00aa00aa000aa000aaaa00000aa00aa00aa00aa000aaa000000aaa0000000aaaaaa000000000aaaaaaaa0000
aaaaaaaa000aaaaaaaaaa000aaaa00000000aaaaaa00aa00000aa0000000aaaa00aa00aaaa00aa00000aaa0000aaa0000000aaaaaaaa000000000aaaaaa00000
aaaaaaaa00aaaaaaaaaaaa00aaa0000000000aaaaa00aa0000a00a000000aaaaa00aa00aa00aa00a0000aaa00aaa0000000aaa0000aaa0000000000000000000
aaaaaaaa0aaaaaaaaaaaaaa0aa000000000000aa00aa00aa000000000000aaaaaa00aa0000aa00aa00000aaaaaa00000000aa000000aa0000000000000000000
aaaaaaaaaaaaaaaaaaaaaaaaa00000000000000a00aa00aa000000000000aaaa0aa00aa00aa00aa0000000aaaa000000000aa000000aa0000000000000000000
bbbbbbbb0000000bb0000000bbbbbbbbbbbbbbbbbb00bb0000000000bbbb000000bb00bbbb00bb00bb000000000000bb0000000000000000000bb000000bb000
bbbbbbbb000000bbbb000000bbbbbbb00bbbbbbbbb00bb0000000000bbbb0000b00bb00bb00bb00bbbb0000000000bbb0000000000000000000bb000000bb000
bbbbbbbb00000bbbbbb00000bbbbbb0000bbbbbb00bb00bb00b00b00bbbb0000bb00bb0000bb00bb0bbb00000000bbb00000000000000000000bbb0000bbb000
bbbbbbbb0000bbbbbbbb0000bbbbb000000bbbbb00bb00bb000bb000bbbb00000bb00bb00bb00bb000bbb000000bbb0000000bbbbbb000000000bbbbbbbb0000
bbbbbbbb000bbbbbbbbbb000bbbb00000000bbbbbb00bb00000bb0000000bbbb00bb00bbbb00bb00000bbb0000bbb0000000bbbbbbbb000000000bbbbbb00000
bbbbbbbb00bbbbbbbbbbbb00bbb0000000000bbbbb00bb0000b00b000000bbbbb00bb00bb00bb00b0000bbb00bbb0000000bbb0000bbb0000000000000000000
bbbbbbbb0bbbbbbbbbbbbbb0bb000000000000bb00bb00bb000000000000bbbbbb00bb0000bb00bb00000bbbbbb00000000bb000000bb0000000000000000000
bbbbbbbbbbbbbbbbbbbbbbbbb00000000000000b00bb00bb000000000000bbbb0bb00bb00bb00bb0000000bbbb000000000bb000000bb0000000000000000000
cccccccc0000000cc0000000cccccccccccccccccc00cc0000000000cccc000000cc00cccc00cc00cc000000000000cc0000000000000000000cc000000cc000
cccccccc000000cccc000000ccccccc00ccccccccc00cc0000000000cccc0000c00cc00cc00cc00cccc0000000000ccc0000000000000000000cc000000cc000
cccccccc00000cccccc00000cccccc0000cccccc00cc00cc00c00c00cccc0000cc00cc0000cc00cc0ccc00000000ccc00000000000000000000ccc0000ccc000
cccccccc0000cccccccc0000ccccc000000ccccc00cc00cc000cc000cccc00000cc00cc00cc00cc000ccc000000ccc0000000cccccc000000000cccccccc0000
cccccccc000cccccccccc000cccc00000000cccccc00cc00000cc0000000cccc00cc00cccc00cc00000ccc0000ccc0000000cccccccc000000000cccccc00000
cccccccc00cccccccccccc00ccc0000000000ccccc00cc0000c00c000000ccccc00cc00cc00cc00c0000ccc00ccc0000000ccc0000ccc0000000000000000000
cccccccc0cccccccccccccc0cc000000000000cc00cc00cc000000000000cccccc00cc0000cc00cc00000cccccc00000000cc000000cc0000000000000000000
ccccccccccccccccccccccccc00000000000000c00cc00cc000000000000cccc0cc00cc00cc00cc0000000cccc000000000cc000000cc0000000000000000000
dddddddd0000000dd0000000dddddddddddddddddd00dd0000000000dddd000000dd00dddd00dd00dd000000000000dd0000000000000000000dd000000dd000
dddddddd000000dddd000000ddddddd00ddddddddd00dd0000000000dddd0000d00dd00dd00dd00dddd0000000000ddd0000000000000000000dd000000dd000
dddddddd00000dddddd00000dddddd0000dddddd00dd00dd00d00d00dddd0000dd00dd0000dd00dd0ddd00000000ddd00000000000000000000ddd0000ddd000
dddddddd0000dddddddd0000ddddd000000ddddd00dd00dd000dd000dddd00000dd00dd00dd00dd000ddd000000ddd0000000dddddd000000000dddddddd0000
dddddddd000dddddddddd000dddd00000000dddddd00dd00000dd0000000dddd00dd00dddd00dd00000ddd0000ddd0000000dddddddd000000000dddddd00000
dddddddd00dddddddddddd00ddd0000000000ddddd00dd0000d00d000000ddddd00dd00dd00dd00d0000ddd00ddd0000000ddd0000ddd0000000000000000000
dddddddd0dddddddddddddd0dd000000000000dd00dd00dd000000000000dddddd00dd0000dd00dd00000dddddd00000000dd000000dd0000000000000000000
ddddddddddddddddddddddddd00000000000000d00dd00dd000000000000dddd0dd00dd00dd00dd0000000dddd000000000dd000000dd0000000000000000000
eeeeeeee0000000ee0000000eeeeeeeeeeeeeeeeee00ee0000000000eeee000000ee00eeee00ee00ee000000000000ee0000000000000000000ee000000ee000
eeeeeeee000000eeee000000eeeeeee00eeeeeeeee00ee0000000000eeee0000e00ee00ee00ee00eeee0000000000eee0000000000000000000ee000000ee000
eeeeeeee00000eeeeee00000eeeeee0000eeeeee00ee00ee00e00e00eeee0000ee00ee0000ee00ee0eee00000000eee00000000000000000000eee0000eee000
eeeeeeee0000eeeeeeee0000eeeee000000eeeee00ee00ee000ee000eeee00000ee00ee00ee00ee000eee000000eee0000000eeeeee000000000eeeeeeee0000
eeeeeeee000eeeeeeeeee000eeee00000000eeeeee00ee00000ee0000000eeee00ee00eeee00ee00000eee0000eee0000000eeeeeeee000000000eeeeee00000
eeeeeeee00eeeeeeeeeeee00eee0000000000eeeee00ee0000e00e000000eeeee00ee00ee00ee00e0000eee00eee0000000eee0000eee0000000000000000000
eeeeeeee0eeeeeeeeeeeeee0ee000000000000ee00ee00ee000000000000eeeeee00ee0000ee00ee00000eeeeee00000000ee000000ee0000000000000000000
eeeeeeeeeeeeeeeeeeeeeeeee00000000000000e00ee00ee000000000000eeee0ee00ee00ee00ee0000000eeee000000000ee000000ee0000000000000000000
ffffffff0000000ff0000000ffffffffffffffffff00ff0000000000ffff000000ff00ffff00ff00ff000000000000ff0000000000000000000ff000000ff000
ffffffff000000ffff000000fffffff00fffffffff00ff0000000000ffff0000f00ff00ff00ff00ffff0000000000fff0000000000000000000ff000000ff000
ffffffff00000ffffff00000ffffff0000ffffff00ff00ff00f00f00ffff0000ff00ff0000ff00ff0fff00000000fff00000000000000000000fff0000fff000
ffffffff0000ffffffff0000fffff000000fffff00ff00ff000ff000ffff00000ff00ff00ff00ff000fff000000fff0000000ffffff000000000ffffffff0000
ffffffff000ffffffffff000ffff00000000ffffff00ff00000ff0000000ffff00ff00ffff00ff00000fff0000fff0000000ffffffff000000000ffffff00000
ffffffff00ffffffffffff00fff0000000000fffff00ff0000f00f000000fffff00ff00ff00ff00f0000fff00fff0000000fff0000fff0000000000000000000
ffffffff0ffffffffffffff0ff000000000000ff00ff00ff000000000000ffffff00ff0000ff00ff00000ffffff00000000ff000000ff0000000000000000000
fffffffffffffffffffffffff00000000000000f00ff00ff000000000000ffff0ff00ff00ff00ff0000000ffff000000000ff000000ff0000000000000000000
__gff__
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__map__
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000010100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000100020505050000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000303050500050500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000050304040300050500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0505050404040404030502020200000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000040404030303020200000200000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000303030303040000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000303030300000303030303000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000030303030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__sfx__
000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__music__
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
