// Let's see if I get it up and running in time...
// ALAKIS
// (10,2..22,3: 13x2/104x16)

#include <interrupt.h>
#include <msxlib.h>
#include "ArkosTrackerPlayer_MSX.h"

#define SPRITES 24

extern unsigned char nimi1[],nimi2[],scroll[],konvehti[];

extern int feidi[768+1],scrollx;

static unsigned char scrollbuf[13*16],
				     destbuf[13*20],
					 spr[SPRITES*4],
					 confetticol[]={2,3,4,5, 8,9,11,13};

static int curve[]={13,0,0,0, 13,26,39,26, 13,0,0,13, 26};
static char *luukap[13*16];

static char msx1[]={ // Approximate MSX1 palette
                0,0,0,
                3,6,3,
                4,7,4,
                3,3,6,
                4,4,7,

                6,2,2,
                4,7,7,
                7,3,3,
                7,4,4,
                6,5,2,

                6,6,3,
                1,5,1,
                6,3,6,
                6,6,6,
                7,7,7
                };

volatile int vbicount=0;

void my_isr(void) interrupt
{
	DI;
	READ_VDP_STATUS;

	PLY_Play();
	PLY_SendRegisters();

	vbicount++;

	EI;
}

// Show one block
void putplok(int idx)
{
	int off=((idx&31)<<3)+(idx>>5<<8);

	vdp_address(PATTERN_TABLE+off);
	vdp_slowcopy(&nimi1[off],8);
	vdp_address(COLOR_TABLE+off);
	vdp_slowcopy(&nimi2[off],8);
}

void curvecopy(void);
void shift(void);
void dumppa(unsigned char *ohvi);

void main(void)
{
	int i,j,k,feididx=0,
		scroll_idx=0;

	unsigned char scroll_col=0,
				  c,d,feididone=0,
				  *p,*p2;

	spindown();
	screen(2);

	if(isvdp2())
    {
        msx2_sethz(50);
        for(i=0;i<15;i++)
            msx2_palette(i+1,msx1[i*3+0],msx1[i*3+1],msx1[i*3+2]);
    }

	// Clrscr
	DI;
	vdp_register(VDP_COLOR,BLACK);
	vdp_address(COLOR_TABLE);
	vdp_slowset(FG_BLACK+CYAN,6*1024);
	vdp_address(PATTERN_TABLE);
	vdp_slowset(0,6*1024);
	EI;

	for(i=0;i<13*8;i++)
		nimi2[10*8+2*32*8+i]=nimi2[10*8+3*32*8+i]=FG_WHITE+LIGHT_RED;

	for(i=0;i<13*16;i++)
		scrollbuf[i]=0;
	for(i=0;i<13*20;i++)
		destbuf[i]=0;

	for(i=k=0;i<16;i++)
	{
		for(j=0;j<13;j++,k++)
			luukap[k]=&destbuf[k+curve[j]];
	}

	// Sprite setup
	DI;
	for(i=0;i<SPRITES*4;i+=4)
	{
		spr[i]=(i*192/SPRITES+(random()&8))&0xfe;
		spr[i+1]=0;
		spr[i+2]=i%14;
		spr[i+3]=0x80;
	}

	vdp_address(SPRITE_PATTERN_TABLE);
	vdp_slowcopy(konvehti,14*8);

	EI;

	PLY_SongPtr = (char *)0x0103;
	PLY_Init();

	for(i=0;i<2*50;i++)
		waitVB();

	install_isr(my_isr);

	while(!space())
	{
		waitVB();
		vdp_register(VDP_COLOR,BLACK);

		// Scroller: dump buffer
		if(vbicount>150)
		{
			vdp_address(PATTERN_TABLE+10*8+2*32*8);
			dumppa(destbuf);
			vdp_address(PATTERN_TABLE+10*8+3*32*8);
			dumppa(destbuf+13*8);
		}

		// Let's do sprites here
		if(feididone)
		{
			//vdp_register(VDP_COLOR,LIGHT_BLUE);

			vdp_address(SPRITE_ATT_TABLE);
			vdp_copy(spr,SPRITES*4);

			for(i=0,j=0;i<SPRITES;i++,j+=4)
			{
				if(i&1)
				{
					if(vbicount&1)
						spr[j]++;
				}
				else
					spr[j]++;

				if((vbicount&7)==0)
					spr[j+2]++;
				if(spr[j+2]==14)
					spr[j+2]=0;

				if(spr[j]==192)
				{
					spr[j]=248;
					spr[j+1]=random();
					spr[j+3]=confetticol[random()&7];
				}
			}
		}

		// Scroller: Move buf one bit left
		//vdp_register(VDP_COLOR,DARK_RED);
		if(vbicount>150)
		{
			shift();

			// Draw new pixel column
			d=0x80>>scroll_col;
			p=&scroll[scroll_idx];
			p2=&scrollbuf[12];

			for(c=0;c<16;c++,p++,p2+=13)
				if(*p&d)
					*p2|=1;
				else
					*p2&=0xfe;

			// Advance scroll counters
			scroll_col++;
			if(scroll_col==8)
			{
				scroll_col=0;
				scroll_idx+=16;
				if(scroll_idx==scrollx*16)
					scroll_idx=0;
			}
		}

		//vdp_register(VDP_COLOR,RED);
		if(feidi[feididx]!=-1) // fade in
			putplok(feidi[feididx++]);
		else
			feididone=1;

		//vdp_register(VDP_COLOR,DARK_BLUE);
		curvecopy();

		//vdp_register(VDP_COLOR,BLACK);
	}

	waitVB();
	uninstall_isr();
	PLY_Stop();
	PLY_SendRegisters();
	screen(0);
}

// When you don't want to do things right... copy a buffer along a curve
void curvecopy(void)
{
	__asm

	push	hl
	push	de
	push	bc

	ld		hl,#_luukap
	ld		bc,#_scrollbuf
	ld		a,#13*8

l4:
	ex		af,af

	ld		a,(bc)
	inc		bc
	ld		e,(hl)
	inc		hl
	ld		d,(hl)
	inc		hl
	ld		(de),a

	ld		a,(bc)
	inc		bc
	ld		e,(hl)
	inc		hl
	ld		d,(hl)
	inc		hl
	ld		(de),a

	ex		af,af
	dec		a
	jr		nz,l4

	pop		bc
	pop		de
	pop		hl
	__endasm;
}

// Shift scroll buffer one pixel left
void shift(void)
{
	__asm
	push	hl
	push	de
	push	bc

	ld		hl,#_scrollbuf+13*16-1
	ld		b,#13*4

l3:	ld		a,(hl)
	rla
	ld		(hl),a
	dec		hl
	ld		a,(hl)
	rla
	ld		(hl),a
	dec		hl
	ld		a,(hl)
	rla
	ld		(hl),a
	dec		hl
	ld		a,(hl)
	rla
	ld		(hl),a
	dec		hl

	djnz	l3

	pop		bc
	pop		de
	pop		hl
	__endasm;
}

// Dump scroll buffer on the screen
void dumppa(unsigned char *ohvi)
{
	ohvi;
	__asm
	push	hl
	push	de
	push 	bc

	ld	l,4(ix)
	ld	h,5(ix)
	ld	c,#13

l1: ld de,#13

	ld	a,(hl)
	add	hl,de
	out	(0x98),a
	ld	a,(hl)
	add	hl,de
	out	(0x98),a
	ld	a,(hl)
	add	hl,de
	out	(0x98),a
	ld	a,(hl)
	add	hl,de
	out	(0x98),a

	ld	a,(hl)
	add	hl,de
	out	(0x98),a
	ld	a,(hl)
	add	hl,de
	out	(0x98),a
	ld	a,(hl)
	add	hl,de
	out	(0x98),a
	ld	a,(hl)
	add	hl,de
	out	(0x98),a

	scf
	ccf
	ld	de,#13*8-1
	sbc	hl,de
	dec	c
	jr	nz,l1

	pop	bc
	pop	de
	pop	hl
	__endasm;
}
