var Demo = function() {
}

	var bpm = 125;
	var beat = 60/bpm;
	var pattern = beat*8;
	var tick = beat/4;

	

Demo.prototype.init = function()
{
this.kuva(1*beat,6*beat,"data/part0.png");
this.kuva(2*pattern+1*beat,7*beat,"data/jumalauta_presents.png");
this.kuva(3*pattern+1*beat,7*beat,"data/full_spectrum.png");
this.kuva(4*pattern+1*beat,7*beat,"data/part1.png");  
this.kuva(13*pattern+1*beat,7*beat,"data/part3.png");  
this.kuva(22*pattern+1*beat,7*beat,"data/part4.png");  
this.kuva(29*pattern+1*beat,7*beat,"data/part5.png");  

	this.loader.addAnimation([
		{
			"start": 0, "duration":42*pattern
			,"layer": 49999, "image": ["data/vignette.png"]
			,"scale":[{"x":1.0,"y":1.0}]
		}]);


this.sadness(5*pattern);
this.love(pattern*14);
this.hate(pattern*23);
this.joy(pattern*30);
this.distortion(0,pattern*38.5,0,50000,50002);

this.loader.addAnimation([
		{
			"start": 38*pattern+2*beat, "duration":4*pattern
			,"layer": 49999, "image": ["data/end.png"]
			,"scale":[{"x":1.3,"y":1.3}]
		}]);
		
/*
this.glow(0,pattern*40,50001,50004,50012);
this.brightnessContrast(0,pattern*40,50010,50015,50017,0.1,2);
*/

this.glow(0,pattern*38.5,50006,50010,50019);
this.brightnessContrast(0,pattern*38.5,50001,50004,50007,0.1,2);

}

Demo.prototype.kuva = function(startTime, duration, pic)
{
	this.loader.addAnimation([
		{
			"start": startTime, "duration":duration
			,"layer": 65500, "image": [pic]
			,"scale":[{"x":1.5,"y":1.5}]
		}]);
}
Demo.prototype.sadness = function(startTime)
{

	this.loader.addAnimation([
		{
			"start": startTime, "duration":8*pattern+2*beat
			,"layer": 5500, "image": ["data/white.png"]
			,"scale":[{"x":1.0,"y":1.0}]
			,"color":[{"r":11,"g":66,"b":255}
			,{"duration":8*pattern,"a":255}
			,{"duration":2*beat,"a":0}]
		}]);
		

		for (var i = 0; i < 16; i++)
	{
		for (var ii = 0; ii < i+1; ii++)
	{
		this.loader.addAnimation([
			{
				"start": startTime+(beat*i), "duration":2*beat
				,"layer": 45500, "image": ["data/sadface.png"]
						,"scale":[{"x":0.25,"y":0.25}
						,{"duration":2*beat,"x":0.0,"y":0.0}]
						,"position":[{"x":Math.random()*1080+100,"y":Math.random()*520+100,"z":0}]
						,"color":[{"a":255,"r":255*(ii%2),"g":255*(ii%2),"b":255*(ii%2)}
						,{"duration":2*beat,"a":0}
						]
			}
			]);
	}
	}



	
		for (var i = 0; i < 15; i++)
	{
	this.loader.addAnimation([
		{
			"start": startTime+pattern*6+beat*i, "duration":pattern*.5
			,"layer": 45500, "image": ["data/hirsi.png"]
					,"scale":[{"x":0.25,"y":0.25}
					,{"duration":.5*pattern,"x":3.5,"y":3.5}]
					,"position":[{"x":640,"y":480,"z":0}
					,{"duration":.5*pattern,"x":640,"y":990}]
					,"color":[{"a":55}
					,{"duration":.25*pattern,"a":255}
					,{"duration":.25*pattern,"a":0}
					]
		}
		]);
	}

			for (var ii = 0; ii < 4; ii++)
	{
	
			for (var i = 0; i < 16; i++)
	{
	var localRandom = Math.random();
	this.loader.addAnimation([
		{
			"start": startTime+pattern*2+beat*i, "duration":pattern
			,"layer": 45500, "image": ["data/razor.png"]
					,"scale":[{"x":0.25,"y":0.25}
					,{"duration":1*pattern,"x":.5,"y":0.5}]
					,"angle": [{"degreesZ":Math.random()*360}
					,{"duration":1*pattern,"degreesZ":Math.random()*360}]
					,"position":[{"x":1280*localRandom,"y":720,"z":0}
					,{"duration":1*pattern,"x":1280*localRandom,"y":0}]
					,"color":[{"a":55}
					,{"duration":.5*pattern,"a":255}
					,{"duration":.5*pattern,"a":0}
					]
		}
		]);
	}
	}
	
		this.loader.addAnimation([
		{
			"start": startTime+pattern*4, "duration":pattern*2
			,"layer": 45500, "image": ["data/wrist.png"]
					,"scale":[{"x":0.35,"y":0.35}
					,{"duration":beat,"x":1.0,"y":1.0}]
					,"position":[{"x":640,"y":0,"z":0}
					,{"duration":beat,"x":640,"y":320}]
					,"color":[{"a":255}]
		}
		]);
		
			this.loader.addAnimation([
		{
			"start": startTime+pattern*4, "duration":2*pattern
			,"layer": 46500, "image": ["data/razor.png"]
			,"scale":[{"x":0.3,"y":0.3}]
			,"color":[{"r":0,"g":0,"b":0}]
			,"position":[{"x":680,"y":340}
			,{"duration":0.5*beat,"x":600,"y":340}
			,{"duration":0.5*beat,"x":600,"y":340}
			,{"duration":0.5*beat,"x":680,"y":340}
			,{"duration":0.5*beat,"x":680,"y":340}
			,{"duration":0.5*beat,"x":600,"y":340}
			,{"duration":0.5*beat,"x":600,"y":340}
			,{"duration":0.5*beat,"x":680,"y":340}
			,{"duration":0.5*beat,"x":680,"y":340}
			,{"duration":0.5*beat,"x":600,"y":340}
			,{"duration":0.5*beat,"x":600,"y":340}
			,{"duration":0.5*beat,"x":680,"y":340}
			,{"duration":0.5*beat,"x":680,"y":340}
			,{"duration":0.5*beat,"x":600,"y":340}
			,{"duration":0.5*beat,"x":600,"y":340}
			,{"duration":0.5*beat,"x":680,"y":340}
			,{"duration":0.5*beat,"x":680,"y":340}

			,{"duration":0.5*beat,"x":600,"y":340}
			,{"duration":0.5*beat,"x":600,"y":340}
			,{"duration":0.5*beat,"x":680,"y":340}
			,{"duration":0.5*beat,"x":680,"y":340}
			,{"duration":0.5*beat,"x":600,"y":340}
			,{"duration":0.5*beat,"x":600,"y":340}
			,{"duration":0.5*beat,"x":680,"y":340}
			,{"duration":0.5*beat,"x":680,"y":340}
			,{"duration":0.5*beat,"x":600,"y":340}
			,{"duration":0.5*beat,"x":600,"y":340}
			,{"duration":0.5*beat,"x":680,"y":340}
			,{"duration":0.5*beat,"x":680,"y":340}
			,{"duration":0.5*beat,"x":600,"y":340}
			,{"duration":0.5*beat,"x":600,"y":340}
			,{"duration":0.5*beat,"x":680,"y":340}
			,{"duration":0.5*beat,"x":680,"y":340}					
			]
		}]);
		
			this.loader.addAnimation([
		{
			"start": startTime+pattern*7+beat*7, "duration":pattern*.5
			,"layer": 45500, "image": ["data/hauta.png"]
					,"scale":[{"x":0.01,"y":0.01}
					,{"duration":.5*pattern,"x":1.0,"y":1.0}]
					,"position":[{"x":640,"y":300,"z":0}
					,{"duration":.5*pattern,"x":640,"y":300}]
					,"color":[{"a":55}
					,{"duration":.05*pattern,"a":255}
					,{"duration":.25*pattern,"a":0}
					]
		}
		]);
}


Demo.prototype.love = function(startTime)
{
	this.loader.addAnimation([
		{
			"start": startTime, "duration":8*pattern
			,"layer": 5500, "image": ["data/white.png"]
			,"scale":[{"x":1.0,"y":1.0}]
			,"color":[{"r":237,"g":24,"b":254}]
		}]);
//Many hearts


for (var iii = 0; iii < 12; iii++)
	{
	for (var ii = 0; ii < 4; ii++)
		{
			for (var i = 0; i < 5+6*iii+ii; i++)
			{
			var scaleRandom=Math.random();
					this.loader.addAnimation([
					{
					"start": startTime+ii*3*tick+iii*pattern*0.5, "duration": 3*tick, "object":"data/heart.obj"
					,"layer": 20000
					,"position": [{"z":-300-600*Math.random(),"y":-250+Math.random()*500,"x":-400+Math.random()*800}
					/*,"duration":3*tick, */]
					,"angle": [{"degreesX":90,"degreesY":180,"degreesZ":0}, {"duration":0.5*pattern, "degreesY":Math.random()*720-360,"degreesZ":Math.random()*720-360,"degreesZ":Math.random()*720-360}]
					,"scale": [
							{"x":66.5*scaleRandom+iii*5,"y":66.5*scaleRandom+iii*5,"z":66.5*scaleRandom+iii*5}
						]
					}]);
			}
		}
	}

	//heart tunnel
	var parilliset;
		for (var i = 0; i < 16; i++)
			{
		this.loader.addAnimation([
		{
			"start": startTime+pattern*6+i*beat, "duration":pattern
			,"layer": 45000+i, "image": ["data/heart.png"]
					,"angle": [{"degreesZ":Math.random()*360}
					,{"duration":1*pattern,"degreesZ":Math.random()*360}]
					,"scale":[{"x":0.005,"y":0.005}
					,{"duration":0.5*pattern,"x":3.5,"y":3.5}]
					,"position":[{"x":640,"y":360,"z":0}
					,{"duration":pattern,"x":640,"y":360}]
					,"color":[{"a":55,"g":255*(i%2),"b":255*(i%3)}
					,{"duration":.1*pattern,"a":255}
					,{"duration":.5*pattern,"a":0}

					]
		}]);
		
		}
for (var i = 0; i<16; i++)
{
	this.loader.addAnimation([
		{
			"start": startTime+6*pattern+i*beat+0.25*beat, "duration":beat
			,"layer": 46000, "image": ["data/lovehand.png"]
			,"scale":[{"x":-1.0,"y":1.0}]
			,"color":[{"r":0,"g":0,"b":0}]
			,"position":[{"x":1830,"y":360}
			,{duration:1*tick,"x":1130,"y":360}
			,{duration:1*tick,"x":1130,"y":360}
			,{duration:2*tick,"x":1830,"y":360}]
		}]);

	this.loader.addAnimation([
		{
			"start": startTime+6*pattern+i*beat+.25*beat, "duration":beat
			,"layer": 46000, "image": ["data/lovehand.png"]
			,"scale":[{"x":1.0,"y":1.0}]
			,"color":[{"r":0,"g":0,"b":0}]
			,"position":[{"x":-550,"y":360}
			,{duration:1*tick,"x":150,"y":360}
			,{duration:1*tick,"x":150,"y":360}
			,{duration:2*tick,"x":-550,"y":360}]
		}]);
}
	
}

Demo.prototype.hate = function(startTime)
{
	this.loader.addAnimation([
		{
			"start": startTime, "duration":6*pattern
			,"layer": 35500, "image": ["data/baphometbg.png"]
			,"scale":[{"x":1.0,"y":1.0}
			,{"duration":6*pattern,"x":1.1,"y":1.1}]
			,"color":[{"r":255,"g":0,"b":0}]
		}]);
	this.loader.addAnimation([
    {
         "start": startTime, "duration":6*pattern
        ,"layer": 40000, "image": ["data/noise.png","data/noise.png"]
		,"scale":[{"x":1.0,"y":1.0}]
     ,"shader":{
            "name":"data/shader/fire.fs",
            "variable":[
                  {"name":"time","value":["{return getSceneTimeFromStart();}"]}
            ]
        }
		
    }
]);
			for (var i = 0; i < 8; i++)
	{
	var localRandom = Math.random();
	this.loader.addAnimation([
		{
			"start": startTime+2*beat*i, "duration":2.5*pattern
			,"layer": 45500, "image": ["data/pentagram.png"]
					,"scale":[{"x":1.25,"y":1.25}
					,{"duration":1*pattern,"x":.5,"y":0.5}]
					,"angle": [{"degreesZ":Math.random()*360}
					,{"duration":1*pattern,"degreesZ":Math.random()*360}]
					,"position":[{"x":1280*localRandom,"y":720,"z":0}
					,{"duration":1*pattern,"x":1280*localRandom,"y":0}]
					,"color":[{"a":55}
					,{"duration":.5*pattern,"a":255}
					,{"duration":.5*pattern,"a":0}
					]
		}
		]);
	}
				for (var i = 0; i < 8; i++)
	{
	var localRandom = Math.random();
	this.loader.addAnimation([
		{
			"start": startTime+2*pattern+2*beat*i, "duration":2.5*pattern
			,"layer": 45500, "image": ["data/swastika.png"]
					,"scale":[{"x":1.25,"y":1.25}
					,{"duration":1*pattern,"x":.5,"y":0.5}]
					,"angle": [{"degreesZ":Math.random()*360}
					,{"duration":1*pattern,"degreesZ":Math.random()*360}]
					,"position":[{"x":1280*localRandom,"y":720,"z":0}
					,{"duration":1*pattern,"x":1280*localRandom,"y":0}]
					,"color":[{"a":55}
					,{"duration":.5*pattern,"a":255}
					,{"duration":.5*pattern,"a":0}
					]
		}
		]);
	}
	
			for (var i = 0; i < 8; i++)
	{
	var localRandom = Math.random();
	this.loader.addAnimation([
		{
			"start": startTime+4*pattern+2*beat*i, "duration":2.5*pattern
			,"layer": 45500, "image": ["data/kewlers.png"]
					,"scale":[{"x":1.25,"y":1.25}
					,{"duration":1*pattern,"x":.5,"y":0.5}]
					,"angle": [{"degreesZ":Math.random()*360}
					,{"duration":1*pattern,"degreesZ":Math.random()*360}]
					,"position":[{"x":1280*localRandom,"y":720,"z":0}
					,{"duration":1*pattern,"x":1280*localRandom,"y":0}]
					,"color":[{"a":55}
					,{"duration":.5*pattern,"a":255}
					,{"duration":.5*pattern,"a":0}
					]
		}
		]);
	}
		
}


Demo.prototype.joy = function(startTime)
{

	
	this.loader.addAnimation([
		{
			"start": startTime+4*pattern, "duration":4*pattern
			,"layer": 35400, "image": ["data/white.png"]
			,"scale":[{"x":1.0,"y":1.0}]
			,"color":[{"r":0,"g":255,"b":255}]
		}]);
	this.loader.addAnimation([
		{
			"start": startTime+4*pattern, "duration":4*pattern
			,"layer": 35404, "image": ["data/spiral.png"]
			,"scale":[{"x":1.2,"y":1.2}]
			,"color":[{"r":255,"g":255,"b":255}]
			,"angle": [{"degreesZ":0}
			,{"duration":6*pattern,"degreesZ":1440}]
					
		}]);
		
for (var i = 0; i < 4; i++)
{
	
	this.loader.addAnimation([
		{
			"start": startTime+i*pattern, "duration":0.75*pattern
			,"layer": 35400, "image": ["data/joybg.png"]
			,"scale":[{"x":1.0,"y":1.0}
			,{"duration":6*pattern,"x":1.1,"y":1.1}]
			,"color":[{"r":255,"g":255,"b":255}]
		}]);
			this.loader.addAnimation([
		{
			"start": startTime+i*pattern, "duration":2*beat
			,"layer": 35501, "image": ["data/joy1.png"]
			,"scale":[{"x":2.0,"y":2.0}
			,{"duration":2*beat,"x":1.1,"y":1.1}]
			,"color":[{"r":0,"g":0,"b":0}]
			,"position":[{"x":640,"y":-300}
			,{"duration":1*tick,"x":640,"y":460}
			,{"duration":7*tick,"x":640,"y":-300}
			]
		}]);

		this.loader.addAnimation([
		{
			"start": startTime+2*beat+i*pattern, "duration":2*beat
			,"layer": 35501, "image": ["data/joy2.png"]
			,"scale":[{"x":2.0,"y":2.0}
			,{"duration":2*beat,"x":1.1,"y":1.1}]
			,"color":[{"r":0,"g":0,"b":0}]
		,"position":[{"x":640,"y":-300}
			,{"duration":1*tick,"x":640,"y":460}
			,{"duration":7*tick,"x":640,"y":-300}
			]

		}]);
		this.loader.addAnimation([
		{
			"start": startTime+4*beat+i*pattern, "duration":2*beat
			,"layer": 35501, "image": ["data/joy3.png"]
			,"scale":[{"x":2.0,"y":2.0}
			,{"duration":2*beat,"x":1.1,"y":1.1}]
			,"color":[{"r":0,"g":0,"b":0}]
		,"position":[{"x":640,"y":-300}
			,{"duration":1*tick,"x":640,"y":460}
			,{"duration":7*tick,"x":640,"y":-300}
			]
		}]);	
	}
	for (var i = 0; i<8;i++)
	{
		this.loader.addAnimation([
		{
			"start": startTime+6*pattern+beat*i+2*tick, "duration":2*tick
			,"layer": 45502, "image": ["data/happyface.png"]
			,"scale":[{"x":0.666,"y":0.666}
			,{"duration":2*beat,"x":0.5,"y":0.5}]
			,"color":[{"r":255,"g":255,"b":255}]
		}]);	
	}

	for (var i =0; i<16;i++)
	{
				this.loader.addAnimation([
				{
				"start": startTime+pattern*4+beat*i, "duration": beat, "object":"data/dollar.obj"
				,"layer": 40000
				,"position": [{"z":-100,"y":0,"x":0}
				/*,"duration":3*tick, */]
				,"angle": [{"degreesX":-90+90*Math.random()-90*Math.random(),"degreesY":180+90*Math.random()-90*Math.random(),"degreesZ":90*Math.random()-90*Math.random()}, {"duration":beat, "degreesX":-90,"degreesY":180,"degreesZ":0}]
				,"scale": [
						{"x":90+40*Math.random(),"y":90+40*Math.random(),"z":90+40*Math.random()}
					]
			}]);

			this.loader.addAnimation([
			{
				"start": startTime+4*pattern+beat*i+2*tick, "duration":2*tick
				,"layer": 45502, "image": ["data/white.png"]
				,"scale":[{"x":1.0,"y":1.0}
				,{"duration":2*beat,"x":1.0,"y":1.0}]
				,"color":[{"r":0,"g":0,"b":0,"a":200}
				,{"duration":2*tick,"a":0}]

			}]);	

	}

	for (var ii = 0; ii < 2; ii++)
		{
			for (var i = 0; i < 8; i++)
			{
				for (var iii=0; iii<10;iii++)
				{
			var scaleRandom=Math.random();
					this.loader.addAnimation([
					{
					"start": startTime+pattern*ii+6*pattern+beat*i, "duration": beat, "object":"data/dollar.obj"
					,"layer": 40000
					,"position": [{"z":-100-500*Math.random(),"y":-250+Math.random()*500,"x":-400+Math.random()*800}
					/*,"duration":3*tick, */]
					,"angle": [{"degreesX":90,"degreesY":180,"degreesZ":0}, {"duration":0.5*pattern, "degreesY":Math.random()*720-360,"degreesZ":Math.random()*720-360,"degreesZ":Math.random()*720-360}]
					,"scale": [
							{"x":200*scaleRandom,"y":200*scaleRandom,"z":200*scaleRandom}
						]
					}]);
			}
		}
		}
		
}


Demo.prototype.distortion = function(startTime, duration, startLayer, endLayer, layer)
{
	this.loader.addAnimation ([
	{
	"start": startTime, "duration": duration
	,"layer": startLayer
	,"fbo":{"name":"fbodist","action":"begin"}
	},
	{
	"start": startTime, "duration": duration
	,"layer": endLayer,"fbo":{"name":"fbodist","action":"unbind"}
	}
	]);
	this.loader.addAnimation ([
	{
		 "start": startTime, "duration": duration
		,"image": "fbodist.color.fbo"
		,"layer": layer
		,"shader":{"name":"data/shader/distortion.fs",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
				,{"name":"timeMultiplier","value":[20.9]}
				,{"name":"pixelSize","value":[0.007,0.001]}
				,{"name":"noiseWaveSpeed","value":[-3]}
				,{"name":"noiseWaveSize","value":[5]}
				,{"name":"noiseLuminance","value":[1]}
				,{"name":"noiseAlpha","value":[0.02]}
				,{"name":"colorComponentDistortionX","value":[0.02,0.02,0.02,0.02]}
				,{"name":"colorComponentDistortionY","value":[0.02,0.02,0.02,0.02]}
			]
			}
		}]);
}

Demo.prototype.glow = function(startTime, duration, startLayer, endLayer, layer)
{
this.loader.addAnimation([
	//render contents rendered in layers 00000 - 00050 to FBO "fbo"
	{
		 "start": startTime, "duration":duration
		,"layer": startLayer
		,"fbo":{"name":"fboGlow","action":"begin"}
	},
	{
		 "start": startTime, "duration":duration
		,"layer": endLayer
		,"fbo":{"name":"fboGlow","action":"unbind"}
	},
	//Render "fbo" via Glow shader (first pass) to "fbo2"
	{
		 "start": startTime, "duration":duration
		,"layer": layer-4
		,"fbo":{"name":"fboGlow2","action":"begin"}
	},
	{
		"start": startTime, "duration":duration
		,"layer": layer-3
		,"fbo":{"name":"fboGlow","action":"draw"}
		,"shader":{"name":"data/shader/glow.fs","variable":[
					 {"name":"direction","value":[0,1]}
					,{"name":"alpha","value":[0.5]}
					,{"name":"spread","value":[0.0025]}
					,{"name":"intensity","value":[0.15]}
					,{"name":"samples","type":"int","value":[15]}
				]}
	},
	{
		 "start": startTime, "duration":duration
		,"layer": layer-2
		,"fbo":{"name":"fboGlow2","action":"unbind"}
	},
	//Draw the original "fbo" to screen
	{
		 "start": startTime, "duration":duration
		,"layer": layer-1
		,"fbo":{"name":"fboGlow","action":"draw"}
		,"color": [
				 {"r":255,"g":0,"b":0}
			]
	},
	//Draw "fbo2" via Glow shader (second pass) to screen
	{
			"start": startTime, "duration":duration
		,"layer": layer
		,"fbo":{"name":"fboGlow2","action":"draw"}
		,"shader":{"name":"data/shader/glow.fs","variable":[
					 {"name":"direction","value":[1,0]}
					,{"name":"alpha","value":[0.7]}
					,{"name":"spread","value":[0.0025]}
					,{"name":"intensity","value":[0.35]}
					,{"name":"samples","type":"int","value":[15]}
				]}
	}
	]);
}


Demo.prototype.brightnessContrast = function (startTime, duration, startLayer, endLayer, layer, brightness, contrast)
{
	this.loader.addAnimation ([
	{
	"start": startTime, "duration": duration
	,"layer": startLayer
	,"fbo":{"name":"fbobc","action":"begin"}
	},
	{
	"start": startTime, "duration": duration
	,"layer": endLayer,"fbo":{"name":"fbobc","action":"unbind"}
	}
	]);
	this.loader.addAnimation ([
	    {
	         "start": startTime, "duration":duration
	        ,"layer": layer, "image": ["fbobc.color.fbo"]
		 ,"initFunction":"{fboBcImage = imageLoadImage('fbobc.color.fbo'); setTextureSizeToScreenSize(fboBcImage.ptr); }"
		 ,"runFunction":"{setTextureSizeToScreenSize(fboBcImage.ptr);}"
	     ,"shader":{
	            "name":"data/shader/brightnesscontrast.fs",
	            "variable":[
	                  {"name":"time","value":["{return getSceneTimeFromStart();}"]}
	                 ,{"name":"brightness","value":[brightness]}
					 ,{"name":"contrast","value":[contrast]}
	            ]
	        }
	    }
	]);
}