#version 330 core

in vec2 UV;
out vec4 fragColor;

uniform float iGlobalTime;
#define iTime iGlobalTime
uniform vec2 iResolution;
uniform sampler2D iChannel0;

uniform float camdist;

// original created by florian berger (flockaroo) - 2017 ("mud planet")
// modified by noby
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

#define MAX_RADIUS 400.
#define PI 3.14159265359

vec2 sph2frag(vec3 p)
{
	float r = min(iResolution.x/4.,MAX_RADIUS);
    vec2 center = vec2(r,r);
    p=normalize(p);
    if(p.z<0.0) center.x += 2.*r;
    return center+sqrt(1.-abs(p.z))*normalize(p.xy)*r;
}

float dist(vec3 pos)
{
    vec3 pos0=pos;
    pos-=min(vec3(1), (texture(iChannel0,sph2frag(pos)/iResolution.xy).xyz-.5)*0.6);
    float d = 10.0;
	d=min(d,length(pos)-1.);
        
    return d;
}

vec3 getGrad(vec3 pos, float eps)
{
    vec2 d=vec2(eps,0);
    float d0=dist(pos);
    return vec3(dist(pos+d.xyy)-d0,
                dist(pos+d.yxy)-d0,
                dist(pos+d.yyx)-d0)/eps;
                
}

float err(float dist){
    const float E = 0.01;
    dist = dist/100.0;
    return min(E, dist*dist);
}

vec3 discontinuity_reduction(vec3 origin, vec3 direction, vec3 position){
    const int iterations = 4;
    for(int i = 0; i < iterations; i++){
        position = position + direction * (dist(position) - err(distance(origin, position)));
    }
    return position;
}

// march it...
vec4 march(inout vec3 pos, vec3 dir)
{
    //pos += vec3(0,0,0.8);
    vec3 op = pos;
    // cull the sphere
    if(length(pos-dir*dot(dir,pos))>1.3) 
    	return vec4(0,0,1,1);
    
    float eps=0.01;
    float bg=1.0;
    for(int cnt=0;cnt<200;cnt++)
    {
        float d = dist(pos);
        pos+=d*dir*0.5;
        if(d<eps) { bg=0.0; break; }
    }
    pos = discontinuity_reduction(op, dir, pos);
    vec3 n = getGrad(pos,.001);
    //if(dot(n,n)<.0001) n=vec3(0,0,1);
    return vec4(n,bg); // .w=1 => background
}

// march it...
vec4 marci(inout vec3 pos, vec3 dir)
{
    vec3 op = pos;
    // cull the sphere
    if(length(pos-dir*dot(dir,pos))>1.3) 
    	return vec4(0,0,1,1);
    
    float eps=0.001;
    float bg=1.0;
    for(int cnt=0;cnt<200;cnt++)
    {
        float d = dist(pos);
        pos+=d*dir;
        if(d<eps||d>0.0) { bg=0.0; break; }
    }
    pos = discontinuity_reduction(op, dir, pos);
    vec3 n = getGrad(pos,.001);
    //if(dot(n,n)<.0001) n=vec3(0,0,1);
    return vec4(n,bg); // .w=1 => background
}

mat3 rotX(float ang)
{
    float c=cos(ang), s=sin(ang);
    return mat3(1,0,0, 0,c,s, 0,-s,c);
}

mat3 rotZ(float ang)
{
    float c=cos(ang), s=sin(ang);
    return mat3(c,s,0, -s,c,0, 0,0,1);
}

vec3 getSun()
{
    float phi=.2*iGlobalTime;
    float phi2=.17*cos(phi);
    vec3 sun=vec3(0,0,1);
    return sun;
}


void main()
{
    //if(mod(float(iFrame), 3.0) < 1.0) discard;
    // screen coord -1..1
    vec2 sc = UV*2.-1.;
    // viewer position
    // viewer position
    vec3 pos = vec3(0,-camdist,0);
    // pixel view direction
    vec3 dir = normalize(8.*normalize(-pos)+vec3(sc.x,0,sc.y*iResolution.y/iResolution.x));
    // rotate view around x,z
    float phi = 16.0*0.17;//iMouse.x/iResolution.x*7.;
    float th  = 0.5+0.1*sin(iTime*0.23);//iMouse.y/iResolution.y*7.;
    //if (iMouse.x==0.) { phi=iGlobalTime*.5; th=.27*.5*iGlobalTime; }
    mat3 rx = rotX(th);
    mat3 rz = rotZ(phi);
    pos = rz*(rx*pos);
    dir = rz*(rx*dir);
    vec3 eye = pos+vec3(10,0,0);
    
    vec3 sun = getSun();
    
    // march it...
   	vec4 n=march(pos,dir);
    float bg=n.w;
    
    
	vec3 posi = pos + 0.13*normalize(mix(dir, n.xyz*-1.0, 0.5));
    //posi = pos+n.xyz*-0.1;
    vec3 diri = dir;
    vec4 ni = marci(posi, diri);
    
    float subs = pow(4.0*distance(pos, posi), 2.0);
    vec3 albedo = mix(vec3(0.4,0.5,0.9)*0.5, vec3(0.75,0.85,1.0)*0.95, smoothstep(0.0, 2.0,subs) ).gbr;
    albedo = albedo.xyz;
    //return;
    
    vec3 poss=pos+n.xyz*0.01;
   	vec4 n2=march(poss,sun);
    float shadow = n2.w;
    
    // calc some ambient occlusion
    float ao=1.;
    // calc ao by stepping along normal
    vec3 normal = getGrad(pos,0.1);
    ao*=dist(pos+normalize(normal)*.1)/.1;
    // reflection dir
    vec3 R = pos-2.0*dot(pos,n.xyz)*n.xyz;
    R = -((R*rz)*rx).yzx;
    
    vec3 c = albedo+subs;
    //c *= max(0.0, dist(pos+normalize(sun)*0.5));
    c += max(0.0, 0.2-pow(max(0.0, dot(normal, -dir)), 5.0));
    c *= 0.25+0.75*max(0.0, 0.5+0.5*dot(normal, vec3(0,1,0)));
    
    vec3 light2 = (vec3(-0.0, 4.0, -4.0));
    c += 1.0*pow(max(0.0, dot(normalize(light2-pos), normal)),2.0);
    
    float diff=clamp(clamp(dot(sun,n.xyz)*2.,0.,1.)*shadow+0.3,0.,1.5);
    // apply background
    if(bg>.5) { diff=0.0; ao=1.; }
    float sdot=clamp(dot(sun,dir),0.,1.);
    c=mix(c,vec3(.03,.13,.28),1.-diff);
    
    // apply ambient occlusion
    c*=ao;
    
    // draw sun
    float sunmix=pow(sdot,600.)*2.+.3*sdot;
    c += vec3(1)*bg*sunmix;
    
    c *= 0.2+0.8*max(0.0, dot(sun,normal));
        
    // vignetting
    float vign = (1.06-.3*length(sc.xy));
    c = pow(c, vec3(0.4545));
    c = smoothstep(0.3, 1.1, c*0.9);
    
	fragColor = vec4(0.7*pow(length(c*vign),0.4545));
}