#version 330 core

// inputz
in vec2 UV;

uniform vec2 iResolution;
uniform float iGlobalTime;
uniform vec2 iMouse; //const vec2 iMouse = vec2(0.5);

// outputz
out vec4 fragColor;

float modp(inout vec2 p, float repetitions){
    float angle = 2.*3.14159/repetitions;
    float a = atan(p.y, p.x) + angle/2.;
    float r = length(p);
    float c = floor(a/angle);
    a = mod(a,angle) - angle/2.;
    p = vec2(cos(a), sin(a))*r;
    if (abs(c) >= (repetitions/2.)) c = abs(c);
    return c;
}

#define E 0.005
#define FAR 30.0
#define STEPS 70
float t;


float impulse( float k, float x){
    float h = k*x;
    return h*exp(1.0-h);
}

mat3 rx(float a){return mat3(1.0,0.0,0.0,0.0,cos(a),-sin(a),0.0,sin(a),cos(a));}
mat3 ry(float a){return mat3(cos(a),0,sin(a),0.0,1.0,0.0,-sin(a),0.0,cos(a));}
mat3 rz(float a){return mat3(cos(a),-sin(a),0.0,sin(a),cos(a),0.0,0.0,0.0,1.0);}

float nrand(vec2 n){
    return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}
float n1rand(vec2 n){
    float t = fract( iGlobalTime );
    float nrnd0 = nrand( n + 0.07*t );
    return nrnd0;
}
float n2rand(vec2 n){
    float t = fract( iGlobalTime );
    float nrnd0 = nrand( n + 0.07*t );
    float nrnd1 = nrand( n + 0.11*t );
    return (nrnd0+nrnd1) / 2.0;
}

float sphere(vec3 p, float r){
    return length(p)-r;
}

vec2 mod2(inout vec2 p, vec2 size) {
    vec2 c = floor((p + size*0.5)/size);
    p = mod(p + size*0.5,size) - size*0.5;
    return c;
}

void rot(inout vec2 p, float a) {
    p = cos(a)*p + sin(a)*vec2(p.y, -p.x);
}

float smin(float a, float b, float r){
    vec2 u = max(vec2(r - a,r - b), vec2(0));
    return max(r, min (a, b)) - length(u);
}

float hash( vec2 p ) {
    float h = dot(p,vec2(127.1,311.7)); 
    return fract(sin(h)*43758.5453123);
}
float noise( in vec2 p ) {
    vec2 i = floor( p );
    vec2 f = fract( p );    
    vec2 u = f*f*(3.0-2.0*f);
    return -1.0+2.0*mix( mix( hash( i + vec2(0.0,0.0) ), 
                     hash( i + vec2(1.0,0.0) ), u.x),
                mix( hash( i + vec2(0.0,1.0) ), 
                     hash( i + vec2(1.0,1.0) ), u.x), u.y);
}

const int ITER_GEOMETRY = 2;
const int ITER_FRAGMENT = 1;
const float SEA_HEIGHT = 0.25;
const float SEA_CHOPPY = 2.0;
const float SEA_SPEED = 0.7;
const float SEA_FREQ = 0.6;
const vec3 SEA_BASE = vec3(0.1,0.19,0.22);
const vec3 SEA_WATER_COLOR = vec3(0.8,0.9,0.6);
float SEA_TIME;
mat2 octave_m = mat2(1.6,1.2,-1.2,1.6);
float sea_octave(vec2 uv, float choppy) {
    uv += noise(uv);        
    vec2 wv = 1.0-abs(sin(uv));
    vec2 swv = abs(cos(uv));    
    wv = mix(wv,swv,wv);
    return pow(1.0-pow(wv.x * wv.y,0.65),choppy);
}
float water(vec3 p) {
    p.y += 0.5;
    float freq = SEA_FREQ;
    float amp = SEA_HEIGHT;
    float choppy = SEA_CHOPPY;
    vec2 uv = p.xz; uv.x *= 0.75;
    
    float d, h = 0.0;    
    for(int i = 0; i < ITER_GEOMETRY; i++) {        
        d = sea_octave((uv+SEA_TIME)*freq,choppy);
        d += sea_octave((uv-SEA_TIME)*freq,choppy);
        h += d * amp;        
        uv *= octave_m; freq *= 1.9; amp *= 0.22;
        choppy = mix(choppy,1.0,0.2);
    }
    return p.y - h;
}

float r = 56.0;
float map(vec3 p){
    vec3 op = p+vec3(0,0,0);
    //float f = p.y+0.25+0.1*sin(t+p.z*3.9)+0.1*cos(t+p.x*4.1);
    float f = water(p);
    float dd = 1e8;
    rot(p.xy, t*0.1);
    modp(p.xy, r*1.0);
    modp(p.xz, r*1.1);
    float s = sphere(p-vec3(2.0,0,0), 0.1);
    float fs = smin(f,s,0.05);
    return fs;
}

vec3 normal( in vec3 p ){
    const float eps = 0.02;
    float d=map(p);
    return normalize(vec3(map(p+vec3(eps,0,0))-d,map(p+vec3(0,eps,0))-d,map(p+vec3(0,0,eps))-d));
}

vec3 intersect(inout vec3 o, inout vec3 d, out vec3 no){
    float st = 0.0;
    float l = 0.0;
    float s = 0.0;
    for(int i = 0; i < STEPS; ++i){
        s = map(o+d*l);
        l += s;
        if(s < E || l > FAR) break;
    }
    l = min(FAR, l);
    vec3 i = o+d*l;
    no = normal(i);
    o = i+0.01*no;
    d = reflect(d, no);
    return i;
}

float shadow(vec3 ro, vec3 rd, float mint, float tmax, float k){
    float res = 1.0;
    float t = mint;
    for( int i=0; i<35; i++){
        float h = map(ro + rd*t);
        res = min( res, k*h/t );
        t += clamp( h, 0.02, 0.10 );
        if( h<0.001 || t>tmax ) break;
    }
    return clamp( res, 0.0, 1.0 );
}

float G1V(float dnv, float k){
    return 1.0/(dnv*(1.0-k)+k);
}

float ggx(vec3 n, vec3 v, vec3 l, float rough, float f0){
    float alpha = rough*rough;
    vec3 h = normalize(v+l);
    float dnl = clamp(dot(n,l), 0.0, 1.0);
    float dnv = clamp(dot(n,v), 0.0, 1.0);
    float dnh = clamp(dot(n,h), 0.0, 1.0);
    float dlh = clamp(dot(l,h), 0.0, 1.0);
    float f, d, vis;
    float asqr = alpha*alpha;
    const float pi = 3.14159;
    float den = dnh*dnh*(asqr-1.0)+1.0;
    d = asqr/(pi * den * den);
    dlh = pow(1.0-dlh, 5.0);
    f = f0 + (1.0-f0)*dlh;
    float k = alpha/1.0;
    vis = G1V(dnl, k)*G1V(dnv, k);
    float spec = dnl * d * f * vis;
    return spec;
}

float ao(vec3 spoint, vec3 norm){
    float ao = 1.0;
    float occlusion = 0.;
    float factor = 1.0;
    for(int i = 0; i < 5; ++i){
        spoint += .075*norm;
        occlusion += max(0.0, map(spoint)*factor);
        factor *= .75;
    }
    return clamp(occlusion, 0.0, 1.0);
}

vec3 light;
//vec3 light = 0.75*vec3(9.-18.*sin(t*0.41),9.-18.*cos(t*0.31),9.-18.*sin(-t*0.51));
vec3 shade(vec3 p, vec3 o, vec3 d, vec3 normal, float spec){
    if(distance(p,o) > 0.99*FAR) return vec3(0.06);
    float s = 0.0;
    vec3 ld = -normalize(p-light);
    //return abs(ld);
    
    s = ggx(normal, -d , ld, 1.0, spec);
    
    
    float amb = 0.2+0.8*ao(p, normal);
    
    //float ss = 0.1+0.9*shadow(p, ld)+0.1*n2rand( vec2(dot(p.x,p.z), p.y) );
    float ss = shadow(p, ld, 0.1, 25.0, 2.0);
    //return vec3(ss);
    s *= ss;
    return amb*mix(vec3(s), vec3(0.02), pow(clamp(distance(o, p)/(FAR*2.), 0.0, 1.0), 1.0) );
}

float fresnel(vec3 p, vec3 d, vec3 n, float i1, float i2){
    vec3 ha = normalize(mix(normalize(p-light), d, 0.5));
    float cost = dot(d, ha);
    float f0 = pow((i1-i2)/(i1+i2), 2.0);
    float F = f0 + (1.0 + f0) * pow(1.0-acos(cost), 5.0);
    return F;
}

void main()
{
    t = iGlobalTime;
    SEA_TIME = 1.0 + iGlobalTime * SEA_SPEED;
    light = 2.*vec3(12.-24.*iMouse.x,11.0,12.-24.*iMouse.y);
    vec2 uv = vec2(1.0-2.0 * UV.x, -1.0 + 2.0*UV.y);
    uv.x *= iResolution.x / iResolution.y; // TODO: trying to emulate roope's stuff
    vec2 r = iResolution.xy;
    //uv.y *= r.y/r.x;
    //mat3 rot = rx(0.5*3.141-3.141*iMouse.y/r.y)*ry( 2.0*(3.141-3.141*iMouse.x/r.x) );
    mat3 rot = rx(0.5*3.141-3.141*0.515)*ry( 2.0*(3.141*0.5) );
    vec3 o = vec3(0,1.4,11.5);
    
    vec3 fluidc = pow(normalize(vec3(1.0,0.2,0.1)),vec3(1.1));
    vec3 d = normalize(rot*vec3(uv,3.5));
    vec3 c = vec3(0);
    
    vec3 normal = vec3(0);
    vec3 op = o;
    vec3 i = intersect(o, d, normal);
    vec3 oi = i;
    vec3 mult = fluidc;
    float f = fresnel(i, d, normal, 4.0, 2.0);
    if(water(o) > 0.015) mult = mix(vec3(1), mult, clamp(dot(normal,vec3(0,-1,0)),0.0,1.0) );
    c = mult*shade(i, op, d, normal, 0.5);
    float w = distance(op,i)/FAR;
    
    #define REF 1
    for(int it = 1; it <= REF; ++it){
        float at = 1.0;
        float spec = 2.5;
        mult = vec3(1);
        if(water(o) > 0.015) at = 0.175, spec = 0.5, mult = 3.0*fluidc;
        vec3 pp = o;
        vec3 pd = d;
        vec3 i = intersect(o, d, normal);
        
        //if(rw < 0.99){
            //at = max(1.0, 1.0/distance(i, pp));
            c  += mult*f*at*shade(i, pp, pd, normal, spec);
            f = fresnel(i, pd, normal, 2.0, 2.0);
        //}
        
    }
    //float vignette = 1.0 / (0.8 + 1.3*dot(uv, uv));
    float noise = .02*vec3(nrand(uv*t)).x;
    
    c = 0.015*noise+c;
    c = clamp(c*15.0, 0.0, 2.0);
    fragColor = vec4(pow(c, vec3(0.4545)),w);
}