#version 330 core

// inputz
in vec2 UV;

uniform sampler2D iChannel0;
uniform vec2 iResolution;
uniform float iGlobalTime;
uniform float focus; // = 0.33;
uniform float diameter;

// outputz
out vec4 fragColor;

float time;
float hash(float c){return fract(sin(dot(c,12.9898))*43758.5453);}
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec2 texel;
vec2 pixel;

float factor = 0.001;
float radius;

vec4 tex(vec2 uv){
    vec4 s = texture(iChannel0, uv);
    return vec4(pow(s.rgb, vec3(2.2)), s.w);
}

vec3 accumCol = vec3(0.0);
vec3 accumW = vec3(0.0);
const float mas = 0.0;

void add(vec2 uv, float i, float j){
    vec2 offset = pixel * vec2(i, j);
    vec4 col = tex(uv + offset * radius);
    //if(col.w > 0.04+texture(iChannel1, uv).w) return;
    vec3 bokeh = vec3(1.0) + pow(col.rgb, vec3(4.0)) * vec3(factor);
    accumCol += col.rgb * bokeh;
    accumW += bokeh;
}

const float SQT = 0.70710678118;
const mat2 TFOM = mat2(SQT, SQT, SQT, -SQT);

vec3 blurr(vec2 uv){
    for (float i = 0.; i <= 64.; i+=1.0) {
        float a = rand(uv + i + iGlobalTime);
        float r = rand(vec2(uv.y + iGlobalTime, uv.x - i));
        vec2 offset = 16.0 * TFOM * (vec2(a, r) - .5);
        add(uv, offset.x, offset.y);
    }/*
    for (float j = -7.0 + mas; j <= 7.0 - mas; j += 1.0)
        for (float i = -7.0 + mas; i <=7.0 - mas; i += 1.0) add(uv, i, j);
    for (float i = -5.0 + mas; i <=5.0 - mas; i+=1.0){
        add(uv, i, -8.0 + mas);
        add(uv, i, 8.0 - mas);
    }
    for (float j = -5.0 + mas; j <=5.0 - mas; j+=1.0){
        add(uv, -8.0 + mas, j);
        add(uv, 8.0 - mas, j);
    }
    for (float i = -3.0 +mas; i <=3.0 -  mas; i+=1.0){
        add(uv, i, -9.0 + mas);
        add(uv, i, 9.0 - mas);
    }
    for (float j = -3.0 + mas; j <=3.0 - mas; j+=1.0){
        add(uv, -9.0 + mas, j);
        add(uv, 9.0 - mas, j);
    }*/
    return accumCol/accumW;
}

void main(){
    time = iGlobalTime;
    texel = 1.0/iResolution.xy;
    pixel = 1.0/iResolution.xy;
    
    vec2 pp = UV;
    vec2 r = iResolution.xy;
    vec2 p = 1.-2.*UV;
    p.y *= r.y/r.x;
   
    vec4 sampl = texture(iChannel0, pp);
    float depth = sampl.w;

    //if(iMouse.z > 1.0) focus = iMouse.y/r.y;
    // calculate dof based on depth values
    //const float diameter = 40.0;
    float aperture = diameter * pow(length(r.xy)/length(vec2(1920.,1080.)), 1.0/(1.5*sqrt(2.0)));
    // focal length in meters
    const float F = 0.03;
    float cock = abs(aperture*(F*(depth-focus))/(depth*max(0.5/aperture, focus-F)));
    radius = 0.1+cock;
    vec3 color = blurr(pp);
    //vec3 color = texture(iChannel1, pp).rgb;
    //fragColor = vec4(vec3(length(color)), 1.0 );
    fragColor = vec4(color, 1.0 );
}
