#version 330 core

// inputz
in vec2 UV;

uniform sampler2D iChannel0;
uniform vec2 iResolution;
uniform float iGlobalTime;

// outputz
out vec4 fragColor;

float hash(float c){return fract(sin(dot(c,12.9898))*43758.5453);}
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

// linear white point
const float W = 3.0;
const float T2 = 1.5; // old: 0.75

float filmic_reinhard_curve (float x) {
    float q = (T2*T2 + 1.0)*x*x;    
    return q / (q + x + T2*T2);
}

vec3 filmic_reinhard(vec3 x) {
    float w = filmic_reinhard_curve(W);
    return vec3(
        filmic_reinhard_curve(x.r),
        filmic_reinhard_curve(x.g),
        filmic_reinhard_curve(x.b)) / w;
}

const int N = 6;

vec2 co(vec2 uv){
    return 0.5-uv*0.5;
}

vec3 ca(sampler2D t, vec2 UV, vec4 sampl){
    vec2 uv = 1.0 - 2.0 * UV;
    vec3 c = vec3(0);
    float rf = 1.0;
    float gf = 1.0;
    float bf = 1.0;
    float f = 1.0/float(N);
    for(int i = 0; i < N; ++i){
        c.r += f*texture(t, co(uv*rf) ).r;
        c.g += f*texture(t, co(uv*gf) ).g;
        c.b += f*texture(t, co(uv*bf) ).b;
        rf *= 0.9975;
        gf *= 0.9982;
        bf /= 0.9992;
        c = clamp(c,0.0, 1.0);
    }
    return c;
}

void main()
{
    const float brightness = 2.25;
    
    vec2 pp = UV;
    vec2 r = iResolution.xy;
    vec2 p = 1.-2.*UV;
    p.y *= r.y/r.x;
   
    // a little chromatic aberration
    vec4 sampl = texture(iChannel0, pp);
    vec3 color = ca(iChannel0, pp, sampl).rgb;
    //vec3 color = sample.rgb;
    
    // final output
    color = pow(color, vec3(1.0/2.2));
    //float vignette = 1.25 / (1.1 + 1.1*dot(p, p));
    float noise = .02*vec3(hash(length(p)*iGlobalTime)).x;
    color = filmic_reinhard(brightness*color);
    //color = vec3(length(color));
    //color = smoothstep(-0.1,1.1,color);
    //color = vec3(dot(vec3(0.2989, 0.5870, 0.1140), color));
    fragColor = vec4( clamp(color+0.*noise, 0.0, 1.0), 1.0 );
    //fragColor.xyz = vignette*vec3(smoothstep( 0.7, 1.0, dot(vec3(1./3.), fragColor.xyz) ));
    fragColor.a = 1.0;
}