#version 330 core

// inputz
in vec2 UV;

uniform vec2 iResolution;
uniform float iGlobalTime;
#define iTime iGlobalTime
uniform vec2 iMouse; //const vec2 iMouse = vec2(0.5);
uniform float lerppaus;

// outputz
out vec4 fragColor;

float E = 6.0;
//#define AA
#define FAR_CLIP 120000
#define AO 6
#define STEPS 99
#define TERRAIN_COMPLEXITY 4.
float time;
float t;
//flaot sppos = smoothstep0

// various helper functions
float imp(float k,float x){return k*x*exp(1.0-k*x);}
// rotation matrixes
mat3 rx(float a){return mat3(1.0,0.0,0.0,0.0,cos(a),-sin(a),0.0,sin(a),cos(a));}
mat3 ry(float a){return mat3(cos(a),0,sin(a),0.0,1.0,0.0,-sin(a),0.0,cos(a));}
mat3 rz(float a){return mat3(cos(a),-sin(a),0.0,sin(a),cos(a),0.0,0.0,0.0,1.0);}
// white noise
float hash(float c){return fract(sin(dot(c,12.9898))*43758.5453);}

float no(vec3 x){
    vec3 p=floor(x);
    vec3 f=fract(x);

    f=f*f*(3.0-2.0*f);
    float n=p.x+p.y*57.0+113.0*p.z;
    return mix(mix(mix(hash(n),hash(n+1.0),f.x),
                mix(hash(n+57.0),hash(n+58.0),f.x),f.y),
            mix(mix(hash(n+113.0),hash(n+114.0),f.x),
                mix(hash(n+170.0),hash(n+171.0),f.x),f.y),f.z);
}

float snoise(vec3 x) {
    vec3 p = floor(x);
    vec3 f = fract(x);
    f = f*f*(3.0-2.0*f);
    
    vec2 uv = (p.xy+vec2(37.0,17.0)*p.z) + f.xy;
    vec2 rg = vec2(0.); // textureLod( iChannel0, (uv+ 0.5)/256.0, 0.0 ).yx;
    return mix( rg.x, rg.y, f.z );
}

float sp(vec3 p, float s){
    return length(p)-s;
}

//////////////////////////////////////////////////////////////////////////////////////////

float tri(in float x){
    return abs(fract(x)-0.5);
}
mat2 m2 = mat2( 0.80,  0.60, -0.60,  0.80 );
float tnoise(vec2 p, float h){
    p*=.0005+0.0000015*snoise(vec3(p*0.15, h));
    float z=0.9;//+2.3*snoise(vec3(floor(p*10.0), time));
    float rz = 0.;
    for (float i= 1.;i < TERRAIN_COMPLEXITY;i++ )
    {
        rz+= tri(p.x+tri(p.y*1.0)-floor(time*10.0)*0.1)/z;
        z = z*2.0;
        p = p*2.0;
        p*= m2;
    }
    return rz*100.;
}
float oct(in vec3 p){ return dot(vec3(0.5773),abs(p));}
float ou( float d1, float d2 ){return (d1<d2) ? d1 : d2;}
vec3 roty(vec3 p, float a){
    float s = sin(a), c = cos(a);
    return vec3(c*p.x + s*p.z, p.y, -s*p.x + c*p.z);
}

float geometry(vec3 p){
    const float voxelfuck = 1.0;
    p = floor(p/voxelfuck)*voxelfuck;
    
    //p.x += 2000.0;
    //if(abs(p.x)>3000.0 || abs(p.z)>3000.0) return 0.1;
    float ter = tri((sin(t+p.z*0.001)+cos(-t+p.x*0.001))*0.4);
    float d = 5.*tnoise(p.xz, p.y) + p.y+400.0 + ter *900.0;
    d -= abs(p.x*0.5*log(abs(p.x)))*0.05-8.;
    float rocket_param2 = 800.0;
    d = ou(d, p.y+rocket_param2);
    
    float sphere = sp(p - vec3(-3000,900.0, 10000 ), 1500.0);
    //return min(max(d, -sphere+400.0), sphere);
    return min(d, sphere);
}

////////////////////////////////////////////////////////////////////////////////////////////////

vec3 normal(vec3 p){
    float e=10.0;
    return normalize(vec3(geometry(p+vec3(e,0,0))-geometry(p-vec3(e,0,0)),
                          geometry(p+vec3(0,e,0))-geometry(p-vec3(0,e,0)),
                          geometry(p+vec3(0,0,e))-geometry(p-vec3(0,0,e))));
}

vec3 normal_low(vec3 p){
    float e=40.0;
    return normalize(vec3(geometry(p+vec3(e,0,0))-geometry(p-vec3(e,0,0)),
                          geometry(p+vec3(0,e,0))-geometry(p-vec3(0,e,0)),
                          geometry(p+vec3(0,0,e))-geometry(p-vec3(0,0,e))));
}

float shadow(vec3 ro, vec3 rd, float mint, float maxt, float k){
    float rocket_param1 = 0.1;
    float res=1.0;
    float t = mint;
    for(int i = 0; i < 40; i++){
        float h = geometry(ro+rd*t);
        if(h < rocket_param1) return 0.0;
        res=min(res,k*h/t);
        t+=h;
    }
    return res;
}
/*
float ao(vec3 spoint, vec3 norm){
    float ao = 6.0;
    float occlusion = ao;
    float factor = .6;
    for(int i = 0; i < 6; ++i){
        spoint += 10.0*norm;
        occlusion -= geometry(spoint)*factor;
        factor *= .6;
    }
    return clamp((ao*ao)*(1.0-occlusion/ao), 0.0, 10.0);
}
*/

float ao(vec3 middle, vec3 norm)
{
    float avg = 0.0;
    avg += 0.25*geometry(middle+vec3(200,0,200));
    avg += 0.25*geometry(middle+vec3(-200,0,200));
    avg += 0.25*geometry(middle+vec3(200,0,-200));
    avg += 0.25*geometry(middle+vec3(-200,0,-200));
    
    float mid = geometry(middle);
    
    return pow(max(0.0, 0.5+0.0033*(avg-mid)),1.0);
}

vec3 lightpos;
vec3 shade(vec3 point, float dist, float fresnel){
    //lightpos.xz *= 1500.0*vec2(sin(time*0.91), cos(time*1.07));
    
    vec3 norm = normal(point);
    //return norm;
    vec3 lightdir   = -normalize(point - lightpos);
    float intensity = max(0.0, dot(lightdir, norm) );
    
    intensity /= 0.00045*pow(distance(point, lightpos),1.0);
    //intensity = pow(5000000.0*intensity, 0.25);

    float shadows   = shadow(point, lightdir, 1.0, 2000.0, 16.0);

    vec3 lightcolor  = vec3(0.8);
    vec3 shadowcolor = vec3(0);//vec3(1)-lightcolor;
    vec3 fogcolor    = vec3(0.0);

    // pbr
    vec3 glow = 1500000.0*mix(vec3(0), vec3(1,0.3,0.1), pow(1.0/sp(point-vec3(-3000,900,10000),1500.0),2.0));
    vec3 glo2 = 25000000.0*mix(vec3(0), vec3(1,0.3,0.1), pow(1.0/sp(point-vec3(-3000,900,10000),1500.0),2.0));
    
    glow += pow(fresnel, 0.75)*glo2*max(0.0, dot(norm, -normalize(point-vec3(-3000,900,10000)) ));
    //return vec3(fresnel);
    
    //float amb = ao(point+norm*10.0, norm);
    //greturn vec3(amb);
    float amb = mix(ao(point, norm), 1.0, pow(intensity, 2.0));
    
    vec3 scol = mix(shadowcolor,vec3(1),shadows);
    float fd = 0.0;//70.0*no(vec3(0.003*point.xzy)+time)-20.0*no(vec3(0.008*point.xzy)+time);
    //fd += pow(dist, 2.0)*0.000023;
    //return vec3(amb);
    return amb*mix(lightcolor*intensity*scol+glow,vec3(1),clamp(-1.2-.002*(point.y-fd),0.0,1.0));
}

float err(float dist){
    dist = dist/100.0;
    return min(E, dist*dist);
}

vec3 discontinuity_reduction(vec3 origin, vec3 direction, vec3 position){
    const int iterations = 3;
    for(int i = 0; i < iterations; i++){
        //float d = ;
        //position = position + direction * (geometry(position) - err(distance(origin, position)));
        position = position + direction * (geometry(position) - err(distance(origin, position)));
    }
    return position;
}

vec3 march_ref(vec3 origin, vec3 direction){
    vec3 position = vec3(0.0);
    float dist = 0.0;
    float step = 0.0;
    float glow = 0.0;
    
    float steps = 0.0;
    
    for(int i=0; i < STEPS/2; ++i){
        position = origin + direction * step;
        dist = geometry(position);
        step  += dist;
        steps = float(i);
        if(float(FAR_CLIP) < step || dist < E) break;
    }
    
    if(step > float(FAR_CLIP)) return vec3(0);
    position = discontinuity_reduction(origin, direction, position);
    return shade(position, step, 0.0);
}

vec3 march(vec3 origin, vec3 direction){
    vec3 position = vec3(0);
    float dist = 0.0;
    float step = 0.0;
    float glow = 0.0;
    
    float steps = 0.0;
    
    //float glowp = pow(0.5+0.5*sin(time*1.4), 6.0);
    
    for(int i=0; i < STEPS; ++i){
        position = origin + direction * step;
        dist = geometry(position);
        step  += dist;
        
        //glow += pow( (0.00026/glowp) *sp(position - vec3(-4000, 1000, -1000), 1500.0),2.0);
        
        steps = float(i);
        if(float(FAR_CLIP) < step || dist < E) break;
    }

    //glow = 1.0/glow;
    if(step > float(FAR_CLIP)) return vec3(0);
    
    position = discontinuity_reduction(origin, direction, position);
    vec3 color = vec3(0);
    vec3 n = normal_low(position);
    float of = pow( 1.0+dot(n, direction), 5.0 );
    float fresnel = mix(of, 0.0, smoothstep(2000.0, 10000.0, distance(vec3(0000,100,8000), position)));
    fresnel += 0.75*mix(of, 0.0, smoothstep(0.0, 13000.0, distance(origin, position)));
    
    vec3 rc = vec3(0);
    //if(position.y <= -800.0+E*1.5)
    {
        //rc = march_ref(position+n*E*2.0, reflect(n, direction));
    }
    
    /*
    
 
        
        color = march_ref(position+n*20.0, reflect(direction, n));
        //color /= 0.4+0.8*clamp(pow(0.0002*dot( -vec3(position-lightpos), n), 2.0),-1.0, 1.0);
        
    
    color *= pow(1.0-max(0.0, dot(direction, n)),5.0);
    //return color;//
*/
    //return shade(position, step)+glow;
    vec3 col = shade(position, step, fresnel);
    return rc+mix(fresnel+col, fresnel*col, 0.25);
}

vec3 correct(vec3 c){
    c = c*1.1-0.05;
    c = smoothstep(-0.15, 1.5, smoothstep(-0.05, 1.22, c));
    return vec3(length(c));
}

mat3 lookat( in vec3 fw, in vec3 up )
{
    fw = normalize(fw);
    vec3 rt = normalize( cross(fw, normalize(up)) );
    return mat3( rt, cross(rt, fw), fw );
}

void main(){
    time = iTime;
    t = mod(-0.3*time, 8.0*3.14159);
    t = floor(t*5.0*3.141)/(0.5*3.141*10.0);
    lightpos = vec3(-3000,900.0, 5000 );
    
    vec2 r = iResolution.xy;
    vec2 p = 1.-2.*UV;
    p.y *= r.y/r.x;
    
    float mv = lerppaus;

    // camera setup
    mat3 angle     = rx(mix(-0.2, -0.1, mv))*ry(mix(1.6, 1.4, mv))*rz(2.9);
    mat3 rotation  = rz(0.5*3.141-3.141*0.4)*ry( 2.1*(3.141+3.141*1.0) );
    mat3 shake = rx(12.5*snoise( vec3(time*1.14) ))*
                 ry(12.5*snoise( vec3(time*0.71) ))*
                 rz(9.04*snoise( vec3(time*1.99) ));
    
    vec3 direction = normalize(vec3(p, 6.0)*angle*rotation)*shake;
    
    // render visuals
    vec3 color = vec3(0);
    vec3 camera    = mix(vec3(16000,4000,-5000), vec3(18000,4000,-12500), mv);
    #ifdef AA
    color += march(camera + 1000.0*vec3(1.0/r.x,-1.3/r.y,0), direction);
    color += march(camera + 1000.0*vec3(0.3/r.x,1.3/r.y,0), direction);
    color += march(camera + 1000.0*vec3(-1.3/r.x,-0.3/r.y,0), direction);
    color /= 3.0;
    #else
    color = march(camera, direction);
    #endif
    
    // correct, post and output
    color = mix(color, correct(color), 0.7);
    color = pow(color, vec3(1.0/2.2));
    float vignette = 1.1 / (1.1 + 1.1*dot(p, p));
    float noise = .05*vec3(hash(length(p)*time)).x;
    fragColor = vec4( smoothstep(-0.1, 1.2, color*vignette-noise), 1.0);
}
