#version 330 core

// inputz
in vec2 UV;

uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform vec2 iResolution;
uniform float iGlobalTime;
#define gtime iGlobalTime

// outputz
out vec4 fragColor;

vec3 stripes(vec2 uv, float lscale, float dx, float thickness, float time){
    
    float anim = -1.0+2.0*smoothstep(-0.25, 0.25, sin(time*3.32));
    uv.x /= 1.3-clamp(uv.x+anim*tan(uv.y), 0.2, 1.0);
    uv.y /= 1.3-clamp(uv.y+anim*tan(uv.x), 0.2, 1.0);
    
    float wi = 2.0;//1.0*cos(time*3.0);
    float coord = uv.y + dx * uv.x - float(uv.x > 0.5) * wi * dx * (uv.x - 0.5);
    float c = float(mod(float(/*floor*/(coord / lscale + 1.0)), 2.0) > 2.0 - thickness);
    return vec3(c*0.91);
}

mat2 rotationMatrix(float angle){
    return mat2(cos(angle),-sin(angle),sin(angle),cos(angle));
}

vec3 sampl(vec2 uv){
    float f = smoothstep(0.0, 20.0, gtime);
    vec3 acc = vec3(0.0);
    const int p = 20;
    const float shutter = 0.75; // 1.0 full open, 0.5 180 degree
    float time = gtime-0.02;
    for(int i = 0; i < p; ++i){
        vec3 val = vec3(0.0);
        val += stripes(uv-vec2(.3/iResolution),.15+.1*sin(.3*time),sin(.9*time),f*(1.+.5*cos(1.7241*time)), time);
        val += stripes(uv+vec2(.3/iResolution),.15+.1*sin(.3*time),sin(.9*time),f*(1.+.5*cos(1.7241*time)), time);
        val += stripes(uv-vec2(.0,.3/iResolution.x),.15+.1*sin(.3*time),sin(.9*time),f*(1.+.5*cos(1.7241*time)), time);
        val += stripes(uv-vec2(.0,.3/iResolution.y),.15+.1*sin(.3*time),sin(.9*time),f*(1.+.5*cos(1.7241*time)), time);
        acc += val;
        time += (shutter*20.0/1000.0)/float(p);
    }
    return 0.1+0.9*clamp(acc/float(p)/4., 0.0, 1.0);
}

vec4 mimage()
{
	vec2 uv = rotationMatrix(-.15*gtime) * (UV - vec2(0.5));
    uv *= 1.0-0.07*abs(sin(gtime*6.82));
    uv += 0.5;
    vec3 c = sampl(uv);
	return vec4(c.rrr * round(float(length(texture(iChannel1, 2.5*UV).rgb) < 0.5)),
		        1.0);
}



void main(void)
{
	vec2 uv = -1.0+2.0 * UV;
    //uv.x *= (4.0/3.0);
    uv = 0.5+0.5*uv;
	vec3 b = texture(iChannel0, uv).rrr / 3000.0; //CHANGED
    
    b *= smoothstep(0.05, 0.25, pow(distance(b, vec3(0.17,0.49,0.13)), 2.0));
    
    b = vec3(dot(b, vec3(0.299, 0.587, 0.114)));
    
    b = smoothstep(0.1, 0.5, b);
    
    fragColor.rgb = texture(iChannel0, uv).rrr; //*.001 + mimage().rgb;
    fragColor.a = 1.0;
    // fragColor.r = 2.*UV.x;
}
