#version 330 core

// inputz
in vec2 UV;

uniform sampler2D iChannel0;
uniform vec2 iResolution;

// outputz
out vec4 fragColor;

void main()
{
    vec2 uv = UV;
    
    vec3 p  = texture(iChannel0, uv).rgb;
    if(length(p) < 0.02)
    {
        vec2 x = 1.0/iResolution.xy;
    
        p += texture(iChannel0, uv+vec2(0,x.y)).rgb;
    	p += texture(iChannel0, uv+vec2(x.x,0)).rgb;
        p += texture(iChannel0, uv+vec2(0,-x.y)).rgb;
    	p += texture(iChannel0, uv+vec2(-x.x,0)).rgb;
    	p /= 4.0;
    
    }
    
    fragColor.rgb = min(vec3(1), p);
    fragColor.a = 1.0;
}
