#version 330 core

in vec2 UV;
out vec4 fragColor;

uniform float iGlobalTime;
#define iTime iGlobalTime
uniform vec2 iResolution;
uniform sampler2D iChannel0;

#define M_PI 3.14159
void main()
{
    vec2 uv = UV;
    vec2 size = vec2(iResolution.xy);
    int intx = int(uv.x*size.x); 
    int j = int(mod(float(intx), 8.));  
    float x = float(intx - j);
    x /= size.x;
    vec4 array1[8];
    for(int i = 0; i < 8; i++)
        array1[i] = texture(iChannel0, vec2(x+(float(i)+0.5)/size.x, uv.y))*2.-1.;
    
    vec4 color = vec4(0);
    color += array1[0]/2.;
    for(int i = 1; i < 8; i++)
    {
        color.rgb += array1[i].rgb*cos(M_PI/8.0*(float(i))*float(j));
    }
    color *= sqrt(2.0/8.);
    fragColor = color*0.5+0.5;
}