#version 330 core

in vec2 UV;
uniform sampler2D orig;
uniform sampler2D iChannel0;
uniform vec2 iResolution;
uniform vec2 zoom;
uniform float lodDecay;
uniform float lodCoeff;

out vec4 fragColor;

#define HASHSCALE1 .1031
#define HASHSCALE3 vec3(.1031, .1030, .0973)
#define HASHSCALE4 vec4(1031, .1030, .0973, .1099)
float hash11(float p)
{
    vec3 p3  = fract(vec3(p) * HASHSCALE1);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.x + p3.y) * p3.z);
}

void main(){
  vec3 color = texture(orig, UV).xyz;
  float w = 1.0;
  for (float lod = 0.0; lod < 10.0; lod += 1.0) {
    float thislod = lod*(1.0+hash11(lod + 12.23*UV.x + 432.2*UV.y));
    float dw = lodCoeff * exp(lodDecay*thislod);
    color += dw * textureLod(iChannel0, UV, thislod).xyz;
    w += dw;
  }
  fragColor.xyz = .05 + color / w; // TODO
  fragColor.a = 1.0;
}