#version 330 core

in vec2 UV;
uniform vec2 iResolution;
#define iTime iGlobalTime
uniform float iGlobalTime;

out vec4 fragColor;

#define HASHSCALE3 vec3(.1031, .1030, .0973)
vec2 add = vec2(1.0, 0.0);
float hash12(vec2 p)
{
    vec3 p3  = fract(vec3(p.xyx) * HASHSCALE3.x);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.x + p3.y) * p3.z);
}

float hash13(vec3 p3)
{
    p3  = fract(p3 * HASHSCALE3.x);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.x + p3.y) * p3.z);
}

vec2 hash21(float p)
{
    vec3 p3 = fract(vec3(p) * HASHSCALE3);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.xx+p3.yz)*p3.zy);
}

vec2 getcell(vec2 uv, float z, float s1)
{
    return (round(uv*s1)/s1);
}

float noise12(vec2 x)
{
    vec2 p = floor(x);
    vec2 f = fract(x);
    f = f*f*(3.0-2.0*f);
    float res = mix(mix(hash12(p),          hash12(p + add.xy),f.x),
                    mix(hash12(p + add.yx), hash12(p + add.xx),f.x),f.y);
    return res;
}

float grid(vec2 uv, vec2 cell, float diagonal, float s1, float s2, float t)
{
    float pot = 0.0;
    
    bool skip = false;
    
    // clip edges
    if(abs(cell.x) < 4.0*s1 && abs(cell.y) < 4.0*s1
       // skip random cells
       && hash13(vec3(floor(cell/s1), floor(12.0*iTime))) > 0.75
       )
    {
        uv = mod(uv, s1)-s1/2.0;
        float outer = clamp(distance(pow(abs(uv),vec2(s2)), vec2(0)), 0.0, 1.0);
        
        float inner = clamp(distance(pow(abs(uv)*t,vec2(s2)), vec2(0)), 0.0, 1.0);
        pot = outer-inner;
        
        if(diagonal > 0.0)
        {
            float dir = hash13(vec3(floor(cell/s1), floor(-33.+12.0*iTime)))>0.5?-1.0:1.0;
            pot += (1.0-inner)*smoothstep(t*0.97,1.0,1.0-distance(dir*uv, uv.yx))*diagonal;
        }
    }
    
    return pot;
}

void main()
{
    // params
    float mv  = 0.6-0.4*pow(hash21(floor(-99.+6.0*iTime)).x, 4.0);
    float zv  = (-1.0+2.0*pow(noise12(vec2(77.+iTime*2.0)),6.0));
          //zv  = round(zv*2.0)/2.0;
          mv += zv*0.1;
    float zoom = 10.+60.0*mv;
    float sm = 60.0*(30.0/zoom);
    float thicc = mix(0.96, 0.88, mv);
    float spacing = 2.6+3.0*pow(hash21(floor(-55.+12.0*iTime)).x, 6.0);
    
    float rt = floor(iTime*12.0)/12.0;
    float rot  = 0.25*(1.0*pow(noise12(vec2((rt*1.4))), 6.0)-pow(noise12(vec2((22.+rt*1.2))), 6.0));
          rot += 0.7*(1.0*pow(noise12(vec2((rt*1.3))), 12.0)-pow(noise12(vec2((22.+rt*1.1))), 12.0));
          rot *= (2.5, 0.25, mv*2.0);
    mat2 rm = mat2(cos(rot), -sin(rot), sin(rot), cos(rot));
    
    vec2 uv = -1.0+2.0*UV;
    uv.y *= iResolution.y/iResolution.x;
    uv *= rm;
    uv.y -= 0.5;
    
    // 3d rotation???
    float xr = -1.+(3.14159/2.0)*(0.04*(pow(noise12(vec2(77.-iTime)),6.0)-pow(noise12(vec2(-55.+iTime*.9)),6.0)));
    vec3 u3 = vec3(uv, 4.0)*mat3(1,0,0,0,cos(xr), -sin(xr), 0,sin(xr), cos(xr));
    // project back (works???)
    u3.y -= 3.0;
    uv.x = (u3.x*iResolution.x)/(u3.z*iResolution.x)*1.5;
    uv.y = (u3.y*iResolution.y)/(u3.z*iResolution.y)*2.5;
    
    vec2 of = pow(hash21(floor(6.0*iTime)), vec2(19))-pow(hash21(floor(-6.0*iTime)), vec2(19));
    of = round(of*3.0)/3.0;
    
    float mult = 1.0;
    fragColor = vec4(vec3(0.0), 1.0);
    for(int i = 0; i < 20; i++)
    {
        vec2 cell = getcell(uv*zoom, zoom, spacing);
        float d = i==0&&hash13(vec3(floor(cell/spacing), floor(-88.+12.0*iTime)))>0.9?1.0:0.0;
        fragColor.rgb += vec3(grid(uv*zoom, cell, d, spacing, sm, thicc))*mult;
        fragColor.rgb = min(vec3(0.9), fragColor.rgb);
        if(d > 0.0) break;
        uv *= 1.042-0.02*mv;
        uv += 0.02*of;
        mult *= 0.9;
    }
    
    fragColor /= 1.0;
}
