#version 330 core

in vec2 UV;
uniform vec2 iResolution;
#define iTime iGlobalTime
uniform float iGlobalTime;

out vec4 fragColor;

#define HASHSCALE3 vec3(.1031, .1030, .0973)
float hash13(vec3 p3)
{
    p3  = fract(p3 * HASHSCALE3.x);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.x + p3.y) * p3.z);
}

vec2 hash21(float p)
{
    vec3 p3 = fract(vec3(p) * HASHSCALE3);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.xx+p3.yz)*p3.zy);

}

vec2 getcell(vec2 uv, float z, float s1)
{
    return (round(uv*s1)/s1);
}

float grid(vec2 uv, vec2 cell, float diagonal, float s1, float s2, float t)
{
    float pot = 0.0;
    
    bool skip = false;
    
    // clip edges
    if(abs(cell.x) < 6.0*s1 && abs(cell.y) < 6.0*s1
       // skip random cells
       && hash13(vec3(floor(cell/s1), floor(12.0*iTime))) > 0.8
       )
    {
        uv = mod(uv, s1)-s1/2.0;
        float outer = clamp(distance(pow(abs(uv),vec2(s2)), vec2(0)), 0.0, 1.0);
        
        float inner = clamp(distance(pow(abs(uv)*t,vec2(s2)), vec2(0)), 0.0, 1.0);
        pot = outer-inner;
        
        if(diagonal > 0.0)
        {
            float dir = hash13(vec3(floor(cell/s1), floor(-33.+12.0*iTime)))>0.5?-1.0:1.0;
            pot += (1.0-inner)*smoothstep(t*0.97,1.0,1.0-distance(dir*uv, uv.yx))*diagonal;
        }
    }
    
    return pot;
}

void main()
{
    // params
    float mv = 0.1+0.5*pow(hash21(floor(-99.+3.0*iTime)).x, 4.0);
    float zoom = 10.+60.0*mv;
    float sm = 50.0*(30.0/zoom);
    float thicc = mix(0.96, 0.88, mv);
    const float spacing = 2.8;
    
    vec2 uv = -1.0+2.0*UV;
    uv.y *= iResolution.y/iResolution.x;
    
    vec2 of = pow(hash21(floor(6.0*iTime)), vec2(19))-pow(hash21(floor(-6.0*iTime)), vec2(19));
    of = round(of*3.0)/3.0;
    
    float mult = 1.0;
    fragColor = vec4(vec3(0.), 1.0);
    for(int i = 0; i < 25; i++)
    {
        vec2 cell = getcell(uv*zoom, zoom, spacing);
        float d = i==0&&hash13(vec3(floor(cell/spacing), floor(-88.+12.0*iTime)))>0.9?1.0:0.0;
        fragColor.rgb += vec3(grid(uv*zoom, cell, d, spacing, sm, thicc))*mult;
        fragColor.rgb = min(vec3(0.9), fragColor.rgb);
        if(d > 0.0) break;
        uv *= 1.025-0.01*mv;
        uv += 0.015*of;
        mult *= 0.95;
    }
    
    fragColor /= 1.0;
}
