#version 330 core

// inputz
in vec2 UV;

uniform vec2 iResolution;
uniform float iGlobalTime;
uniform vec2 iMouse; //const vec2 iMouse = vec2(0.5);

// outputz
out vec4 fragColor;

#define iTime iGlobalTime

#define HASHSCALE3 vec3(.1031, .1030, .0973)
vec2 hash23(vec3 p3)
{
    p3 = fract(p3 * HASHSCALE3);
    p3 += dot(p3, p3.yzx+19.19);
    return fract((p3.xx+p3.yz)*p3.zy);
}

void main( )
{
    const float pi = 3.14159;
    vec2 p = -1.0+2.0*UV;
    
    const int S = 10;
    p *= 0.25;
    p.x += iTime*0.02;
    p.y *= sign(sin(p.x*15.0*pi));
    p.y -= sign(1.0-sin(p.x*15.0*pi))*iTime*0.02;
    fragColor = vec4(0.0);

    for(int i = 0; i < S; i++)
    {
        vec2 seed = hash23(vec3(p*999., (iTime+float(i)) ));
        float t = iTime+dot(seed.x,seed.y);
        vec2 uv = (p+seed*0.003);

        float val = 12.0*smoothstep(0.0,pi*5.0,abs(cos(uv.y*15.0*pi)))+cos(uv.y*3.0*pi+sin(0.4*t+uv.x*4.0*pi));
        val = tan(1.1*val);
        val = 0.5+0.5*sin( 5.0*t+20.0*(0.5+0.5*(val)));

        val = pow(val, 40.0);
        fragColor += vec4(val);
    }
    
    fragColor /= float(S);
    fragColor = smoothstep(-0.1,0.8,fragColor);
    //fragColor = pow(fragColor, vec4(0.4545));
}
