#version 330 core

layout(location = 0) in vec3 squareVertices;
layout(location = 1) in vec2 xys; // Position of the center of the particule and size of the square

out vec4 oColor;
out vec2 uv;

uniform sampler2D state;
uniform vec3 camr;
uniform vec3 camu;
uniform vec3 campos;
uniform mat4 VpMtx;

void main()
{
	vec4 partikle = texture(state, xys.xy);
	vec3 particleCenter_wordspace = partikle.xyz;
	
	float s = 0.05;
	vec3 vertexPosition_worldspace = 
		particleCenter_wordspace
		+ s*normalize(camr)*squareVertices.x
		+ s*normalize(camu)*squareVertices.y;

	// Output position of the vertex
	gl_Position = VpMtx * vec4(vertexPosition_worldspace, 1.0);
	oColor = vec4(partikle.a);
	//oColor.xyz *= exp(-.12*length(campos - particleCenter_wordspace));
	uv =  .5 *(1.0 + squareVertices.xy);
}
