#version 330 core

in vec2 UV;
out vec4 fragColor;

uniform float iGlobalTime;
#define iTime iGlobalTime
uniform vec2 iResolution;


#define HASHSCALE3 vec3(.1031, .1030, .0973)
vec2 add = vec2(1.0, 0.0);
float hash12(vec2 p)
{
    vec3 p3  = fract(vec3(p.xyx) * HASHSCALE3.x);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.x + p3.y) * p3.z);
}

float hash13(vec3 p3)
{
    p3  = fract(p3 * HASHSCALE3.x);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.x + p3.y) * p3.z);
}

vec2 hash21(float p)
{
    vec3 p3 = fract(vec3(p) * HASHSCALE3);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.xx+p3.yz)*p3.zy);
}

vec2 getcell(vec2 uv, float z, float s1)
{
    return (round(uv*s1)/s1);
}

float noise12(vec2 x)
{
    vec2 p = floor(x);
    vec2 f = fract(x);
    f = f*f*(3.0-2.0*f);
    float res = mix(mix(hash12(p),          hash12(p + add.xy),f.x),
                    mix(hash12(p + add.yx), hash12(p + add.xx),f.x),f.y);
    return res;
}

float grid(vec2 uv, vec2 cell, float diagonal, float s1, float s2, vec2 t)
{
    float pot = 0.0;
    float outer = clamp(distance(pow(abs(uv),vec2(s2)), vec2(0)), 0.0, 1.0);

    float inner = clamp(distance(pow(abs(uv)*t,vec2(s2)), vec2(0)), 0.0, 1.0);
    pot = outer-inner;
        
        #if 1
        {
            //float dir = hash13(vec3(floor(cell/s1), floor(-33.+12.0*iTime)))>0.5?-1.0:1.0;
            uv += sign(-uv);
            pot += (inner)*pow(smoothstep(0.91,0.93,0.93*t.x-distance(uv, uv.yx)),1.0);
            pot += (inner)*pow(smoothstep(0.91,0.93,0.93*t.x-distance(-uv, uv.yx)),1.0);
            /*
            uv /= 2.0;
            
            float outer = clamp(distance(pow(abs(uv),vec2(s2)), vec2(0)), 0.0, 1.0);
        
            float inner = clamp(distance(pow(abs(uv)*t,vec2(s2)), vec2(0)), 0.0, 1.0);
*/
            /*
            pot -= 0.7*(outer)*pow(smoothstep(0.91,0.95,0.936*t.x-distance(uv, uv.yx)),1.0);
            pot -= 0.7*(outer)*pow(smoothstep(0.91,0.95,0.936*t.x-distance(-uv, uv.yx)),1.0);
*/
        }
        #endif
    
    return max(0.0, pot);
}

void main()
{
    // params
    float mv  = 0.1;
    float zv  = (2.0/3.0)*0.4*pow(mod(0.52083333*1.5*iTime,0.8),0.9);
          //zv  = round(zv*2.0)/2.0;
          mv += zv*0.1;
    float zoom = (1.5-zv);
    float sm = 600.0;
    vec2 thicc = vec2(0.995);
    float spacing = 2.8;//+3.0*pow(hash21(floor(-55.+12.0*iTime)).x, 6.0);
    
    vec2 uv = -1.0+2.0*UV;
    uv.y *= iResolution.y/iResolution.x;
    uv *= 1.9;
    float rot = 3.14159*round(0.52083333*iTime*4.0)/4.0;
    uv *= mat2(cos(rot), -sin(rot), sin(rot), cos(rot));
    //uv *= mix(1.0, pow(length(uv),2.0), 1.)*vec2(1);
    /*
    float xr = (3.14159/2.0)*0.5;//(5.0*(pow(noise12(vec2(77.-iTime*0.27)),6.0)-pow(noise12(vec2(-55.+iTime*.19)),8.0)));
    vec3 u3 = vec3(uv, -1.0)*mat3(cos(xr), 0,sin(xr),0,1,0,-sin(xr),0, cos(xr));
    // project back (works???)
    //u3.y -= 3.0;
    uv.x = (u3.x*iResolution.x)/(u3.z*iResolution.x)*2.0;
    uv.y = (u3.y*iResolution.y)/(u3.z*iResolution.y)*2.0;
    */
    float mult = 1.0;
    fragColor = vec4(0.0);
    fragColor.a = 1.0;
    for(int i = 0; i < 8; i++)
    {
        float rc = 0.3*(1.0-2.0*noise12(vec2(1.7*iTime)));
        rc += 0.12*(1.0-2.0*noise12(vec2(2.5*iTime)));
        rc += 0.05*(1.0-2.0*noise12(vec2(3.3*iTime)));
        float rot = (rc-zv*0.4*rc)*1.0;
        rot = round(rot*7.0)/7.0;
        //rot = clamp(rot, -0.056, 0.056);
        mat2 rm = mat2(cos(rot), -sin(rot), sin(rot), cos(rot));
        
        
        fragColor.rgb += vec3(grid(uv*zoom, vec2(0), 1.0, spacing, sm, thicc))*mult;//*pow(min(1.0, 0.1+0.2*float(i)),0.5);
        //fragColor.rgb = min(vec3(0.9), fragColor.rgb);
        uv *= rm;
        uv *= round((1.06+0.04*sin(iTime*1.7))*12.0)/12.0;
        uv += round( ((-1.0+2.0*vec2(noise12(vec2(iTime*1.6)),noise12(vec2(iTime*1.6))))*0.1)*12.0)/12.0;
        
        //mult *= 0.95*mix(1.0,0.95,zv);
        
        float pp = 5.0;
        float xr = round((3.14159/2.0)*(-1.0+2.0*(float(i)/90.0))*0.01*sin(0.01*float(i)+iTime*1.5)*12.0)/12.0;
        vec3 u3 = vec3(uv, pp)*mat3(cos(xr), 0,sin(xr),0,1,0,-sin(xr),0, cos(xr));
        // project back (works???)
        //u3.y -= 3.0;
        uv.x = (u3.x*iResolution.x)/(u3.z*iResolution.x)*pp;
        uv.y = (u3.y*iResolution.y)/(u3.z*iResolution.y)*pp;
    }
    
    //fragColor = 1.0-fragColor;
    //fragColor *= 0.55;
    fragColor = pow(fragColor*0.6, vec4(0.4545));
}