#version 430

in vec2 fragCoord;
out vec4 fragColor;

uniform float iGlobalTime;
uniform vec2 iResolution;
uniform vec3 iMouse;
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform float drum;
uniform float incDrum;
//////////////////////////////////////////////////////


vec2 un(vec2 a, vec2 b)
{
	return a.x < b.x ? a : b;
}

float sdCylinder( vec3 p, float r )
{
  return length(p.xz)-r;
}

vec4 texCube( sampler2D sam, in vec3 p, in vec3 n, in float k )
{
	vec4 x = texture2D( sam, p.yz );
	vec4 y = texture2D( sam, p.zx );
	vec4 z = texture2D( sam, p.xy );
    vec3 w = pow( abs(n), vec3(k) );
	return (x*w.x + y*w.y + z*w.z) / (w.x+w.y+w.z);
}

float sdHexPrism( vec3 p, vec2 h )
{
    vec3 q = abs(p);
    return max(q.z-h.y,max((q.x*0.866025+q.y*0.5),q.y)-h.x);
}

float udRoundBox( vec3 p, vec3 b, float r )
{
  return length(max(abs(p)-b,0.0))-r;
}

float sdCappedCylinder( vec3 p, vec2 h )
{
  vec2 d = abs(vec2(length(p.xz),p.y)) - h;
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

float sdTorus( vec3 p, vec2 t )
{
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return length(q)-t.y;
}

float specular(vec3 normal, vec3 light, vec3 viewdir, float s)
{
	float nrm = (s + 8.0) / (3.1415 * 8.0);
	float k = max(0.0, dot(viewdir, reflect(light, normal)));
    return  pow(k, s);
}

float smin( float a, float b)
{
	float k = 0.8;
    float h = clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 );
    return mix( b, a, h ) - k*h*(1.0-h);
}

float smink( float a, float b, float k )
{
    float h = clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 );
    return mix( b, a, h ) - k*h*(1.0-h);
}
vec2 sun(vec2 a, vec2 b)
{
	float sm = smin(a.x,b.x);
	float ca = abs(sm -a.x);
	float cb = abs(sm -b.x);

	return ca < cb ? vec2(sm, a.y) : vec2(sm, b.y);
}

vec2 sunk(vec2 a, vec2 b, float k)
{
	float sm = smink(a.x,b.x, k);
	float m = min(a.x, b.x);
	float ca = abs(sm -a.x);
	float cb = abs(sm -b.x);
	return ca < cb ? vec2(sm, a.y) : vec2(m, b.y);
}

vec4 modLight(vec3 pos) {

	vec2 d = vec2(2.0);
	pos.z -= iGlobalTime;
	vec2 part = floor((pos.xz + d* 0.5) / d);
	pos.xz = mod(pos.xz, d) - d * 0.5;

	vec3 lightPos = vec3(0.0, -0.3, 0.0);
	vec3 lightCol = vec3(1);
	vec3 L = lightPos-pos;
	float distanceToL = max(0.0001, length(L) -0.01*(0.5 + 1.0*drum));
	vec3 point = lightCol * 0.5/(distanceToL*distanceToL);

	return vec4(point * (0.5 + 1.0*drum), distanceToL);
}



#define LPOS vec3(0, 3 - smoothstep(0, 2, iGlobalTime)*3 + 3 + smoothstep(5, 10, iGlobalTime) * 4, 3)


vec4 slight(vec3 p) {
	p -= vec3(4, 0, 0);
		vec3 lightCol  = vec3(1);
		float a  = atan(p.z, p.x);
		float r = length(p.xz);
		//r = mod(r,5) - 0.5;
	//	a = mod(a + iGlobalTime, 1) - 0.5;
		vec3 pn = vec3(r*cos(a), p.y, r*sin(a));
	//	float dis = udRoundBox(pn, vec3(1), 0.5);
	//	float dis = sdCylinder(pn,  0.2);
		float s = 2.5;
		float rr = sin(p.y);
		float dis = sdCylinder(p - vec3(rr*cos(p.y * s - 4*iGlobalTime), 0, rr*sin(p.y * s - 4*iGlobalTime)),  0.15);
		float dis2 = sdCylinder(p - vec3(-rr*cos(p.y * s - 4*iGlobalTime), 0, -rr*sin(p.y * s - 4*iGlobalTime)),  0.15);
		rr *= 1.9 ;
		float dis3 = sdCylinder(p - vec3(rr*cos(p.y * s - 4*iGlobalTime), 0, rr*sin(p.y * s - 4*iGlobalTime)),  0.1);
		float dis4 = sdCylinder(p - vec3(-rr*cos(p.y * s - 4*iGlobalTime), 0, -rr*sin(p.y * s - 4*iGlobalTime)),  0.1);
		dis = smin(dis, dis2);
		dis3 = smin(dis3, dis4);
		dis = smin(dis, dis3);
		float sp = length(p - vec3(0, -2, 0)) - 2;
		dis = smin(sp, dis);
		float distanceToL = max(0.0001, dis);
		vec3 point = lightCol * 50.0/(distanceToL*distanceToL);
		return vec4(point, distanceToL);
}

vec4 light(vec3 p) {

	float s = 30.0;
	p.xz = mod(p.xz + vec2(s*0.5), s) - s * 0.5;
	float t = iGlobalTime;
	vec3 lightCol  = vec3(1);
			lightCol = normalize(lightCol);
	vec3 lightPos = LPOS;
	vec3 L = lightPos-p;
	float sp = length(L - vec3(0, -0.1, 0)) - 0.1;
	float tor = sdTorus(L, vec2(1.0, 0.0));
	float dis = 	min(sp, tor);
	float distanceToL = max(0.0001, dis);
	vec3 Lnorm = L/distanceToL;

	vec3 point = vec3(1) * 70.0/(distanceToL*distanceToL);


	return vec4(point, distanceToL);
}
#define GRASS_END_DRUM 11.0
vec4 dimLight(vec3 p) {
	vec3 o = p;
//	p -= vec3(-3, -0.3, 0);
	float s = 10.0;
	float partX = floor(p.x / s);
	p.x += cos(p.z) * 0.5 * mod(partX + 1.0, 2.0) * smoothstep(9, 11, iGlobalTime);// / 2.0;
	vec3 q = p;
	q.x = mod(p.x, s) - s * 0.5;
//	float c = min(1, abs(sin(p.z * 0.1 - iGlobalTime * 1 + partX * 5)));
	float c = min(1, abs(sin(p.z * 0.1 - (incDrum +  1 - drum) * 0.5 + partX * 5)))* smoothstep(11, 13, iGlobalTime);
	vec3 lightCol  = vec3(1, c, (1-c)*sin(partX)*0.5 + 0.5);
	lightCol = normalize(lightCol);

	float d = (incDrum +  1 - drum);
	q.y +=  min(1.2*cos(p.x + 2*(GRASS_END_DRUM + 1)) + 0.6*sin(0.6*p.z - 3*(GRASS_END_DRUM + 1)).x - 0.0, -10 + iGlobalTime);

	float dis = max(0.0001, sdCylinder(q.xzy /*- vec3(cos(p.z) * 0.5 * mod(partX, 2.0) / 2.0, 0, sin(p.z) * 0.5 * mod(partX + 1.0, 2.0) / 2.0)*/, 0.1*pow((1-c), 30.0)));
//	float dis2 = max(0.0001, sdCylinder(p.xzy + vec3(cos(p.z) * 0.5 * mod(partX, 2.0) / 2.0, 0, sin(p.z) * 0.5 * mod(partX + 1.0, 2.0) / 2.0), 0.0));
//	dis = min(dis, dis2);
//	float distanceToL = max(0.0001, p.y + 0.5);

	vec3 point = (0.1 + pow((1-c), 30.0)) * lightCol * 30.0/(dis*dis);


	return vec4(point, dis);
}


vec3 evaluateLight(vec3 pos, inout float dis)
{
	vec4 l = light(pos);
	dis = l.w;
//	vec4 sl = slight(pos);
	vec4 sl = dimLight(pos);
	dis = min(l.w, sl.w);
//	dis = l.w;
	return (l.xyz + sl.xyz)  * (1 + 500*smoothstep(29.0, 30.0,iGlobalTime));
//	return l.xyz;
}

void addLightning(inout vec3 color, vec3 normal, vec3 eye, vec3 pos) {

	vec3 lpos = LPOS;//vec3(1, 1, -2);

	float dis = length(lpos - pos);
	vec3 invLight = normalize(lpos - pos);
	float diffuse = max(0.0, dot(invLight, normal));
	float spec = specular(normal, -invLight, normalize(eye - pos), 220.0);

	float str = 1.0/(0.5 + 0.01*dis + 0.1*dis*dis);
	//str = towerLight(pos).x;
	float tmp = 0;
	color =  color * (0.05 + 0.8*diffuse*light(pos).xyz) + spec*str;
	color = clamp(color, vec3(0), vec3(1));
	//color *= str;
}



mat3 rot(float x, float y, float z)
{
	float cx = cos(x);
	float sx = sin(x);
	float cy = cos(y);
	float sy = sin(y);
	float cz = cos(z);
	float sz = sin(z);
	mat3 xm = mat3(1, 0, 0,
					0, cx, -sx,
					0, sx, cx);
	mat3 ym = mat3(cy, 0, sy,
			  		0, 1, 0,
			  		-sy, 0, cy);
	mat3 zm = mat3(cz, -sz, 0,
					sz, cz, 0,
					0, 0, 1);
	return xm * ym * zm;
}

#define TEX 0.2
#define SIZE 8.0
#define PI 3.1415

#define MAT_TREE 1.0
#define MAT_GROUND 2.0




//x = cos(t) ,y = sin(t) z = ct

vec2 ground(vec3 p) {
//	if (p.y > 0) {
//		return vec2(p.y + 0.01, MAT_GROUND);
//	}
	float s = 2.0;
	vec3 q = mod(p, s) - s * 0.5;
	q.y = p.y;
	float dis = udRoundBox(q, vec3(s * 0.2), s * 0.05);
	float c = sdCylinder(p, 2.0);
//	dis = max(-c, dis);
	return vec2(dis, MAT_GROUND);
}

vec2 grassCube(vec3 p)  {
 //sampler2D sam, in vec3 p, in vec3 n, in float k
	float dis = udRoundBox(p, vec3(0.5), 0.1) - texCube(iChannel0, p, normalize(p), 1 ).x * 1.5;
//	float dis = p.y - 0.3*texture(iChannel0, p.xz*0.5 ).x - 3.0*texture(iChannel0, p.xz*0.05).x ;

	return vec2(dis * 0.1, MAT_GROUND);
}

vec2 grass(vec3 p)  {

//	float dis = p.y - 1.3*texture(iChannel0, p.xz*0.5 ).x + 1.2*cos(p.x + 2*iGlobalTime) + 0.6*sin(0.6*p.z - 3*iGlobalTime);
//	float dis = p.y - 0.3*texture(iChannel0, p.xz*0.5 ).x - 3.0*texture(iChannel0, p.xz*0.05).x ;
	float d = (incDrum + 1 - drum);
	d = min(d, GRASS_END_DRUM ) + smoothstep(4,6,iGlobalTime);
	float dis = p.y - 1.3*texture(iChannel0, p.xz*0.5 ).x + 1.2*cos(p.x + 2*d) + 0.6*sin(0.6*p.z - 3*d);

	return vec2(dis * 0.1, MAT_GROUND);
}

vec2 tree(vec3 p) {
	float a  = atan(p.z, p.x);
	float r = length(p.xz);
	//r = mod(r,5) - 0.5;
//	a = mod(a + iGlobalTime, 1) - 0.5;
	vec3 pn = vec3(r*cos(a), p.y, r*sin(a));
//	float dis = udRoundBox(pn, vec3(1), 0.5);
//	float dis = sdCylinder(pn,  0.2);
	float s = 2.5;
	float rr = sin(p.y);
	float dis = sdCylinder(p - vec3(rr*cos(p.y * s - 4*iGlobalTime), 0, rr*sin(p.y * s - 4*iGlobalTime)),  0.15);
	float dis2 = sdCylinder(p - vec3(-rr*cos(p.y * s - 4*iGlobalTime), 0, -rr*sin(p.y * s - 4*iGlobalTime)),  0.15);
	rr *= 1.9 ;
	float dis3 = sdCylinder(p - vec3(rr*cos(p.y * s - 4*iGlobalTime), 0, rr*sin(p.y * s - 4*iGlobalTime)),  0.1);
	float dis4 = sdCylinder(p - vec3(-rr*cos(p.y * s - 4*iGlobalTime), 0, -rr*sin(p.y * s - 4*iGlobalTime)),  0.1);
	dis = smin(dis, dis2);
//	dis3 = smin(dis3, dis4);
	dis = smin(dis, dis3);
	float sp = length(p - vec3(0, -2, 0)) - 2;
	dis = smin(sp, dis);
	return vec2(0.2*dis, MAT_TREE);
}

vec2 map(vec3 p, vec3 rd, inout bool inRef) {
//	vec2 res = ground(p - vec3(0, -1, 0));
	vec2 res = grass(p - vec3(0, -1, 0));
//	vec2 res = grassCube(p - vec3(0, -1, 0));
//	vec2 tres = tree(p);
//	if (tres.x >= 0.01) {
//		inRef = false;
//	}
//	if (!inRef) {
//		res = un(res, tres);
//	}
	return res;
}

vec2 map(vec3 p, vec3 rd) {
	bool tmp = false;
	return map(p, rd, tmp);
}

vec3 getNormal(vec3 p, vec3 rd)
{
	vec3 normal;
    vec3 ep = vec3(0.01, 0, 0);
    normal.x = map(p + ep.xyz, rd).x - map(p - ep.xyz, rd).x;
    normal.y = map(p + ep.yxz, rd).x - map(p - ep.yxz, rd).x;
    normal.z = map(p + ep.yzx, rd).x - map(p - ep.yzx, rd).x;
    return normalize(normal);

}

float occlusion(vec3 p, vec3 normal, vec3 rd)
{
	float o = clamp(2*map(p + normal * 0.5, rd).x, 0, 1);
	return 0.2 + 0.8*o;
}



vec3 raymarch(vec3 ro, vec3 rd, inout vec3 finalPos, vec3 eye) {
	float t = 0.0;
	const int maxIter = 300;
	const float maxDis = 200.0;
	float d = 0.0;
	vec3 p = vec3(-1.0, -1.0, -1.0);
	vec3 col = vec3(0);
	const int jumps = 2;
	float ref = 1.0;
	vec3 scatteredLight = vec3(0.0);
	float transmittance = 1.0;
	bool inRef = false;
	for (int j = 0; j < jumps; j++) {
		for (int i = 0; i < maxIter; i++) {
			p = ro + rd * t;

			vec2 res = map(p, rd, inRef);
			d = res.x;
//			d = min(d, 0.2);
			float fogAmount = 0.01 * (0.5 + 0.5*smoothstep(3,5, iGlobalTime));// + max(0, -p.y * 0.5);
//			fogAmount += smoothstep(28*7, 29*7,p.z) * 5.0;
			float lightDis = -1.0;
			vec3 light = evaluateLight(p, lightDis);
//			d = min(d, lightDis);
			d = min(min(d, 1), max(lightDis * 0.2, 0.05));
			vec3 lightIntegrated = light - light * exp(-fogAmount * d);
			scatteredLight += transmittance * lightIntegrated;
			transmittance *= exp(-fogAmount * d);

			t += d;
			float m = res.y;
			bool end = i == maxIter - 1 ||t > maxDis;
			if (d < 0.01 || end) {
				vec3 c = vec3(1);
				vec3 normal = getNormal(p, rd);
				if (m == MAT_TREE) {
					c = vec3(0.9, 0.1, 0.2);
				} else if (m == MAT_GROUND) {
					c = mix(vec3(0.2,0.5,0.2), vec3(0.7,0.5,0.2), min(normal.y*2, 1));
				}
				c *= occlusion(p, normal, rd);
				addLightning(c, normal, eye, p);
				if (end) {
					transmittance = 0;
				}
				col = mix(col, transmittance * c + scatteredLight, ref);
//				col = mix(col, vec3(0.7), clamp(t * 0.01, 0, 1));
				if (m == MAT_TREE) {
					ref *= 0.4;
				} else {
					ref *= 0.0;
				}
//				ref = 0.0;
//				rd = reflect(rd, getNormal(p, rd));
				rd = refract(rd, getNormal(p, rd), 1/1.2);
				ro = p + rd*0.05;
				inRef = true;
				t = 0;
				break;
			}
			if (t > maxDis) {
				break;
			}
		}

		if (ref < 0.1) {
			break;
		}
	}
	finalPos = p;
	return col;
}





void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
	float u = (fragCoord.x / iResolution.x) * 2.0 - 1.0;
    float v = ((fragCoord.y / iResolution.y) * 2.0 - 1.0)  * (9.0/ 16.0);//* (iResolution.y/iResolution.x);
    
    vec3 eye = vec3(iGlobalTime, 8 , -7);
	vec3 tar = vec3(0,0, 0); //eye + vec3(0.0, 0.0, 1.0);
	float t = iGlobalTime;
	if (t > 18) {
//		vec3 p = vec3(0,3,iGlobalTime);
////		float d = (incDrum +  1 - drum);
//		float s = 10.0;
//		float partX = floor(p.x / s);
//		p.x += cos(p.z) * 0.5 * mod(partX + 1.0, 2.0) * smoothstep(9, 11, iGlobalTime);
//		vec3 q = p;
//		q.x = mod(p.x, s) - s * 0.5;
//
//		float d = (incDrum +  1 - drum);
//		q.y +=  min(1.2*cos(p.x + 2*(GRASS_END_DRUM + 1)) + 0.6*sin(0.6*p.z - 3*(GRASS_END_DRUM + 1)).x - 0.0, -10 + iGlobalTime);
		eye = vec3(7, 3, t * 7 - 5);
		tar = eye + vec3(0, -0.4, 1);
	} else  if (t > 6) {
		eye = vec3(8 + iGlobalTime, 15, -7 + iGlobalTime);
		tar = eye + vec3(1, -2, 1);
	}

	vec3 dir = normalize(tar - eye);
	vec3 right = normalize(cross(vec3(0, 1, 0), dir));
	vec3 up = cross(dir, right);

	vec3 ro = eye;
	vec3 rd = normalize(dir + right*u + up*v);

	vec3 light = vec3(0.0, 0.0, 26.0 );

	vec3 finalPos = vec3(-1.0, -1.0, -1.0);
	float material = -1.0;
	vec3 color = raymarch(ro, rd, finalPos, eye);
    fragColor = vec4(color, 1.0);
    fragColor.rgb = fragColor.rgb / (fragColor.rgb + vec3(1.0));
    fragColor.rgb = mix(fragColor.rgb, vec3(1), smoothstep(29.5, 30.0, iGlobalTime));
}

/////////////////////////////////////////////////////
void main()
{
	mainImage(fragColor, fragCoord);
}
