#version 430

in vec2 fragCoord;
out vec4 fragColor;

uniform float iGlobalTime;
uniform vec2 iResolution;
uniform vec3 iMouse;
uniform sampler2D iChannel0;



vec4 texCube( sampler2D sam, in vec3 p, in vec3 n, in float k )
{
	vec4 x = texture2D( sam, p.yz );
	vec4 y = texture2D( sam, p.zx );
	vec4 z = texture2D( sam, p.xy );
    vec3 w = pow( abs(n), vec3(k) );
	return (x*w.x + y*w.y + z*w.z) / (w.x+w.y+w.z);
}

float sdSphere( vec3 p, float s )
{
  return length(p)-s;
}

float udRoundBox( vec3 p, vec3 b, float r )
{
  return length(max(abs(p)-b,0.0))-r;
}

float udBox( vec3 p, vec3 b )
{
  return length(max(abs(p)-b,0.0));
}

float sdBox( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0));
}

float sdCylinder( vec3 p, vec3 c )
{
  return length(p.xz-c.xy)-c.z;
}

float sdCappedCylinder( vec3 p, vec2 h )
{
  vec2 d = abs(vec2(length(p.xz),p.y)) - h;
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}


vec2 map(vec3 p)
{	
	float sphere = length(p - vec3(4,2.0 ,0)) - 2.0;
	float box = sdBox(p - vec3(0.0, 2.0 + sin(iGlobalTime) * 0.00010, 0.0), vec3(2.0));
	float ground = sdBox(p - vec3(0.0, -30.0, 0.0), vec3(30.0));
	float material = box < ground || sphere < ground ? 0.5 : 0.2;
	return vec2(min(sphere, min(box, ground)), material);
}



vec3 getNormal(vec3 p)
{
	vec3 normal;
    vec3 ep = vec3(0.01, 0, 0);
    normal.x = map(p + ep.xyz).x - map(p - ep.xyz).x;
    normal.y = map(p + ep.yxz).x - map(p - ep.yxz).x;
    normal.z = map(p + ep.yzx).x - map(p - ep.yzx).x;
    return normalize(normal);

}

float raymarch(vec3 ro, vec3 rd, inout vec3 finalPos) 
{
	float t = 0.0;
    const int maxIter = 100;
    
    float material = 0.0;
    
    vec3 p = vec3(-1.0, -1.0, -1.0);
    for (int i = 0; i < maxIter; i++) {
        p = ro + rd * t;

    	vec2 dm = map(p);
        if (dm.x < 0.01) {
        	material = dm.y;
        	break;
        }
        t += dm.x * 1.0;
    }
    finalPos = p;
    return material;
}

#define PI 3.1415
float occlusion_(vec3 p, vec3 normal) {
	
	float phi = acos(normal.z / length(normal));
	float theta = atan(normal.y, normal.x);
	
	float iter = 10.0;
	float d = 0;
	for (float i = 0; i < PI; i += PI / iter) {
		for (float j = 0; j < PI * 2.0; j += 2.0 * PI / iter) {
			float r = 0.1;
			float x = r * sin(phi + i) * cos(theta + j - PI);
			float y = r * sin(phi + i) * sin(theta + j - PI);
			float z = r * cos(phi + i);
			float md = map(p + vec3(x,y,z)).x;
			if(md > 0){
				d += max(0, dot(normal, normalize(vec3(x,y,z))));
			}
			//d += sign(map(p + vec3(x, y, z)).x);
		}
	}
	d /= (iter * iter);

	return d;
}

float occlusion(vec3 p, vec3 normal)
{
	float o = 2*map(p + normal * 0.5).x;
	return 0.8 + 0.2*o;
}



float specular(vec3 normal, vec3 light, vec3 viewdir, float s)
{
	float nrm = (s + 8.0) / (3.1415 * 8.0);
	float k = max(0.0, dot(viewdir, reflect(light, normal)));
    return  pow(k, s);
}

void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
	float u = (fragCoord.x / iResolution.x) * 2.0 - 1.0;
    float v = ((fragCoord.y / iResolution.y) * 2.0 - 1.0) * (iResolution.y/iResolution.x);
    
 	vec3 eye = vec3(10.0, 10.0 , 10.0);
   // vec3 tar = eye + vec3(0.0, 0.0, 0.1);
   	vec3 tar = vec3(0, 0, 0);
    vec3 dir = normalize(tar - eye);
	vec3 right = normalize(cross(vec3(0, 1, 0), dir)); 
 	vec3 up = cross(dir, right);
    
	vec3 ro = eye;	
    vec3 rd = normalize(dir + right*u + up*v);
    
    vec3 light = vec3(0.0, 20.0, -20.0);
    
    vec3 finalPos = vec3(-1.0, -1.0, -1.0);
    float material = raymarch(ro, rd, finalPos);
   	vec3 color = vec3(0.5, 0.0, 0.2);
	vec3 normal = getNormal(finalPos);
	vec3 invLight = normalize(light - finalPos);
	invLight = normalize(vec3(0.6,0.7,0));
  	float diffuse = max(0.0, dot(invLight, normal));
	color = vec3(material) * occlusion(finalPos, normal);
	//color = vec3(occlusion(finalPos, normal));
	color = 0.7 * color * (1.0 + diffuse);
    color += specular(normal, -invLight, normalize(eye - finalPos), 70.0);
 
    fragColor = vec4(color, 1.0);
}

void main()
{
	mainImage(fragColor, fragCoord);
}
