/*
 * Decompiled with CFR 0.152.
 */
package effects;

import game.Game;
import game.MathUtils;
import game.Player;
import game.Vec3;
import renderer.ResourceHandler;
import renderer.glengine.Matrix4f;
import renderer.glengine.MeshBatch;
import renderer.glengine.Texture;

public class Particle {
    public Vec3 pos;
    Vec3 prevPos;
    Vec3 velocity;
    int ticksLeft;
    Vec3 color;
    double size = 0.5;
    double rot = 0.0;
    int totalTicks;
    Game game;
    Texture texture = ResourceHandler.smoke;
    double colorMix = 0.5;

    public Particle(Vec3 pos, Vec3 velocity, int ticks, Vec3 color, Game game) {
        this(pos, velocity, ticks, color, 0.14 + MathUtils.random() * 0.8, game);
    }

    public Particle(Vec3 pos, Vec3 velocity, int ticks, Vec3 color, double size, Game game) {
        this.pos = pos.clone();
        this.prevPos = pos.clone();
        this.velocity = velocity.clone();
        this.ticksLeft = ticks;
        this.color = color;
        this.size = size;
        this.rot = MathUtils.random() * 360.0;
        this.totalTicks = ticks;
        this.game = game;
    }

    public Particle(Vec3 pos, Vec3 velocity, int ticks, Game game) {
        this.pos = pos.clone();
        this.prevPos = pos.clone();
        this.velocity = velocity.clone();
        this.ticksLeft = ticks;
        this.color = new Vec3(1.0, (float)(MathUtils.random() * (1.0 - MathUtils.random())), 0.0);
        this.size = 0.7 + MathUtils.random() * 4.0;
        this.rot = MathUtils.random() * 360.0;
        this.totalTicks = ticks;
        this.game = game;
    }

    public boolean tick() {
        --this.ticksLeft;
        this.prevPos = this.pos.clone();
        this.pos.add(this.velocity);
        return this.isDone() || this.ticksLeft <= 0;
    }

    public boolean isDone() {
        return false;
    }

    public double realZ(Player p) {
        return p.pos.lengthDifference(this.pos);
    }

    public void render(MeshBatch mb, Player player) {
        long dt = 16L;
        double intrp = 1.0;
        double ix = this.prevPos.x + (this.pos.x - this.prevPos.x) * intrp;
        double iy = this.prevPos.y + (this.pos.y - this.prevPos.y) * intrp;
        double iz = this.prevPos.z + (this.pos.z - this.prevPos.z) * intrp;
        float size = (float)this.size;
        Matrix4f.Pipeline p = new Matrix4f.Pipeline();
        p.add(Matrix4f.rotate((float)Math.toDegrees(player.headingUpDownRad), 1.0f, 0.0f, 0.0f));
        p.add(Matrix4f.rotate((float)Math.toDegrees(player.headingRad), 0.0f, 1.0f, 0.0f));
        p.add(Matrix4f.scale(size, size, size));
        p.add(Matrix4f.translate((float)ix, (float)iy, (float)iz));
        mb.addTransparent(ResourceHandler.quad, this.texture, p.getMatrix(), mb.nextVector3f((float)this.color.x, (float)this.color.y, (float)this.color.z), false, (float)this.colorMix, this.realZ(player), this.pos);
    }
}

