/*
 * Decompiled with CFR 0.152.
 */
package entities;

import entities.Entity;
import game.Enemy;
import game.Game;
import game.Player;
import javax.vecmath.Vector3f;
import physics.Physics;
import renderer.ResourceHandler;

public class Billys
extends Entity {
    public boolean inThrow = false;

    public Billys(Physics physics, Vector3f pos, Vector3f rot) {
        this(physics, pos, rot, -1);
    }

    public Billys(Physics physics, Vector3f pos, Vector3f rot, int spawnIndex) {
        super(physics, pos, rot, ResourceHandler.billys, null, true, ResourceHandler.billysTexture, 1.0, 2.0f, 6.0f);
        this.throwDamage = 20.0;
        this.spawnIndex = spawnIndex;
    }

    @Override
    public boolean canBePickedUp() {
        return true;
    }

    @Override
    public boolean use(Game game, Physics.CustomClosestRayResultCallback c) {
        game.sound.play(game.sound.EATING);
        game.player.giveHealth(20.0);
        game.player.addScore(10);
        return true;
    }

    @Override
    public void throwItem(Player player) {
        super.throwItem(player);
        this.inThrow = true;
    }

    @Override
    public void collidedWith(Entity entity) {
        if (entity instanceof Enemy && this.inThrow) {
            Enemy e = (Enemy)entity;
            e.state = Enemy.State.PHYSICS;
            Vector3f lin = new Vector3f();
            this.body.getLinearVelocity(lin);
            lin.normalize();
            lin.scale(50.0f);
            Vector3f cen = this.getCenter();
            Vector3f epos = e.getCenter();
            Vector3f rel = new Vector3f(epos.x - cen.x, epos.y - cen.y, epos.z - cen.z);
            e.getBody().applyImpulse(lin, rel);
            e.getBody().activate();
        }
        this.inThrow = false;
    }
}

