/*
 * Decompiled with CFR 0.152.
 */
package entities;

import com.bulletphysics.linearmath.Transform;
import entities.Entity;
import game.Enemy;
import game.Game;
import game.Vec3;
import javax.vecmath.Vector3f;
import lights.DecayingLight;
import physics.Physics;
import renderer.ResourceHandler;
import renderer.glengine.Matrix4f;
import renderer.glengine.MeshBatch;
import renderer.glengine.Window;

public class Minigun
extends Entity {
    private double damage = 5.0;
    private int ammo = 200;
    private int reloadTime = -1;
    Game game;
    private float rot;
    private final int RELOAD_TIME = 2;

    public Minigun(Physics physics, Vector3f pos, Vector3f rot, Game game) {
        this(physics, pos, rot, game, -1);
    }

    public Minigun(Physics physics, Vector3f pos, Vector3f rot, Game game, int itemSpawnIndex) {
        super(physics, pos, rot, ResourceHandler.minigun, null, true, ResourceHandler.scratch, 1.0, 0.8f);
        this.game = game;
        this.throwDamage = 20.0;
        this.spawnIndex = itemSpawnIndex;
    }

    @Override
    public boolean canBePickedUp() {
        return true;
    }

    @Override
    public boolean use(Game game, Physics.CustomClosestRayResultCallback c) {
        this.reloadTime = 2;
        this.rot += 10.0f;
        if (this.ammo <= 0) {
            return false;
        }
        if (c.e != null) {
            c.e.onHit(game);
            if (c.e instanceof Enemy) {
                Enemy e = (Enemy)c.e;
                e.hp -= this.damage;
            }
        }
        game.sound.play(game.sound.MINIGUN);
        --this.ammo;
        this.light();
        return false;
    }

    private void light() {
        Vec3 v = this.game.player.pos.subtract(new Vec3(this.getCenter()));
        v.multiply(2.0);
        this.game.lights.add(new DecayingLight(new Vec3(this.game.player.pos.x + v.x, this.game.player.pos.y + v.y, this.game.player.pos.z + v.z), new Vec3(1.0, 0.5, 0.1), 1.0f, 200){

            @Override
            public float getLightDirPow() {
                return 0.0f;
            }

            @Override
            public Vec3 getDir() {
                return new Vec3(0.0, 0.0, 0.0);
            }

            @Override
            public boolean volumetric() {
                return false;
            }
        });
    }

    @Override
    public void render(MeshBatch meshBatch) {
        Transform trans = new Transform();
        this.body.getWorldTransform(trans);
        javax.vecmath.Matrix4f mat = new javax.vecmath.Matrix4f();
        trans.getMatrix(mat);
        Matrix4f real = new Matrix4f();
        real.m00 = mat.m00;
        real.m01 = mat.m01;
        real.m02 = mat.m02;
        real.m03 = mat.m03;
        real.m10 = mat.m10;
        real.m11 = mat.m11;
        real.m12 = mat.m12;
        real.m13 = mat.m13;
        real.m20 = mat.m20;
        real.m21 = mat.m21;
        real.m22 = mat.m22;
        real.m23 = mat.m23;
        real.m30 = mat.m30;
        real.m31 = mat.m31;
        real.m32 = mat.m32;
        real.m33 = mat.m33;
        real = real.multiply(Matrix4f.scale(this.scale, this.scale, this.scale));
        Matrix4f fix = Matrix4f.translate(-this.boxTranslation.x, -this.boxTranslation.y, -this.boxTranslation.z);
        real = real.multiply(fix);
        real = real.multiply(Matrix4f.rotate(this.rot, 1.0f, 0.0f, 0.0f));
        meshBatch.add(this.mesh, this.dnsTexture, real);
    }

    @Override
    public void useDown(Game game, Physics.CustomClosestRayResultCallback c) {
        if (this.reloadTime <= 0) {
            this.use(game, c);
            this.reloadTime = 2;
        }
    }

    @Override
    public void update() {
        --this.reloadTime;
    }

    @Override
    public void renderInHand(MeshBatch mb, boolean leftHand) {
        if (this.reloadTime >= 2 && this.ammo > 0) {
            float angle = !leftHand ? -0.25f : 0.2f;
            Vec3 l = new Vec3(0.0, 0.0, 0.0);
            float a = 0.2f;
            float b = 4.0f;
            l.x = Math.cos(-this.game.player.headingUpDownRad / (double)b + (double)a) * Math.sin(this.game.player.headingRad + (double)angle);
            l.y = Math.sin(-this.game.player.headingUpDownRad / (double)b + (double)a);
            l.z = Math.cos(-this.game.player.headingUpDownRad / (double)b + (double)a) * Math.cos(this.game.player.headingRad + (double)angle);
            l.normalize();
            l.normalize();
            l.multiply(2.5);
            float x = (float)(this.game.player.pos.x - l.x);
            float y = (float)(this.game.player.pos.y - l.y);
            float z = (float)(this.game.player.pos.z - l.z);
            Matrix4f.Pipeline p = new Matrix4f.Pipeline();
            p.add(Matrix4f.rotate((float)(Math.random() * 360.0), 0.0f, 0.0f, 1.0f));
            p.add(Matrix4f.rotate((float)Math.toDegrees(this.game.player.headingRad), 0.0f, 1.0f, 0.0f));
            float scale = 0.6f + (float)Math.random() * 0.3f;
            p.add(Matrix4f.scale(scale, scale, scale));
            p.addTranslate(x, y, z);
            mb.addTransparent(ResourceHandler.quad, ResourceHandler.muzzleFlash, p.getMatrix(), mb.nextVector3f(1.0f, 1.0f, 1.0f), true, 0.5f, 1.0, new Vec3(x, y, z));
        }
        if (leftHand) {
            mb.addString("Minigun AMMO " + this.ammo, mb.nextVector3f(20.0f, Window.height - 80, 0.0f), mb.nextVector3f(1.0f, 1.0f, 0.3f), ResourceHandler.ui);
        } else {
            mb.addString("Minigun AMMO " + this.ammo, mb.nextVector3f(Window.width - 285, Window.height - 80, 0.0f), mb.nextVector3f(1.0f, 1.0f, 0.3f), ResourceHandler.ui);
        }
    }
}

