/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.bulletphysics.linearmath.Transform;
import entities.Entity;
import game.DroidModel;
import game.Game;
import game.Model;
import game.Vec3;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import org.lwjgl.assimp.AIMesh;
import renderer.DiffuseNormalSpecularTexture;
import renderer.ResourceHandler;
import renderer.glengine.Matrix4f;
import renderer.glengine.MeshBatch;

public abstract class Enemy
extends Entity {
    protected AIMesh mesh;
    protected AIMesh lowPolyMesh;
    protected static float HEIGHT = 1.78f;
    protected DiffuseNormalSpecularTexture dnsTexture;
    protected Game game;
    protected boolean physicsActive = true;
    public double hp = 100.0;
    protected double attackRange = 2.0;
    private double damage = 10.0;
    private int attackCD = 60;
    private int currentAttackCD = 0;
    public boolean alive = true;
    DroidModel model = new DroidModel(this);
    public State state = State.FOLLOWING;

    public Enemy(Game game, double x, double y, double z, AIMesh mesh, AIMesh lowPolyMesh, DiffuseNormalSpecularTexture dnsTexture) {
        super(game.physics, new Vector3f((float)x, (float)y, (float)z), new Vector3f(0.0f, 0.0f, 0.0f), ResourceHandler.enemyHitbox, null, true, dnsTexture, 30.0);
        this.game = game;
        this.mesh = mesh;
        this.lowPolyMesh = lowPolyMesh;
        this.dnsTexture = dnsTexture;
    }

    @Override
    public void render(MeshBatch mb) {
        double dis = this.disToPlayer();
        Transform trans = new Transform();
        this.body.getWorldTransform(trans);
        javax.vecmath.Matrix4f mat = new javax.vecmath.Matrix4f();
        trans.getMatrix(mat);
        Matrix4f real = new Matrix4f();
        real.m00 = mat.m00;
        real.m01 = mat.m01;
        real.m02 = mat.m02;
        real.m03 = mat.m03;
        real.m10 = mat.m10;
        real.m11 = mat.m11;
        real.m12 = mat.m12;
        real.m13 = mat.m13;
        real.m20 = mat.m20;
        real.m21 = mat.m21;
        real.m22 = mat.m22;
        real.m23 = mat.m23;
        real.m30 = mat.m30;
        real.m31 = mat.m31;
        real.m32 = mat.m32;
        real.m33 = mat.m33;
        real = real.multiply(Matrix4f.scale(this.scale, this.scale, this.scale));
        Matrix4f fix = Matrix4f.translate(-this.boxTranslation.x, -this.boxTranslation.y, -this.boxTranslation.z);
        real = real.multiply(fix);
        Matrix4f.Pipeline p = new Matrix4f.Pipeline();
        p.add(real);
        this.model.render(mb, p);
    }

    private double disToPlayer() {
        Vector3f center = this.getCenter();
        Vec3 p = new Vec3(center.x, center.y, center.z);
        return p.lengthDifference(this.game.player.pos);
    }

    public void tick(Game game) {
        this.currentAttackCD = Math.max(0, this.currentAttackCD - 1);
        if (this.hp <= 0.0 && this.alive) {
            this.onDead();
            this.alive = false;
        }
        this.model.update();
        double dis = this.disToPlayer();
        double physicsDis = 1000.0;
        if (dis < physicsDis && !this.physicsActive) {
            this.physics.add(this.body);
            this.physicsActive = true;
        } else if (dis >= physicsDis && this.physicsActive) {
            this.physics.remove(this.body);
            this.physicsActive = false;
        }
        Transform trans = new Transform();
        this.body.getWorldTransform(trans);
        javax.vecmath.Matrix4f mat = new javax.vecmath.Matrix4f();
        trans.getMatrix(mat);
        Transform trans2 = new Transform();
        Quat4f q = new Quat4f();
        this.body.getCenterOfMassTransform(trans2);
        Vec3 dir = game.player.pos.subtract(this.getCenterVec3());
        dir.y = 0.0;
        dir.normalize();
        float force = 100.0f;
        dir.multiply(force);
        Matrix3f mm = new Matrix3f();
        mat.getRotationScale(mm);
        if (this.alive) {
            if (this.state == State.STANDING) {
                if ((double)mm.m11 > 0.99) {
                    this.state = State.FOLLOWING;
                } else {
                    this.body.applyForce(new Vector3f(0.0f, 250.0f, 0.0f), new Vector3f(mat.m01, mat.m11, mat.m21));
                    this.body.activate();
                    this.model.state = Model.State.PUNCHING;
                }
            } else if (this.state == State.FOLLOWING) {
                if ((double)mm.m11 < 0.5) {
                    this.state = State.STANDING;
                } else if (this.disToPlayer() > this.attackRange) {
                    this.model.state = Model.State.WALKING;
                    dir = game.player.pos.subtract(this.getCenterVec3());
                    dir.y = 0.0;
                    dir.normalize();
                    dir.multiply(6000.0);
                    trans = new Transform();
                    this.body.getWorldTransform(trans);
                    mat = new javax.vecmath.Matrix4f();
                    trans.getMatrix(mat);
                    float targetRot = (float)(Math.toRadians(-90.0) + Math.atan2(dir.x, dir.z));
                    float currentRot = (float)(Math.atan2(mat.m00, mat.m20) - Math.toRadians(90.0));
                    float delta = (float)Math.atan2(Math.sin(targetRot - currentRot), Math.cos(targetRot - currentRot));
                    mat.setRotation(new AxisAngle4f(0.0f, 1.0f, 0.0f, currentRot += delta * 0.03f));
                    trans.set(mat);
                    this.body.applyCentralForce(new Vector3f((float)dir.x, 0.0f, (float)dir.z));
                    Vector3f lin = new Vector3f();
                    this.body.getLinearVelocity(lin);
                    this.body.setLinearVelocity(new Vector3f(0.0f, lin.y, 0.0f));
                    this.body.setAngularVelocity(new Vector3f(0.0f, 0.0f, 0.0f));
                    this.body.setWorldTransform(trans);
                    this.body.activate();
                } else {
                    this.model.state = Model.State.PUNCHING;
                    if (this.currentAttackCD <= 0) {
                        game.player.takeDamage(this.damage);
                        game.sound.play(game.sound.PUNCH);
                        this.currentAttackCD = this.attackCD;
                    }
                }
            } else if (this.state == State.PHYSICS) {
                Vector3f lin = new Vector3f();
                this.body.getLinearVelocity(lin);
                if (lin.length() < 1.0f) {
                    this.state = State.STANDING;
                }
            }
        } else {
            this.model.state = Model.State.DEAD;
            if ((double)mm.m11 > 0.96) {
                this.body.applyForce(new Vector3f((float)(-dir.x), 0.0f, (float)(-dir.z)), new Vector3f(mat.m01, mat.m11, mat.m21));
                this.body.activate();
            }
        }
    }

    private void onDead() {
        this.game.player.kr += 30;
        this.game.player.addScore(100);
    }

    @Override
    public void onHit(Game game) {
        this.state = State.PHYSICS;
        super.onHit(game);
    }

    public Vec3 getCenterVec3() {
        return new Vec3(this.getCenter().x, this.getCenter().y, this.getCenter().z);
    }

    public static enum State {
        FOLLOWING,
        STANDING,
        PHYSICS;

    }
}

