/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Game;
import input.CharHandler;
import input.KeyHandler;
import input.MouseButtonHandler;
import input.ScrollHandler;
import renderer.glengine.MeshBatch;
import renderer.glengine.Window;

public class Main {
    private Window window;
    private MeshBatch meshBatch;
    private Game game;

    public Main(int width, int height, boolean fullscreen) {
        boolean vsync = false;
        this.window = new Window("Birdie 27 Game", width, height);
        this.window.init(1, fullscreen, vsync);
        this.window.setVSync(vsync);
        this.meshBatch = new MeshBatch(width, height);
        this.meshBatch.init();
        this.game = new Game();
        while (!this.window.shouldClose()) {
            long t0 = System.currentTimeMillis();
            this.window.pollEvents();
            if (KeyHandler.pressed(256)) {
                this.window.setShouldClose(true);
            }
            if (KeyHandler.pressed(290)) {
                this.meshBatch.reloadShaders();
            }
            if (KeyHandler.pressed(291)) {
                this.game.reloadEntities();
            }
            if (KeyHandler.pressed(295)) {
                System.out.println(this.game.player.pos);
            }
            if (KeyHandler.pressed(293)) {
                this.game.spawnItem();
            }
            if (KeyHandler.pressed(294)) {
                this.game.player.kr += 5000;
            }
            this.game.tick();
            this.meshBatch.begin();
            this.meshBatch.addString("x", this.meshBatch.nextVector3f(Window.width / 2, Window.height / 2, 1.0f), this.meshBatch.nextVector3f(1.0f, 0.0f, 0.0f));
            this.game.render(this.meshBatch);
            this.meshBatch.end(this.game, this.window, this.game.player);
            this.window.swapBuffers();
            KeyHandler.update();
            MouseButtonHandler.update();
            CharHandler.update();
            ScrollHandler.update();
            long t = System.currentTimeMillis() - t0;
            if (t > 17L) continue;
            try {
                Thread.sleep(17L - t);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

