/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.bulletphysics.dynamics.DynamicsWorld;
import com.bulletphysics.linearmath.Transform;
import entities.Entity;
import entities.Jolt;
import game.Game;
import game.MathUtils;
import game.Vec3;
import input.KeyHandler;
import input.MouseButtonHandler;
import input.MouseHandler;
import javax.vecmath.Vector3f;
import physics.Physics;
import renderer.ResourceHandler;
import renderer.glengine.Matrix4f;
import renderer.glengine.MeshBatch;

public class Player {
    public Vec3 pos = new Vec3(60.0, 0.0, 80.0);
    public double headingRad = 0.0;
    public double headingUpDownRad = 0.0;
    private double speed = 0.08333333333333333;
    private double mousePrevX;
    private double mousePrevY;
    public Entity entity;
    public Entity itemLeft;
    public Entity itemRight;
    private double hp = 100.0;
    public int lastDamageTick = -99999;
    public int joltTimer = -1;
    public int prevJoltTimer = -1;
    public int kr = 200;
    private int score = 0;
    public int lastScoreTick = 0;
    public boolean alive = true;
    long lastCollideTick = -999L;
    Game game;

    public Player(Game game) {
        this.game = game;
        this.mousePrevX = MouseHandler.x;
        this.mousePrevY = MouseHandler.x;
        this.entity = new Entity(game.physics, new Vector3f(52.0f, 0.5f, 75.0f), new Vector3f(0.0f, 0.0f, 0.0f), ResourceHandler.cube, null, true, ResourceHandler.ak, 100.0, 0.5f){

            @Override
            public void render(MeshBatch meshBatch) {
            }

            @Override
            public boolean isPlayer() {
                return false;
            }
        };
        game.entities.add(this.entity);
        this.moveToSpawn();
    }

    public void resetHP() {
        this.hp = 100.0;
    }

    public void resetScore() {
        this.score = 0;
    }

    public void addScore(int s) {
        this.score += s;
        this.lastScoreTick = 30;
    }

    public void moveToSpawn() {
        Transform trans = new Transform();
        this.entity.getBody().getWorldTransform(trans);
        javax.vecmath.Matrix4f mat = new javax.vecmath.Matrix4f();
        trans.getMatrix(mat);
        mat.setTranslation(new Vector3f(56.0f, 1.6f, 87.0f));
        trans.set(mat);
        this.entity.getBody().setWorldTransform(trans);
        this.entity.getBody().activate();
    }

    public void tick(Game game, Physics physics) {
        Vector3f linVel;
        --this.lastScoreTick;
        this.lastScoreTick = Math.max(0, this.lastScoreTick);
        if (this.hp <= 0.0) {
            this.alive = false;
        }
        this.prevJoltTimer = this.joltTimer;
        this.joltTimer = Math.max(0, this.joltTimer - 1);
        DynamicsWorld dw = physics.getDynamicsWorld();
        if (KeyHandler.pressed(32)) {
            linVel = new Vector3f(0.0f, 0.0f, 0.0f);
            this.entity.getBody().getLinearVelocity(linVel);
            if (Game.DEBUG || (double)Math.abs(linVel.y) < 0.5) {
                this.entity.getBody().applyCentralForce(new Vector3f(0.0f, 30000.0f, 0.0f));
            }
        }
        linVel = new Vector3f(0.0f, 0.0f, 0.0f);
        this.entity.getBody().getLinearVelocity(linVel);
        this.entity.getBody().setLinearVelocity(new Vector3f(0.0f, linVel.y, 0.0f));
        double x = 0.0;
        double z = 0.0;
        if (KeyHandler.down(68)) {
            x += 1.0;
        }
        if (KeyHandler.down(65)) {
            x -= 1.0;
        }
        if (KeyHandler.down(83)) {
            z -= 1.0;
        }
        if (KeyHandler.down(87)) {
            z += 1.0;
        }
        double moveSpeed = this.speed;
        if (KeyHandler.down(341)) {
            moveSpeed *= 30.0;
        }
        if (x != 0.0 || z != 0.0) {
            double a = Math.atan2(z, x);
            float force = this.joltTimer > 0 && this.joltTimer < Jolt.DURATION - 60 ? 40000 : 20000;
            if (KeyHandler.down(341) && Game.DEBUG) {
                force *= 10.0f;
            }
            this.entity.getBody().applyCentralForce(new Vector3f((float)((double)force * Math.cos(this.headingRad + a)), 0.0f, (float)((double)(-force) * Math.sin(this.headingRad + a))));
            this.entity.getBody().activate();
        }
        if (KeyHandler.down(263)) {
            this.headingRad -= 0.03;
        }
        if (KeyHandler.down(262)) {
            this.headingRad += 0.03;
        }
        if (KeyHandler.down(265)) {
            this.headingUpDownRad -= 0.03;
        }
        if (KeyHandler.down(264)) {
            this.headingUpDownRad += 0.03;
        }
        Vector3f center = this.entity.getCenter();
        this.pos.x = center.x;
        this.pos.y = (double)center.y + 1.25;
        this.pos.z = center.z;
        double mdx = MouseHandler.x - this.mousePrevX;
        double mdy = MouseHandler.y - this.mousePrevY;
        this.mousePrevX = MouseHandler.x;
        this.mousePrevY = MouseHandler.y;
        this.headingRad -= mdx * 0.003;
        this.headingUpDownRad -= mdy * 0.003;
        this.headingUpDownRad = MathUtils.clamp(this.headingUpDownRad, Math.toRadians(-90.0), Math.toRadians(90.0));
        Vec3 l = new Vec3(0.0, 0.0, 0.0);
        l.x = Math.cos(-this.headingUpDownRad) * Math.sin(this.headingRad);
        l.y = Math.sin(-this.headingUpDownRad);
        l.z = Math.cos(-this.headingUpDownRad) * Math.cos(this.headingRad);
        l.normalize();
        float near = 0.0f;
        Vector3f from = new Vector3f((float)(this.pos.x - (double)near * l.x), (float)(this.pos.y - (double)near * l.y), (float)(this.pos.z - (double)near * l.z));
        float far = 150.0f;
        Vector3f towards = new Vector3f((float)(this.pos.x - (double)far * l.x), (float)(this.pos.y - (double)far * l.y), (float)(this.pos.z - (double)far * l.z));
        Physics.CustomClosestRayResultCallback c = game.physics.rayTest(from, towards);
        float pickupRange = 4.0f;
        if (!KeyHandler.down(340) && !MouseButtonHandler.pressed(1) && MouseButtonHandler.down(1) && this.itemRight != null) {
            this.itemRight.useDown(game, c);
        } else if (MouseButtonHandler.pressed(1)) {
            if (KeyHandler.down(340)) {
                if (this.itemRight == null) {
                    if (c.e != null && c.e.canBePickedUp() && c.hitFraction < (double)(pickupRange / (far - near))) {
                        this.itemRight = c.e;
                        this.itemRight.pickUp(game);
                    }
                } else {
                    this.itemRight.throwItem(this);
                    this.itemRight = null;
                }
            } else if (this.itemRight != null && this.itemRight.use(game, c)) {
                game.entities.remove(this.itemRight);
                this.itemRight = null;
            }
        }
        if (!KeyHandler.down(340) && !MouseButtonHandler.pressed(0) && MouseButtonHandler.down(0) && this.itemLeft != null) {
            this.itemLeft.useDown(game, c);
        } else if (MouseButtonHandler.pressed(0)) {
            if (KeyHandler.down(340)) {
                if (this.itemLeft == null) {
                    if (c.e != null && c.e.canBePickedUp() && c.hitFraction < (double)(pickupRange / (far - near))) {
                        this.itemLeft = c.e;
                        this.itemLeft.pickUp(game);
                    }
                } else {
                    this.itemLeft.throwItem(this);
                    this.itemLeft = null;
                }
            } else if (this.itemLeft != null && this.itemLeft.use(game, c)) {
                game.entities.remove(this.itemLeft);
                this.itemLeft = null;
            }
        }
        if (this.itemRight != null) {
            this.itemRight.moveToHand(this, -0.5f);
        }
        if (this.itemLeft != null) {
            this.itemLeft.moveToHand(this, 0.5f);
        }
        if (this.joltTimer > 0 && this.joltTimer < Jolt.DURATION - 60 && game.tick % 45L == 0L) {
            game.sound.play(game.sound.HEARTBEAT);
        }
    }

    public void render(MeshBatch mb, Game game) {
        Matrix4f.Pipeline p = new Matrix4f.Pipeline();
        double x = 0.15;
        double y = -0.2;
        double z = -0.4;
        float scale = 0.4f;
        p.add(Matrix4f.scale(scale, scale, scale));
        MouseButtonHandler.down(0);
        if (this.itemLeft != null) {
            this.itemLeft.renderInHand(mb, true);
        }
        if (this.itemRight != null) {
            this.itemRight.renderInHand(mb, false);
        }
        mb.addString("HEALTH " + (int)this.hp, mb.nextVector3f(20.0f, 20.0f, 0.0f), mb.nextVector3f(1.0f, 1.0f, 0.3f), ResourceHandler.ui);
    }

    public void takeDamage(double damage) {
        this.hp -= damage;
        this.lastDamageTick = (int)this.game.tick;
    }

    public void giveHealth(double hp) {
        this.hp += hp;
        this.hp = Math.min(100.0, this.hp);
    }

    public int getScore() {
        return this.score;
    }
}

