/*
 * Decompiled with CFR 0.152.
 */
package game;

public class Vec2 {
    public double x;
    public double y;

    public Vec2() {
    }

    public Vec2(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double lengthDifference(Vec2 b) {
        return Math.sqrt((this.x - b.x) * (this.x - b.x) + (this.y - b.y) * (this.y - b.y));
    }

    public Vec2 subtract(Vec2 pos) {
        return new Vec2(this.x - pos.x, this.y - pos.y);
    }

    public Vec2 add(Vec2 v) {
        return new Vec2(this.x + v.x, this.y + v.y);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public double dot(Vec2 b) {
        return this.x * b.x + this.y * b.y;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vec2 other = (Vec2)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }

    public Vec2 normalize() {
        return new Vec2(this.x / this.length(), this.y / this.length());
    }

    public Vec2 scale(double s) {
        return new Vec2(this.x * s, this.y * s);
    }
}

