/*
 * Decompiled with CFR 0.152.
 */
package game;

import javax.vecmath.Vector3f;

public class Vec3 {
    public double x;
    public double y;
    public double z;

    public Vec3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3() {
    }

    public Vec3(Vector3f v) {
        this(v.x, v.y, v.z);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double lengthDifference(Vec3 b) {
        return Math.sqrt((this.x - b.x) * (this.x - b.x) + (this.y - b.y) * (this.y - b.y) + (this.z - b.z) * (this.z - b.z));
    }

    public double lengthDifferenceSQ(Vec3 b) {
        return (this.x - b.x) * (this.x - b.x) + (this.y - b.y) * (this.y - b.y) + (this.z - b.z) * (this.z - b.z);
    }

    public Vec3 subtract(Vec3 pos) {
        return new Vec3(this.x - pos.x, this.y - pos.y, this.z - pos.z);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public void normalize() {
        double l = this.length();
        this.x /= l;
        this.y /= l;
        this.z /= l;
    }

    public void add(Vec3 v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public Vec3 clone() {
        return new Vec3(this.x, this.y, this.z);
    }

    public void multiply(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
    }

    public Vec3 cross(Vec3 b) {
        return new Vec3(this.y * b.z - this.z * b.y, this.z * b.x - this.x * b.z, this.x * b.y - this.y * b.x);
    }

    public double dot(Vec3 b) {
        return this.x * b.x + this.y * b.y + this.z * b.z;
    }

    public static Vec3 interpolateTowards(Vec3 a, Vec3 b, float k) {
        Vec3 c = new Vec3();
        c.x = a.x + (b.x - a.x) * (double)k;
        c.y = a.y + (b.y - a.y) * (double)k;
        c.z = a.z + (b.z - a.z) * (double)k;
        return c;
    }

    public Vector3f toVector3f() {
        return new Vector3f((float)this.x, (float)this.y, (float)this.z);
    }
}

