/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.lwjgl.BufferUtils;

public final class IOUtil {
    private IOUtil() {
    }

    private static ByteBuffer resizeBuffer(ByteBuffer buffer, int newCapacity) {
        ByteBuffer newBuffer = BufferUtils.createByteBuffer((int)newCapacity);
        buffer.flip();
        newBuffer.put(buffer);
        return newBuffer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ByteBuffer ioResourceToByteBuffer(String resource, int bufferSize) throws IOException {
        ByteBuffer buffer;
        block22: {
            Path path = Paths.get(resource, new String[0]);
            if (Files.isReadable(path)) {
                Throwable throwable = null;
                Object var5_7 = null;
                try (SeekableByteChannel fc = Files.newByteChannel(path, new OpenOption[0]);){
                    buffer = BufferUtils.createByteBuffer((int)((int)fc.size() + 1));
                    while (fc.read(buffer) != -1) {
                    }
                    break block22;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            Throwable throwable = null;
            Object var5_9 = null;
            try {
                InputStream source = IOUtil.class.getClassLoader().getResourceAsStream(resource);
                try {
                    try (ReadableByteChannel rbc = Channels.newChannel(source);){
                        int bytes;
                        buffer = BufferUtils.createByteBuffer((int)bufferSize);
                        while ((bytes = rbc.read(buffer)) != -1) {
                            if (buffer.remaining() != 0) continue;
                            buffer = IOUtil.resizeBuffer(buffer, buffer.capacity() * 2);
                        }
                    }
                    if (source == null) break block22;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (source == null) throw throwable;
                    source.close();
                    throw throwable;
                }
                source.close();
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        buffer.flip();
        return buffer;
    }
}

