/*
 * Decompiled with CFR 0.152.
 */
package renderer.glengine;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.lwjgl.opengl.GL20;
import renderer.glengine.OBJLoader;
import renderer.glengine.Window;

public class GLSLProgram {
    public static final int VERTEX_ATTRIB = 0;
    public static final int UV_COORDS_ATTRIB = 1;
    public static final int NORMAL_COORDS_ATTRIB = 2;
    public static final int TANGENT_COORDS_ATTRIB = 3;
    public static final int BITANGENT_COORDS_ATTRIB = 4;
    public static final int UV_COORDS_ATTRIB_2D = 1;
    public final int programID;

    public static GLSLProgram getProgram(String vertex, String fragment, String geometry) {
        return new GLSLProgram(vertex, fragment, geometry);
    }

    public static GLSLProgram getProgram(String vertex, String fragment) {
        return new GLSLProgram(vertex, fragment, null);
    }

    public GLSLProgram(String vertex, String fragment) {
        this.programID = GLSLProgram.load(vertex, fragment, null);
    }

    public GLSLProgram(String vertex, String fragment, String geometry) {
        this.programID = GLSLProgram.load(vertex, fragment, geometry);
    }

    public void enable() {
        GL20.glUseProgram((int)this.programID);
    }

    public void disable() {
        GL20.glUseProgram((int)0);
    }

    public void free() {
        GL20.glDeleteProgram((int)this.programID);
    }

    public static int load(String vertPath, String fragPath, String geometryPath) {
        String width = String.valueOf(Window.width) + ".0";
        String height = String.valueOf(Window.height) + ".0";
        String vert = GLSLProgram.loadAsString(vertPath).replace("RESOLUTION_WIDTH", width).replace("RESOLUTION_HEIGHT", height);
        String frag = GLSLProgram.loadAsString(fragPath).replace("RESOLUTION_WIDTH", width).replace("RESOLUTION_HEIGHT", height);
        String geometry = geometryPath != null ? GLSLProgram.loadAsString(geometryPath).replace("RESOLUTION_WIDTH", width).replace("RESOLUTION_HEIGHT", height) : null;
        String shared = GLSLProgram.loadAsString("/shaders/shared.oj");
        vert = vert.replace("SHARED_OJ", shared);
        frag = frag.replace("SHARED_OJ", shared);
        geometry = geometryPath != null ? geometry.replace("SHARED_OJ", shared) : null;
        int program = GL20.glCreateProgram();
        int vertID = GL20.glCreateShader((int)35633);
        int fragID = GL20.glCreateShader((int)35632);
        int geometryID = 0;
        GL20.glShaderSource((int)vertID, (CharSequence)vert);
        GL20.glShaderSource((int)fragID, (CharSequence)frag);
        GL20.glCompileShader((int)vertID);
        if (GL20.glGetShaderi((int)vertID, (int)35713) == 0) {
            System.err.println("Failed to compile vertexd shader!");
            System.err.println(GL20.glGetShaderInfoLog((int)vertID));
            System.exit(0);
        }
        GL20.glCompileShader((int)fragID);
        if (GL20.glGetShaderi((int)fragID, (int)35713) == 0) {
            System.err.println("Failed to compile fragment shader!");
            System.err.println(GL20.glGetShaderInfoLog((int)fragID));
            System.exit(0);
        }
        if (geometryPath != null) {
            geometryID = GL20.glCreateShader((int)36313);
            GL20.glShaderSource((int)geometryID, (CharSequence)geometry);
            GL20.glCompileShader((int)geometryID);
            if (GL20.glGetShaderi((int)geometryID, (int)35713) == 0) {
                System.err.println("Failed to compile fragment shader!");
                System.err.println(GL20.glGetShaderInfoLog((int)geometryID));
                System.exit(0);
            }
        }
        GL20.glAttachShader((int)program, (int)vertID);
        if (geometryPath != null) {
            GL20.glAttachShader((int)program, (int)geometryID);
        }
        GL20.glAttachShader((int)program, (int)fragID);
        GL20.glLinkProgram((int)program);
        GL20.glValidateProgram((int)program);
        GL20.glDetachShader((int)program, (int)vertID);
        GL20.glDetachShader((int)program, (int)fragID);
        GL20.glDeleteShader((int)vertID);
        GL20.glDeleteShader((int)fragID);
        if (geometryPath != null) {
            GL20.glDetachShader((int)program, (int)geometryID);
            GL20.glDeleteShader((int)geometryID);
        }
        return program;
    }

    public static String loadAsString(String location) {
        StringBuilder result = new StringBuilder();
        try {
            InputStream in = OBJLoader.class.getResourceAsStream(location);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String buffer = "";
            while ((buffer = reader.readLine()) != null) {
                result.append(buffer);
                result.append("\n");
            }
            reader.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return result.toString();
    }
}

