/*
 * Decompiled with CFR 0.152.
 */
package renderer.glengine;

import java.nio.FloatBuffer;
import renderer.Pool;
import renderer.glengine.Vector3f;
import renderer.glengine.Vector4f;

public class Matrix4f {
    public float m00;
    public float m01;
    public float m02;
    public float m03;
    public float m10;
    public float m11;
    public float m12;
    public float m13;
    public float m20;
    public float m21;
    public float m22;
    public float m23;
    public float m30;
    public float m31;
    public float m32;
    public float m33;
    static PoolM POOL = new PoolM();

    public Matrix4f() {
        this.setIdentity();
    }

    public final void setIdentity() {
        this.m00 = 1.0f;
        this.m11 = 1.0f;
        this.m22 = 1.0f;
        this.m33 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
    }

    public Matrix4f add(Matrix4f other) {
        Matrix4f result = (Matrix4f)POOL.next();
        result.m00 = this.m00 + other.m00;
        result.m10 = this.m10 + other.m10;
        result.m20 = this.m20 + other.m20;
        result.m30 = this.m30 + other.m30;
        result.m01 = this.m01 + other.m01;
        result.m11 = this.m11 + other.m11;
        result.m21 = this.m21 + other.m21;
        result.m31 = this.m31 + other.m31;
        result.m02 = this.m02 + other.m02;
        result.m12 = this.m12 + other.m12;
        result.m22 = this.m22 + other.m22;
        result.m32 = this.m32 + other.m32;
        result.m03 = this.m03 + other.m03;
        result.m13 = this.m13 + other.m13;
        result.m23 = this.m23 + other.m23;
        result.m33 = this.m33 + other.m33;
        return result;
    }

    public static Matrix4f lookAt(Vector3f position, Vector3f target, Vector3f upVector) {
        Vector3f forward = target.subtract(position);
        forward.normalize();
        Vector3f right = forward.cross(upVector);
        right.normalize();
        Vector3f up = right.cross(forward);
        up.normalize();
        Matrix4f result = (Matrix4f)POOL.next();
        result.m00 = right.x;
        result.m10 = right.y;
        result.m20 = right.z;
        result.m01 = up.x;
        result.m11 = up.y;
        result.m21 = up.z;
        result.m02 = -forward.x;
        result.m12 = -forward.y;
        result.m22 = -forward.z;
        result.m33 = 1.0f;
        result.m03 = -right.dot(position);
        result.m13 = -up.dot(position);
        result.m23 = forward.dot(position);
        return result;
    }

    public Matrix4f negate() {
        return this.multiply(-1.0f);
    }

    public Matrix4f subtract(Matrix4f other) {
        return this.add(other.negate());
    }

    public Matrix4f multiply(float scalar) {
        Matrix4f result = (Matrix4f)POOL.next();
        result.m00 = this.m00 * scalar;
        result.m10 = this.m10 * scalar;
        result.m20 = this.m20 * scalar;
        result.m30 = this.m30 * scalar;
        result.m01 = this.m01 * scalar;
        result.m11 = this.m11 * scalar;
        result.m21 = this.m21 * scalar;
        result.m31 = this.m31 * scalar;
        result.m02 = this.m02 * scalar;
        result.m12 = this.m12 * scalar;
        result.m22 = this.m22 * scalar;
        result.m32 = this.m32 * scalar;
        result.m03 = this.m03 * scalar;
        result.m13 = this.m13 * scalar;
        result.m23 = this.m23 * scalar;
        result.m33 = this.m33 * scalar;
        return result;
    }

    public Vector4f multiply(Vector4f vector) {
        float x = this.m00 * vector.x + this.m01 * vector.y + this.m02 * vector.z + this.m03 * vector.w;
        float y = this.m10 * vector.x + this.m11 * vector.y + this.m12 * vector.z + this.m13 * vector.w;
        float z = this.m20 * vector.x + this.m21 * vector.y + this.m22 * vector.z + this.m23 * vector.w;
        float w = this.m30 * vector.x + this.m31 * vector.y + this.m32 * vector.z + this.m33 * vector.w;
        return new Vector4f(x, y, z, w);
    }

    public Matrix4f multiply(Matrix4f other) {
        Matrix4f result = (Matrix4f)POOL.next();
        result.m00 = this.m00 * other.m00 + this.m01 * other.m10 + this.m02 * other.m20 + this.m03 * other.m30;
        result.m10 = this.m10 * other.m00 + this.m11 * other.m10 + this.m12 * other.m20 + this.m13 * other.m30;
        result.m20 = this.m20 * other.m00 + this.m21 * other.m10 + this.m22 * other.m20 + this.m23 * other.m30;
        result.m30 = this.m30 * other.m00 + this.m31 * other.m10 + this.m32 * other.m20 + this.m33 * other.m30;
        result.m01 = this.m00 * other.m01 + this.m01 * other.m11 + this.m02 * other.m21 + this.m03 * other.m31;
        result.m11 = this.m10 * other.m01 + this.m11 * other.m11 + this.m12 * other.m21 + this.m13 * other.m31;
        result.m21 = this.m20 * other.m01 + this.m21 * other.m11 + this.m22 * other.m21 + this.m23 * other.m31;
        result.m31 = this.m30 * other.m01 + this.m31 * other.m11 + this.m32 * other.m21 + this.m33 * other.m31;
        result.m02 = this.m00 * other.m02 + this.m01 * other.m12 + this.m02 * other.m22 + this.m03 * other.m32;
        result.m12 = this.m10 * other.m02 + this.m11 * other.m12 + this.m12 * other.m22 + this.m13 * other.m32;
        result.m22 = this.m20 * other.m02 + this.m21 * other.m12 + this.m22 * other.m22 + this.m23 * other.m32;
        result.m32 = this.m30 * other.m02 + this.m31 * other.m12 + this.m32 * other.m22 + this.m33 * other.m32;
        result.m03 = this.m00 * other.m03 + this.m01 * other.m13 + this.m02 * other.m23 + this.m03 * other.m33;
        result.m13 = this.m10 * other.m03 + this.m11 * other.m13 + this.m12 * other.m23 + this.m13 * other.m33;
        result.m23 = this.m20 * other.m03 + this.m21 * other.m13 + this.m22 * other.m23 + this.m23 * other.m33;
        result.m33 = this.m30 * other.m03 + this.m31 * other.m13 + this.m32 * other.m23 + this.m33 * other.m33;
        return result;
    }

    public Matrix4f transpose() {
        Matrix4f result = (Matrix4f)POOL.next();
        result.m00 = this.m00;
        result.m10 = this.m01;
        result.m20 = this.m02;
        result.m30 = this.m03;
        result.m01 = this.m10;
        result.m11 = this.m11;
        result.m21 = this.m12;
        result.m31 = this.m13;
        result.m02 = this.m20;
        result.m12 = this.m21;
        result.m22 = this.m22;
        result.m32 = this.m23;
        result.m03 = this.m30;
        result.m13 = this.m31;
        result.m23 = this.m32;
        result.m33 = this.m33;
        return result;
    }

    public void setBuffer(FloatBuffer buffer) {
        buffer.put(this.m00).put(this.m10).put(this.m20).put(this.m30);
        buffer.put(this.m01).put(this.m11).put(this.m21).put(this.m31);
        buffer.put(this.m02).put(this.m12).put(this.m22).put(this.m32);
        buffer.put(this.m03).put(this.m13).put(this.m23).put(this.m33);
        buffer.flip();
    }

    public static Matrix4f orthographic(float left, float right, float bottom, float top, float near, float far) {
        Matrix4f ortho = (Matrix4f)POOL.next();
        float tx = -(right + left) / (right - left);
        float ty = -(top + bottom) / (top - bottom);
        float tz = -(far + near) / (far - near);
        ortho.m00 = 2.0f / (right - left);
        ortho.m11 = 2.0f / (top - bottom);
        ortho.m22 = -2.0f / (far - near);
        ortho.m03 = tx;
        ortho.m13 = ty;
        ortho.m23 = tz;
        return ortho;
    }

    public static Matrix4f frustum(float left, float right, float bottom, float top, float near, float far) {
        Matrix4f frustum = (Matrix4f)POOL.next();
        float a = (right + left) / (right - left);
        float b = (top + bottom) / (top - bottom);
        float c = -(far + near) / (far - near);
        float d = -(2.0f * far * near) / (far - near);
        frustum.m00 = 2.0f * near / (right - left);
        frustum.m11 = 2.0f * near / (top - bottom);
        frustum.m02 = a;
        frustum.m12 = b;
        frustum.m22 = c;
        frustum.m32 = -1.0f;
        frustum.m23 = d;
        frustum.m33 = 0.0f;
        return frustum;
    }

    public static Matrix4f perspective(float fovy, float aspect, float near, float far) {
        Matrix4f perspective = (Matrix4f)POOL.next();
        float f = (float)(1.0 / Math.tan(Math.toRadians(fovy) / 2.0));
        perspective.m00 = f / aspect;
        perspective.m11 = f;
        perspective.m22 = (far + near) / (near - far);
        perspective.m32 = -1.0f;
        perspective.m23 = 2.0f * far * near / (near - far);
        perspective.m33 = 0.0f;
        return perspective;
    }

    public static Matrix4f translate(float x, float y, float z) {
        Matrix4f translation = (Matrix4f)POOL.next();
        translation.m03 = x;
        translation.m13 = y;
        translation.m23 = z;
        return translation;
    }

    public static Matrix4f rotate(float angle, float x, float y, float z) {
        Matrix4f rotation = (Matrix4f)POOL.next();
        float c = (float)Math.cos(Math.toRadians(angle));
        float s = (float)Math.sin(Math.toRadians(angle));
        Vector3f vec = Vector3f.POOL.next(x, y, z);
        if (vec.length() != 1.0f) {
            vec = vec.normalize();
            x = vec.x;
            y = vec.y;
            z = vec.z;
        }
        rotation.m00 = x * x * (1.0f - c) + c;
        rotation.m10 = y * x * (1.0f - c) + z * s;
        rotation.m20 = x * z * (1.0f - c) - y * s;
        rotation.m01 = x * y * (1.0f - c) - z * s;
        rotation.m11 = y * y * (1.0f - c) + c;
        rotation.m21 = y * z * (1.0f - c) + x * s;
        rotation.m02 = x * z * (1.0f - c) + y * s;
        rotation.m12 = y * z * (1.0f - c) - x * s;
        rotation.m22 = z * z * (1.0f - c) + c;
        return rotation;
    }

    public static Matrix4f bias() {
        Matrix4f matrix = (Matrix4f)POOL.next();
        matrix.m00 = 0.5f;
        matrix.m11 = 0.5f;
        matrix.m22 = 0.5f;
        matrix.m03 = 0.5f;
        matrix.m13 = 0.5f;
        matrix.m23 = 0.5f;
        return matrix;
    }

    public static Matrix4f scale(float x, float y, float z) {
        Matrix4f scaling = (Matrix4f)POOL.next();
        scaling.m00 = x;
        scaling.m11 = y;
        scaling.m22 = z;
        return scaling;
    }

    private void Lmultiply(float m00, float m10, float m20, float m30, float m01, float m11, float m21, float m31, float m02, float m12, float m22, float m32, float m03, float m13, float m23, float m33) {
        float rm00 = m00 * this.m00 + m01 * this.m10 + m02 * this.m20 + m03 * this.m30;
        float rm10 = m10 * this.m00 + m11 * this.m10 + m12 * this.m20 + m13 * this.m30;
        float rm20 = m20 * this.m00 + m21 * this.m10 + m22 * this.m20 + m23 * this.m30;
        float rm30 = m30 * this.m00 + m31 * this.m10 + m32 * this.m20 + m33 * this.m30;
        float rm01 = m00 * this.m01 + m01 * this.m11 + m02 * this.m21 + m03 * this.m31;
        float rm11 = m10 * this.m01 + m11 * this.m11 + m12 * this.m21 + m13 * this.m31;
        float rm21 = m20 * this.m01 + m21 * this.m11 + m22 * this.m21 + m23 * this.m31;
        float rm31 = m30 * this.m01 + m31 * this.m11 + m32 * this.m21 + m33 * this.m31;
        float rm02 = m00 * this.m02 + m01 * this.m12 + m02 * this.m22 + m03 * this.m32;
        float rm12 = m10 * this.m02 + m11 * this.m12 + m12 * this.m22 + m13 * this.m32;
        float rm22 = m20 * this.m02 + m21 * this.m12 + m22 * this.m22 + m23 * this.m32;
        float rm32 = m30 * this.m02 + m31 * this.m12 + m32 * this.m22 + m33 * this.m32;
        float rm03 = m00 * this.m03 + m01 * this.m13 + m02 * this.m23 + m03 * this.m33;
        float rm13 = m10 * this.m03 + m11 * this.m13 + m12 * this.m23 + m13 * this.m33;
        float rm23 = m20 * this.m03 + m21 * this.m13 + m22 * this.m23 + m23 * this.m33;
        float rm33 = m30 * this.m03 + m31 * this.m13 + m32 * this.m23 + m33 * this.m33;
        this.m00 = rm00;
        this.m10 = rm10;
        this.m20 = rm20;
        this.m30 = rm30;
        this.m01 = rm01;
        this.m11 = rm11;
        this.m21 = rm21;
        this.m31 = rm31;
        this.m02 = rm02;
        this.m12 = rm12;
        this.m22 = rm22;
        this.m32 = rm32;
        this.m03 = rm03;
        this.m13 = rm13;
        this.m23 = rm23;
        this.m33 = rm33;
    }

    private void Rmultiply(float m00, float m10, float m20, float m30, float m01, float m11, float m21, float m31, float m02, float m12, float m22, float m32, float m03, float m13, float m23, float m33) {
        float rm00 = this.m00 * m00 + this.m01 * m10 + this.m02 * m20 + this.m03 * m30;
        float rm10 = this.m10 * m00 + this.m11 * m10 + this.m12 * m20 + this.m13 * m30;
        float rm20 = this.m20 * m00 + this.m21 * m10 + this.m22 * m20 + this.m23 * m30;
        float rm30 = this.m30 * m00 + this.m31 * m10 + this.m32 * m20 + this.m33 * m30;
        float rm01 = this.m00 * m01 + this.m01 * m11 + this.m02 * m21 + this.m03 * m31;
        float rm11 = this.m10 * m01 + this.m11 * m11 + this.m12 * m21 + this.m13 * m31;
        float rm21 = this.m20 * m01 + this.m21 * m11 + this.m22 * m21 + this.m23 * m31;
        float rm31 = this.m30 * m01 + this.m31 * m11 + this.m32 * m21 + this.m33 * m31;
        float rm02 = this.m00 * m02 + this.m01 * m12 + this.m02 * m22 + this.m03 * m32;
        float rm12 = this.m10 * m02 + this.m11 * m12 + this.m12 * m22 + this.m13 * m32;
        float rm22 = this.m20 * m02 + this.m21 * m12 + this.m22 * m22 + this.m23 * m32;
        float rm32 = this.m30 * m02 + this.m31 * m12 + this.m32 * m22 + this.m33 * m32;
        float rm03 = this.m00 * m03 + this.m01 * m13 + this.m02 * m23 + this.m03 * m33;
        float rm13 = this.m10 * m03 + this.m11 * m13 + this.m12 * m23 + this.m13 * m33;
        float rm23 = this.m20 * m03 + this.m21 * m13 + this.m22 * m23 + this.m23 * m33;
        float rm33 = this.m30 * m03 + this.m31 * m13 + this.m32 * m23 + this.m33 * m33;
        this.m00 = rm00;
        this.m10 = rm10;
        this.m20 = rm20;
        this.m30 = rm30;
        this.m01 = rm01;
        this.m11 = rm11;
        this.m21 = rm21;
        this.m31 = rm31;
        this.m02 = rm02;
        this.m12 = rm12;
        this.m22 = rm22;
        this.m32 = rm32;
        this.m03 = rm03;
        this.m13 = rm13;
        this.m23 = rm23;
        this.m33 = rm33;
    }

    public void set(Matrix4f m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m03 = m.m03;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m13 = m.m13;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
        this.m23 = m.m23;
        this.m30 = m.m30;
        this.m31 = m.m31;
        this.m32 = m.m32;
        this.m33 = m.m33;
    }

    public static class Pipeline {
        private Matrix4f matrix;

        public Pipeline() {
            this(true);
        }

        public Pipeline(boolean pool) {
            this.matrix = pool ? (Matrix4f)POOL.next() : new Matrix4f();
        }

        private Pipeline(Matrix4f m) {
            this.matrix = m;
        }

        public Pipeline copy() {
            return new Pipeline(POOL.next(this.matrix));
        }

        public void addScale(float x, float y, float z) {
            float m00 = x;
            float m11 = y;
            float m22 = z;
            float m33 = 1.0f;
            float m01 = 0.0f;
            float m02 = 0.0f;
            float m10 = 0.0f;
            float m12 = 0.0f;
            float m20 = 0.0f;
            float m21 = 0.0f;
            float m30 = 0.0f;
            float m31 = 0.0f;
            float m32 = 0.0f;
            float m03 = 0.0f;
            float m13 = 0.0f;
            float m23 = 0.0f;
            this.matrix.Lmultiply(m00, m10, m20, m30, m01, m11, m21, m31, m02, m12, m22, m32, m03, m13, m23, m33);
        }

        public void addScaleRight(float x, float y, float z) {
            float m00 = x;
            float m11 = y;
            float m22 = z;
            float m33 = 1.0f;
            float m01 = 0.0f;
            float m02 = 0.0f;
            float m10 = 0.0f;
            float m12 = 0.0f;
            float m20 = 0.0f;
            float m21 = 0.0f;
            float m30 = 0.0f;
            float m31 = 0.0f;
            float m32 = 0.0f;
            float m03 = 0.0f;
            float m13 = 0.0f;
            float m23 = 0.0f;
            this.matrix.Rmultiply(m00, m10, m20, m30, m01, m11, m21, m31, m02, m12, m22, m32, m03, m13, m23, m33);
        }

        public void addTranslate(float x, float y, float z) {
            float m00 = 1.0f;
            float m11 = 1.0f;
            float m22 = 1.0f;
            float m33 = 1.0f;
            float m01 = 0.0f;
            float m02 = 0.0f;
            float m10 = 0.0f;
            float m12 = 0.0f;
            float m20 = 0.0f;
            float m21 = 0.0f;
            float m30 = 0.0f;
            float m31 = 0.0f;
            float m32 = 0.0f;
            float m03 = x;
            float m13 = y;
            float m23 = z;
            this.matrix.Lmultiply(m00, m10, m20, m30, m01, m11, m21, m31, m02, m12, m22, m32, m03, m13, m23, m33);
        }

        public void addTranslateRight(float x, float y, float z) {
            float m00 = 1.0f;
            float m11 = 1.0f;
            float m22 = 1.0f;
            float m33 = 1.0f;
            float m01 = 0.0f;
            float m02 = 0.0f;
            float m10 = 0.0f;
            float m12 = 0.0f;
            float m20 = 0.0f;
            float m21 = 0.0f;
            float m30 = 0.0f;
            float m31 = 0.0f;
            float m32 = 0.0f;
            float m03 = x;
            float m13 = y;
            float m23 = z;
            this.matrix.Rmultiply(m00, m10, m20, m30, m01, m11, m21, m31, m02, m12, m22, m32, m03, m13, m23, m33);
        }

        public void addRotate(float angle, float x, float y, float z) {
            float c = (float)Math.cos(Math.toRadians(angle));
            float s = (float)Math.sin(Math.toRadians(angle));
            float length = x * x + y * y + z * z;
            if (length != 1.0f) {
                x /= length;
                y /= length;
                z /= length;
            }
            float m33 = 1.0f;
            float m03 = 0.0f;
            float m13 = 0.0f;
            float m23 = 0.0f;
            float m30 = 0.0f;
            float m31 = 0.0f;
            float m32 = 0.0f;
            float m00 = x * x * (1.0f - c) + c;
            float m10 = y * x * (1.0f - c) + z * s;
            float m20 = x * z * (1.0f - c) - y * s;
            float m01 = x * y * (1.0f - c) - z * s;
            float m11 = y * y * (1.0f - c) + c;
            float m21 = y * z * (1.0f - c) + x * s;
            float m02 = x * z * (1.0f - c) + y * s;
            float m12 = y * z * (1.0f - c) - x * s;
            float m22 = z * z * (1.0f - c) + c;
            this.matrix.Lmultiply(m00, m10, m20, m30, m01, m11, m21, m31, m02, m12, m22, m32, m03, m13, m23, m33);
        }

        public void addRotateRight(float angle, float x, float y, float z) {
            float c = (float)Math.cos(Math.toRadians(angle));
            float s = (float)Math.sin(Math.toRadians(angle));
            float length = x * x + y * y + z * z;
            if (length != 1.0f) {
                x /= length;
                y /= length;
                z /= length;
            }
            float m33 = 1.0f;
            float m03 = 0.0f;
            float m13 = 0.0f;
            float m23 = 0.0f;
            float m30 = 0.0f;
            float m31 = 0.0f;
            float m32 = 0.0f;
            float m00 = x * x * (1.0f - c) + c;
            float m10 = y * x * (1.0f - c) + z * s;
            float m20 = x * z * (1.0f - c) - y * s;
            float m01 = x * y * (1.0f - c) - z * s;
            float m11 = y * y * (1.0f - c) + c;
            float m21 = y * z * (1.0f - c) + x * s;
            float m02 = x * z * (1.0f - c) + y * s;
            float m12 = y * z * (1.0f - c) - x * s;
            float m22 = z * z * (1.0f - c) + c;
            this.matrix.Rmultiply(m00, m10, m20, m30, m01, m11, m21, m31, m02, m12, m22, m32, m03, m13, m23, m33);
        }

        public void add(Matrix4f m) {
            this.matrix = m.multiply(this.matrix);
        }

        public Matrix4f getMatrix() {
            return this.matrix;
        }

        public void setIdentity() {
            this.matrix.setIdentity();
        }

        public void addScale(float f) {
            this.addScale(f, f, f);
        }
    }

    static class PoolM
    extends Pool<Matrix4f> {
        PoolM() {
        }

        @Override
        protected Matrix4f newElement() {
            return new Matrix4f();
        }

        @Override
        protected void resetElement(Matrix4f e) {
            e.setIdentity();
        }

        public Matrix4f next(Matrix4f m) {
            Matrix4f copy = (Matrix4f)super.next();
            copy.set(m);
            return copy;
        }
    }
}

