/*
 * Decompiled with CFR 0.152.
 */
package renderer.glengine;

import game.Game;
import game.Player;
import game.Vec3;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIFace;
import org.lwjgl.assimp.AIMesh;
import org.lwjgl.assimp.AIVector3D;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import renderer.DiffuseNormalSpecularTexture;
import renderer.ResourceHandler;
import renderer.glengine.Matrix4f;
import renderer.glengine.Mesh;
import renderer.glengine.Model;
import renderer.glengine.Sprite;
import renderer.glengine.Texture;
import renderer.glengine.Vector3f;
import renderer.glengine.Window;

public abstract class MeshBatchBase {
    protected Map<AIMesh, VAO> vaoMap = new HashMap<AIMesh, VAO>();
    protected ArrayList<Model> renderList = new ArrayList();
    protected ArrayList<Model> transparentList = new ArrayList();
    protected ArrayList<Sprite> spriteList = new ArrayList();
    protected VAO quadVAO = this.allocateSpriteVAO();
    protected ArrayList<Model> instancedList = new ArrayList();
    public int instancedVAO = -1;

    public void allocateVAO(AIMesh mesh) {
        VAO vao = new VAO();
        vao.VAO = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)vao.VAO);
        vao.VBO = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)vao.VBO);
        AIVector3D.Buffer vertices = mesh.mVertices();
        GL15.nglBufferData((int)34962, (long)(AIVector3D.SIZEOF * vertices.remaining()), (long)vertices.address(), (int)35044);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
        GL20.glEnableVertexAttribArray((int)0);
        float[] uvArr = new float[mesh.mNumVertices() * 2];
        if (mesh.mTextureCoords(0) != null) {
            int i = 0;
            while (i < mesh.mNumVertices()) {
                float u = ((AIVector3D)mesh.mTextureCoords(0).get(i)).x();
                float v = ((AIVector3D)mesh.mTextureCoords(0).get(i)).y();
                uvArr[i * 2] = u;
                uvArr[i * 2 + 1] = v;
                ++i;
            }
        }
        FloatBuffer tbuf = BufferUtils.createFloatBuffer((int)uvArr.length);
        tbuf.put(uvArr).rewind();
        vao.UVBO = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)vao.UVBO);
        GL15.glBufferData((int)34962, (FloatBuffer)tbuf, (int)35044);
        GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)0, (long)0L);
        GL20.glEnableVertexAttribArray((int)1);
        vao.NBO = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)vao.NBO);
        AIVector3D.Buffer normals = mesh.mNormals();
        GL15.nglBufferData((int)34962, (long)(AIVector3D.SIZEOF * normals.remaining()), (long)normals.address(), (int)35044);
        GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
        GL20.glEnableVertexAttribArray((int)2);
        if (mesh.mTangents() != null) {
            vao.TBO = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)vao.TBO);
            AIVector3D.Buffer tangents = mesh.mTangents();
            GL15.nglBufferData((int)34962, (long)(AIVector3D.SIZEOF * tangents.remaining()), (long)tangents.address(), (int)35044);
            GL20.glVertexAttribPointer((int)3, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
            GL20.glEnableVertexAttribArray((int)3);
            vao.BTBO = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)vao.BTBO);
            AIVector3D.Buffer biTangents = mesh.mBitangents();
            GL15.nglBufferData((int)34962, (long)(AIVector3D.SIZEOF * biTangents.remaining()), (long)biTangents.address(), (int)35044);
            GL20.glVertexAttribPointer((int)4, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
            GL20.glEnableVertexAttribArray((int)4);
        }
        vao.IBO = GL15.glGenBuffers();
        int faceCount = mesh.mNumFaces();
        int elementCount = faceCount * 3;
        IntBuffer elementArrayBufferData = BufferUtils.createIntBuffer((int)elementCount);
        AIFace.Buffer facesBuffer = mesh.mFaces();
        int i = 0;
        while (i < faceCount) {
            AIFace face = (AIFace)facesBuffer.get(i);
            if (face.mNumIndices() != 3) {
                throw new IllegalStateException("AIFace.mNumIndices() != 3");
            }
            elementArrayBufferData.put(face.mIndices());
            ++i;
        }
        elementArrayBufferData.flip();
        GL15.glBindBuffer((int)34963, (int)vao.IBO);
        GL15.glBufferData((int)34963, (IntBuffer)elementArrayBufferData, (int)35044);
        GL30.glBindVertexArray((int)0);
        GL15.glBindBuffer((int)34962, (int)0);
        GL15.glBindBuffer((int)34963, (int)0);
        this.vaoMap.put(mesh, vao);
    }

    private VAO allocateSpriteVAO() {
        VAO vao = new VAO();
        vao.VAO = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)vao.VAO);
        float[] vertices = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f};
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 2;
        nArray[4] = 3;
        int[] elements = nArray;
        float[] uv = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
        vao.VBO = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)vao.VBO);
        FloatBuffer vbuf = BufferUtils.createFloatBuffer((int)vertices.length);
        vbuf.put(vertices).rewind();
        GL15.glBufferData((int)34962, (FloatBuffer)vbuf, (int)35044);
        GL20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)0, (long)0L);
        GL20.glEnableVertexAttribArray((int)0);
        vao.UVBO = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)vao.UVBO);
        FloatBuffer uvbuf = BufferUtils.createFloatBuffer((int)uv.length);
        uvbuf.put(uv).rewind();
        GL15.glBufferData((int)34962, (FloatBuffer)uvbuf, (int)35044);
        GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)0, (long)0L);
        GL20.glEnableVertexAttribArray((int)1);
        vao.IBO = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34963, (int)vao.IBO);
        IntBuffer ibuf = BufferUtils.createIntBuffer((int)elements.length);
        ibuf.put(elements).rewind();
        GL15.glBufferData((int)34963, (IntBuffer)ibuf, (int)35044);
        GL30.glBindVertexArray((int)0);
        GL15.glBindBuffer((int)34962, (int)0);
        GL15.glBindBuffer((int)34963, (int)0);
        return vao;
    }

    private void freeMeshVAO(Mesh mesh) {
        if (!this.vaoMap.containsKey(mesh)) {
            return;
        }
        VAO vao = this.vaoMap.get(mesh);
        GL15.glDeleteBuffers((int)vao.VBO);
        GL15.glDeleteBuffers((int)vao.UVBO);
        GL15.glDeleteBuffers((int)vao.NBO);
        GL15.glDeleteBuffers((int)vao.IBO);
        GL30.glDeleteVertexArrays((int)vao.VAO);
    }

    public void add(AIMesh mesh, DiffuseNormalSpecularTexture dns, Matrix4f modelMatrix) {
        this.add(mesh, dns.diffuse, dns.normal, dns.specular, modelMatrix, Vector3f.POOL.next(1.0f, 1.0f, 1.0f), false, 0.0f);
    }

    public void add(AIMesh mesh, Texture texture, Texture normal, Texture specular, Matrix4f modelMatrix) {
        this.add(mesh, texture, normal, specular, modelMatrix, Vector3f.POOL.next(1.0f, 1.0f, 1.0f), false, 0.0f);
    }

    public void add(AIMesh mesh, Texture texture, Texture normal, Texture specular, Matrix4f modelMatrix, Vector3f color) {
        this.add(mesh, texture, normal, specular, modelMatrix, color, true, 0.5f);
    }

    public void add(AIMesh mesh, Matrix4f modelMatrix, Vector3f color) {
        this.add(mesh, ResourceHandler.white, ResourceHandler.white, ResourceHandler.white, modelMatrix, color, false, 1.0f);
    }

    public void add(AIMesh mesh, Texture texture, Texture normal, Texture specular, Matrix4f modelMatrix, Vector3f color, boolean effects) {
        this.add(mesh, texture, normal, specular, modelMatrix, color, effects, 0.5f);
    }

    public void add(AIMesh mesh, Texture texture, Texture normal, Texture specular, Matrix4f modelMatrix, Vector3f color, boolean effects, float colorMix) {
        if (!this.vaoMap.containsKey(mesh)) {
            this.allocateVAO(mesh);
        }
        Model m = Model.POOL.next();
        m.mesh = mesh;
        m.texture = texture;
        m.normalTexture = normal;
        m.specularTexture = specular;
        m.modelMatrix = modelMatrix;
        m.color = color;
        m.meshVAO = this.vaoMap.get((Object)mesh).VAO;
        m.effects = effects;
        m.colorMix = colorMix;
        this.renderList.add(m);
    }

    public void addGround(AIMesh mesh, DiffuseNormalSpecularTexture dns, Matrix4f modelMatrix) {
        this.addGround(mesh, dns.diffuse, dns.normal, dns.specular, modelMatrix, Vector3f.POOL.next(1.0f, 1.0f, 1.0f), false, 0.0f);
    }

    public void addGround(AIMesh mesh, Texture texture, Texture normal, Texture specular, Matrix4f modelMatrix, Vector3f color, boolean effects, float colorMix) {
        if (!this.vaoMap.containsKey(mesh)) {
            this.allocateVAO(mesh);
        }
        Model m = Model.POOL.next();
        m.mesh = mesh;
        m.texture = texture;
        m.normalTexture = normal;
        m.specularTexture = specular;
        m.modelMatrix = modelMatrix;
        m.color = color;
        m.meshVAO = this.vaoMap.get((Object)mesh).VAO;
        m.effects = effects;
        m.colorMix = colorMix;
        m.affectedByShadow = true;
        m.giveShadow = false;
        this.renderList.add(m);
    }

    public void addTransparent(AIMesh mesh, Texture texture, Matrix4f modelMatrix, Vector3f color, boolean effects, float colorMix, double realZ, Vec3 p) {
        if (!this.vaoMap.containsKey(mesh)) {
            this.allocateVAO(mesh);
        }
        Model m = Model.POOL.next();
        m.mesh = mesh;
        m.texture = texture;
        m.modelMatrix = modelMatrix;
        m.color = color;
        m.meshVAO = this.vaoMap.get((Object)mesh).VAO;
        m.effects = effects;
        m.colorMix = colorMix;
        m.realZ = realZ;
        m.pos = p;
        this.transparentList.add(m);
    }

    public void addSprite(Texture texture, Matrix4f modelMatrix) {
        this.addSprite(texture, modelMatrix, Vector3f.POOL.next(1.0f, 1.0f, 1.0f), 0.0f, null);
    }

    public void addSprite(Texture texture, Matrix4f modelMatrix, Vector3f color, float colorMix, AIMesh mesh) {
        if (mesh != null && !this.vaoMap.containsKey(mesh)) {
            this.allocateVAO(mesh);
        }
        Sprite m = Sprite.POOL.next();
        m.textureID = texture.textureID;
        m.modelMatrix = modelMatrix;
        m.color = color;
        m.colorMix = colorMix;
        m.mesh = mesh;
        if (mesh != null) {
            m.meshVAO = this.vaoMap.get((Object)mesh).VAO;
        }
        this.spriteList.add(m);
    }

    public void addSprite(Texture texture, Matrix4f modelMatrix, Vector3f color, float colorMix) {
        this.addSprite(texture, modelMatrix, color, colorMix, null);
    }

    public void free() {
        Iterator<Map.Entry<AIMesh, VAO>> it = this.vaoMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<AIMesh, VAO> pair = it.next();
            Mesh mesh = (Mesh)pair.getKey();
            this.freeMeshVAO(mesh);
            it.remove();
        }
        VAO vao = this.quadVAO;
        GL15.glDeleteBuffers((int)vao.VBO);
        GL15.glDeleteBuffers((int)vao.UVBO);
        GL15.glDeleteBuffers((int)vao.IBO);
        GL30.glDeleteVertexArrays((int)vao.VAO);
    }

    public abstract void init();

    public abstract void begin();

    public abstract void end(Game var1, Window var2, Player var3);

    protected class VAO {
        public int VAO;
        public int VBO;
        public int IBO;
        public int UVBO;
        public int NBO;
        public int TBO;
        public int BTBO;
        public int instancedVBO;

        protected VAO() {
        }
    }
}

