/*
 * Decompiled with CFR 0.152.
 */
package renderer.glengine;

import game.Vec3;
import org.lwjgl.assimp.AIMesh;
import renderer.Pool;
import renderer.glengine.Matrix4f;
import renderer.glengine.Texture;
import renderer.glengine.Vector3f;

public class Model
implements Comparable<Model> {
    public AIMesh mesh;
    public Texture texture;
    public Texture normalTexture;
    public Texture specularTexture;
    public Matrix4f modelMatrix;
    public Vector3f color;
    public int meshVAO;
    public boolean effects = true;
    public float colorMix = 0.5f;
    public double realZ = 0.0;
    public Vec3 pos;
    public boolean giveShadow = true;
    public boolean affectedByShadow = false;
    static Pool<Model> POOL = new Pool<Model>(){

        @Override
        protected Model newElement() {
            return new Model();
        }

        @Override
        protected void resetElement(Model m) {
            m.reset();
        }
    };

    @Override
    public int compareTo(Model r) {
        if (this.texture.textureID < r.texture.textureID) {
            return -1;
        }
        if (this.texture.textureID > r.texture.textureID) {
            return 1;
        }
        return 0;
    }

    protected void reset() {
        this.mesh = null;
        this.texture = null;
        this.normalTexture = null;
        this.specularTexture = null;
        this.modelMatrix = null;
        this.color = null;
        this.meshVAO = 0;
        this.effects = true;
        this.colorMix = 0.5f;
        this.realZ = 0.0;
        this.pos = null;
        this.giveShadow = true;
    }
}

