/*
 * Decompiled with CFR 0.152.
 */
package renderer.glengine;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL30;
import org.lwjgl.stb.STBImage;
import renderer.IOUtil;

public class Texture {
    public int width;
    public int height;
    public int textureID;
    public BufferedImage image;
    private int w;
    private int h;
    private int comp;

    public Texture(String path) {
        this.textureID = this.load(path);
    }

    public Texture(BufferedImage img) {
        this.textureID = this.createTexture(img);
    }

    public static Texture getTexture(String path) {
        return new Texture(path);
    }

    private ByteBuffer loadSTB(String imagePath) {
        ByteBuffer imageBuffer;
        try {
            imageBuffer = IOUtil.ioResourceToByteBuffer(imagePath, 8192);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        IntBuffer w = BufferUtils.createIntBuffer((int)1);
        IntBuffer h = BufferUtils.createIntBuffer((int)1);
        IntBuffer comp = BufferUtils.createIntBuffer((int)1);
        if (!STBImage.stbi_info_from_memory((ByteBuffer)imageBuffer, (IntBuffer)w, (IntBuffer)h, (IntBuffer)comp)) {
            throw new RuntimeException("Failed to read image information: " + STBImage.stbi_failure_reason());
        }
        ByteBuffer image = STBImage.stbi_load_from_memory((ByteBuffer)imageBuffer, (IntBuffer)w, (IntBuffer)h, (IntBuffer)comp, (int)0);
        if (image == null) {
            throw new RuntimeException("Failed to load image: " + STBImage.stbi_failure_reason());
        }
        this.w = w.get(0);
        this.h = h.get(0);
        this.comp = comp.get(0);
        return image;
    }

    private int load(String path) {
        long t0 = System.currentTimeMillis();
        ByteBuffer buf = this.loadSTB(path);
        int result = GL11.glGenTextures();
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)result);
        if (this.comp == 3) {
            if ((this.w & 3) != 0) {
                GL11.glPixelStorei((int)3317, (int)(2 - (this.w & 1)));
            }
            GL11.glTexImage2D((int)3553, (int)0, (int)6407, (int)this.w, (int)this.h, (int)0, (int)6407, (int)5121, (ByteBuffer)buf);
        } else {
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.w, (int)this.h, (int)0, (int)6408, (int)5121, (ByteBuffer)buf);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        }
        GL30.glGenerateMipmap((int)3553);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9987);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9987);
        GL11.glBindTexture((int)3553, (int)0);
        return result;
    }

    public void bind() {
        GL11.glBindTexture((int)3553, (int)this.textureID);
    }

    public void unbind() {
        GL11.glBindTexture((int)3553, (int)0);
    }

    public void free() {
        GL11.glDeleteTextures((int)this.textureID);
    }

    public int createTexture(BufferedImage image) {
        this.image = image;
        int[] pixels = null;
        this.width = image.getWidth();
        this.height = image.getHeight();
        pixels = new int[this.width * this.height];
        image.getRGB(0, 0, this.width, this.height, pixels, 0, this.width);
        int[] data = new int[this.width * this.height];
        int i = 0;
        while (i < this.width * this.height) {
            int a = (pixels[i] & 0xFF000000) >> 24;
            int r = (pixels[i] & 0xFF0000) >> 16;
            int g = (pixels[i] & 0xFF00) >> 8;
            int b = pixels[i] & 0xFF;
            data[i] = a << 24 | b << 16 | g << 8 | r;
            ++i;
        }
        int result = GL11.glGenTextures();
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)result);
        IntBuffer buf = BufferUtils.createIntBuffer((int)data.length);
        buf.put(data).rewind();
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, (IntBuffer)buf);
        GL30.glGenerateMipmap((int)3553);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glBindTexture((int)3553, (int)0);
        return result;
    }

    private IntBuffer bufferedImageToBuffer(BufferedImage image, int[] data, IntBuffer buf) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        image.getRGB(0, 0, this.width, this.height, data, 0, this.width);
        int i = 0;
        while (i < this.width * this.height) {
            int pixel = data[i];
            int a = (pixel & 0xFF000000) >> 24;
            int r = (pixel & 0xFF0000) >> 16;
            int g = (pixel & 0xFF00) >> 8;
            int b = pixel & 0xFF;
            data[i] = a << 24 | b << 16 | g << 8 | r;
            ++i;
        }
        buf.put(data).rewind();
        return buf;
    }

    public void changeImage(IntBuffer buf) {
        GL11.glBindTexture((int)3553, (int)this.textureID);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)this.width, (int)this.height, (int)6408, (int)5121, (IntBuffer)buf);
    }
}

