/*
 * Decompiled with CFR 0.152.
 */
package renderer.glengine;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import renderer.Pool;

public class Vector3f {
    public float x;
    public float y;
    public float z;
    static PoolV POOL = new PoolV();

    private Vector3f() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    private Vector3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public Vector3f normalize() {
        float length = this.length();
        return this.divide(length);
    }

    public Vector3f add(Vector3f other) {
        float x = this.x + other.x;
        float y = this.y + other.y;
        float z = this.z + other.z;
        return POOL.next(x, y, z);
    }

    public Vector3f negate() {
        return this.scale(-1.0f);
    }

    public Vector3f subtract(Vector3f other) {
        return this.add(other.negate());
    }

    public Vector3f scale(float scalar) {
        float x = this.x * scalar;
        float y = this.y * scalar;
        float z = this.z * scalar;
        return POOL.next(x, y, z);
    }

    public Vector3f divide(float scalar) {
        return this.scale(1.0f / scalar);
    }

    public float dot(Vector3f other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public Vector3f cross(Vector3f other) {
        float x = this.y * other.z - this.z * other.y;
        float y = this.z * other.x - this.x * other.z;
        float z = this.x * other.y - this.y * other.x;
        return POOL.next(x, y, z);
    }

    public Vector3f lerp(Vector3f other, float alpha) {
        return this.scale(1.0f - alpha).add(other.scale(alpha));
    }

    public FloatBuffer getBuffer() {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)3);
        buffer.put(this.x).put(this.y).put(this.z);
        buffer.flip();
        return buffer;
    }

    /* synthetic */ Vector3f(Vector3f vector3f) {
        this();
    }

    public static class PoolV
    extends Pool<Vector3f> {
        @Override
        protected Vector3f newElement() {
            return new Vector3f(null);
        }

        public Vector3f next(float x, float y, float z) {
            Vector3f v = (Vector3f)super.next();
            v.set(x, y, z);
            return v;
        }

        @Override
        protected void resetElement(Vector3f v) {
            v.set(0.0f, 0.0f, 0.0f);
        }
    }
}

