/*
 * Decompiled with CFR 0.152.
 */
package renderer.glengine;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;

public class Vector4f {
    public float x;
    public float y;
    public float z;
    public float w;

    public Vector4f() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 0.0f;
    }

    public Vector4f(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public Vector4f normalize() {
        float length = this.length();
        return this.divide(length);
    }

    public Vector4f add(Vector4f other) {
        float x = this.x + other.x;
        float y = this.y + other.y;
        float z = this.z + other.z;
        float w = this.w + other.w;
        return new Vector4f(x, y, z, w);
    }

    public Vector4f negate() {
        return this.scale(-1.0f);
    }

    public Vector4f subtract(Vector4f other) {
        return this.add(other.negate());
    }

    public Vector4f scale(float scalar) {
        float x = this.x * scalar;
        float y = this.y * scalar;
        float z = this.z * scalar;
        float w = this.w * scalar;
        return new Vector4f(x, y, z, w);
    }

    public Vector4f divide(float scalar) {
        return this.scale(1.0f / scalar);
    }

    public float dot(Vector4f other) {
        return this.x * other.x + this.y * other.y + this.z * other.z + this.w * other.w;
    }

    public Vector4f lerp(Vector4f other, float alpha) {
        return this.scale(1.0f - alpha).add(other.scale(alpha));
    }

    public FloatBuffer getBuffer() {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)4);
        buffer.put(this.x).put(this.y).put(this.z).put(this.w);
        buffer.flip();
        return buffer;
    }
}

