/*
 * Decompiled with CFR 0.152.
 */
package renderer.glengine;

import input.CharHandler;
import input.KeyHandler;
import input.MouseButtonHandler;
import input.MouseHandler;
import input.ScrollHandler;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharCallback;
import org.lwjgl.glfw.GLFWCharCallbackI;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.glfw.GLFWScrollCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import renderer.glengine.Texture;

public class Window {
    private long window;
    public static int width;
    public static int height;
    private String title;
    private GLFWKeyCallback keyCallback;
    private GLFWCursorPosCallback cursorCallback;
    private GLFWErrorCallback errorCallback;
    private GLFWMouseButtonCallback buttonCallback;
    private GLFWCharCallback charCallback;
    private GLFWScrollCallback scrollCallback;

    public Window(String title) {
        this.title = title;
    }

    public Window(String title, int w, int h) {
        this.title = title;
        width = w;
        height = h;
    }

    public void init(int antiAliasing, boolean fullscreen, boolean vsync) {
        this.init(false, 0, 0, antiAliasing, fullscreen, vsync);
    }

    public void init(int locationX, int locationY, int antiAliasing, boolean fullscreen, boolean vsync) {
        this.init(true, locationX, locationY, antiAliasing, fullscreen, vsync);
    }

    private void init(boolean customLocation, int locationX, int locationY, int antiAliasing, boolean fullscreen, boolean vsync) {
        try {
            GLFWErrorCallback.createPrint((PrintStream)System.err).set();
            if (!GLFW.glfwInit()) {
                throw new IllegalStateException("Unable to initialize GLFW");
            }
            GLFW.glfwDefaultWindowHints();
            GLFW.glfwWindowHint((int)131076, (int)0);
            GLFW.glfwWindowHint((int)131075, (int)1);
            if (fullscreen) {
                GLFW.glfwWindowHint((int)131077, (int)0);
            }
            GLFW.glfwWindowHint((int)135174, (int)8);
            GLFW.glfwWindowHint((int)135181, (int)8);
            GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)GLFW.glfwGetPrimaryMonitor());
            this.window = GLFW.glfwCreateWindow((int)width, (int)height, (CharSequence)this.title, (long)0L, (long)0L);
            if (fullscreen) {
                GLFW.glfwSetInputMode((long)this.window, (int)208897, (int)212994);
            }
            if (this.window == 0L) {
                System.err.println("Could not create our Window!");
            }
            GLFW.glfwSetWindowPos((long)this.window, (int)((vidmode.width() - width) / 2), (int)((vidmode.height() - height) / 2));
            GLFW.glfwMakeContextCurrent((long)this.window);
            GLFW.glfwShowWindow((long)this.window);
            this.keyCallback = new KeyHandler();
            GLFW.glfwSetKeyCallback((long)this.window, (GLFWKeyCallbackI)this.keyCallback);
            this.cursorCallback = new MouseHandler();
            GLFW.glfwSetCursorPosCallback((long)this.window, (GLFWCursorPosCallbackI)this.cursorCallback);
            this.buttonCallback = new MouseButtonHandler();
            GLFW.glfwSetMouseButtonCallback((long)this.window, (GLFWMouseButtonCallbackI)this.buttonCallback);
            this.charCallback = new CharHandler();
            GLFW.glfwSetCharCallback((long)this.window, (GLFWCharCallbackI)this.charCallback);
            this.scrollCallback = new ScrollHandler();
            GLFW.glfwSetScrollCallback((long)this.window, (GLFWScrollCallbackI)this.scrollCallback);
            GLFW.glfwSwapInterval((int)(vsync ? 1 : 0));
            GL.createCapabilities();
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            System.out.println("OpenGL: " + GL11.glGetString((int)7938));
            GLFW.glfwSetInputMode((long)this.window, (int)208897, (int)212993);
            GLFW.glfwSetInputMode((long)this.window, (int)208897, (int)212995);
        }
        catch (Exception e) {
            System.out.println("Can not create window");
            e.printStackTrace();
        }
    }

    private void setIcon() {
        int[] pixels = null;
        int cursorWidth = 0;
        int cursorHeight = 0;
        try {
            InputStream in = Texture.class.getResourceAsStream("/textures/icon2.png");
            BufferedImage image = ImageIO.read(in);
            cursorWidth = image.getWidth();
            cursorHeight = image.getHeight();
            pixels = new int[cursorWidth * cursorHeight];
            image.getRGB(0, 0, cursorWidth, cursorHeight, pixels, 0, cursorWidth);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ByteBuffer bb = BufferUtils.createByteBuffer((int)(cursorWidth * cursorHeight * 4));
        int i = 0;
        while (i < cursorWidth * cursorHeight) {
            int a = (pixels[i] & 0xFF000000) >> 24;
            int r = (pixels[i] & 0xFF0000) >> 16;
            int g = (pixels[i] & 0xFF00) >> 8;
            int b = pixels[i] & 0xFF;
            if (a == 0) {
                bb.put((byte)0);
                bb.put((byte)0);
                bb.put((byte)0);
                bb.put((byte)1);
            } else {
                bb.put((byte)r);
                bb.put((byte)g);
                bb.put((byte)b);
                bb.put((byte)a);
            }
            ++i;
        }
        bb.rewind();
        GLFWImage.Buffer icons = GLFWImage.malloc((int)1);
        ((GLFWImage.Buffer)icons.position(0)).width(cursorWidth).height(cursorHeight).pixels(bb);
        GLFW.glfwSetWindowIcon((long)this.window, (GLFWImage.Buffer)icons);
    }

    private void createCursor() {
        int[] pixels = null;
        int cursorWidth = 0;
        int cursorHeight = 0;
        try {
            InputStream in = Texture.class.getResourceAsStream("/textures/cursor.png");
            BufferedImage image = ImageIO.read(in);
            cursorWidth = image.getWidth();
            cursorHeight = image.getHeight();
            pixels = new int[cursorWidth * cursorHeight];
            image.getRGB(0, 0, cursorWidth, cursorHeight, pixels, 0, cursorWidth);
        }
        catch (Exception e) {
            System.out.println("Fel med textur: textures/cursor.png");
            e.printStackTrace();
        }
        ByteBuffer bb = BufferUtils.createByteBuffer((int)(cursorWidth * cursorHeight * 4));
        int i = 0;
        while (i < cursorWidth * cursorHeight) {
            int a = (pixels[i] & 0xFF000000) >> 24;
            int r = (pixels[i] & 0xFF0000) >> 16;
            int g = (pixels[i] & 0xFF00) >> 8;
            int b = pixels[i] & 0xFF;
            if (a == 0) {
                bb.put((byte)0);
                bb.put((byte)0);
                bb.put((byte)0);
                bb.put((byte)1);
            } else {
                bb.put((byte)r);
                bb.put((byte)g);
                bb.put((byte)b);
                bb.put((byte)a);
            }
            ++i;
        }
        bb.rewind();
        GLFWImage buf = GLFWImage.malloc().set(cursorWidth, cursorHeight, bb);
        long cursor = GLFW.glfwCreateCursor((GLFWImage)buf, (int)0, (int)0);
        if (cursor == 0L) {
            throw new RuntimeException("Error creating cursor");
        }
        GLFW.glfwSetCursor((long)this.window, (long)cursor);
    }

    public long getWindowID() {
        return this.window;
    }

    public void destroy() {
        Callbacks.glfwFreeCallbacks((long)this.window);
        GLFW.glfwDestroyWindow((long)this.window);
        GLFW.glfwTerminate();
        GLFW.glfwSetErrorCallback(null).free();
    }

    public void swapBuffers() {
        GLFW.glfwSwapBuffers((long)this.window);
    }

    public boolean shouldClose() {
        return GLFW.glfwWindowShouldClose((long)this.window);
    }

    public void setShouldClose(boolean shouldClose) {
        GLFW.glfwSetWindowShouldClose((long)this.window, (boolean)shouldClose);
    }

    public void pollEvents() {
        GLFW.glfwPollEvents();
    }

    public float getAspect() {
        return (float)width / (float)height;
    }

    public float getWidth() {
        return width;
    }

    public float getHeight() {
        return height;
    }

    public void setVSync(boolean v) {
        GLFW.glfwSwapInterval((int)(v ? 1 : 0));
    }
}

