/*
 * Decompiled with CFR 0.152.
 */
package textures;

import game.MathUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import noise.OpenSimplexNoise;

public class ProceduralImages {
    public static BufferedImage createSmokeImage() {
        int size = 256;
        BufferedImage image = new BufferedImage(size, size, 2);
        Graphics g = image.getGraphics();
        double colorScale = 0.01;
        double opacityScale = 0.03;
        OpenSimplexNoise osn = new OpenSimplexNoise(234675435345617L);
        int x = 0;
        while (x < image.getWidth()) {
            int y = 0;
            while (y < image.getHeight()) {
                double colorNoise = osn.eval((double)x * colorScale, (double)y * colorScale);
                colorNoise += 1.0;
                int grey = (int)(150.0 + (colorNoise *= 0.5) * 30.0);
                double opacityNoise = osn.eval((double)x * opacityScale, (double)y * opacityScale);
                opacityNoise = (opacityNoise + 1.0) * 0.5 * 0.15 + 0.25;
                double dx = image.getWidth() / 2 - x;
                double dy = image.getHeight() / 2 - y;
                double len = Math.sqrt(dx * dx + dy * dy);
                double a = Math.atan2(dy, dx);
                double radial = (osn.eval(a * 2.0, 3456.0) + 1.0) * 0.1 + 0.9;
                int opacity = (int)MathUtils.clamp(255.0 - 255.0 * len / (radial * (double)size * 0.45), 0.0, 150.0);
                g.setColor(new Color(grey, grey, grey, (int)((double)opacity * opacityNoise)));
                g.fillRect(x, y, 1, 1);
                ++y;
            }
            ++x;
        }
        return image;
    }
}

