#version 330 core
layout (location = 0) out vec4 gPosition;
layout (location = 1) out vec4 gNormal;
layout (location = 2) out vec4 gColorSpec;

in vec2 TexCoords;
in vec3 FragPos;
in vec3 Normal;
in mat3 TBN;

uniform sampler2D modelTexture;
uniform sampler2D normalTexture;
uniform sampler2D specularTexture;
uniform int stencil;

void main()
{
    // Store the fragment position vector in the first gbuffer texture
    gPosition.rgb = FragPos;
    gPosition.a = stencil;

    // Also store the per-fragment normals into the gbuffer
    vec3 n = texture(normalTexture, TexCoords).rgb;
    gNormal.rgb = normalize(n * 2.0 - 1.0); //normalize(Normal);
    gNormal.rgb = normalize(TBN * gNormal.rgb);
    gNormal.a = 1.0;

    gColorSpec.rgb = texture(modelTexture, TexCoords).rgb;
    gColorSpec.a = texture(specularTexture, TexCoords).r;


}
