#version 330 core
out vec4 FragColor;
in vec2 TexCoords;
in vec4 ShadowCoords;

uniform sampler2D gPosition;
uniform sampler2D gNormal;
uniform sampler2D gColorSpec;
uniform vec3 cameraPos;

#define MAX_LIGHTS 100
uniform vec3 lightPos[MAX_LIGHTS];
uniform vec3 lightColor[MAX_LIGHTS];
uniform vec3 lightDirs[MAX_LIGHTS];
uniform float lightDirPows[MAX_LIGHTS];
uniform float lightStrength[MAX_LIGHTS];
uniform int numLights;
uniform int numVolumetricLights;

uniform sampler2DShadow shadowMap;
uniform mat4 depthBiasMVP;

uniform vec3 pointLightPos;
uniform samplerCube cubeShadowMap;
uniform float far_plane;


// array of offset direction for sampling
vec3 gridSamplingDisk[20] = vec3[]
(
   vec3(1, 1, 1), vec3(1, -1, 1), vec3(-1, -1, 1), vec3(-1, 1, 1),
   vec3(1, 1, -1), vec3(1, -1, -1), vec3(-1, -1, -1), vec3(-1, 1, -1),
   vec3(1, 1, 0), vec3(1, -1, 0), vec3(-1, -1, 0), vec3(-1, 1, 0),
   vec3(1, 0, 1), vec3(-1, 0, 1), vec3(1, 0, -1), vec3(-1, 0, -1),
   vec3(0, 1, 1), vec3(0, -1, 1), vec3(0, -1, -1), vec3(0, 1, -1)
);

float CalcShadowFactor(vec3 fragPos)
{
	vec3 fragToLight = fragPos - pointLightPos;
	float currentDepth = length(fragToLight);

	float shadow = 0.0;
	    float bias = 0.25;
	    int samples = 25;
	    float viewDistance = length(cameraPos - fragPos);
	    float diskRadius = (1.0 + (viewDistance / far_plane)) / 25.0;
	    for(int i = 0; i < samples; ++i)
	    {
	        float closestDepth = texture(cubeShadowMap, fragToLight + gridSamplingDisk[i] * diskRadius).r;
	        closestDepth *= far_plane;   // Undo mapping [0;1]
	        if(currentDepth - bias > closestDepth)
	            shadow += 1.0;
	    }
	shadow /= float(samples);

	return 1 - shadow * (1-smoothstep(5, 75, currentDepth));

}

float getSpecular(vec3 normal, vec3 light, vec3 viewdir, float s)
{
//	float k = max(0.0, dot(viewdir, reflect(light, normal)));
//    return  pow(k, s);
    vec3 halfwayDir = normalize(-light + viewdir);
	float spec = pow(max(dot(normal, halfwayDir), 0.0), s * 2);
	return spec;
}


#define MOD_POS(p) vec3(mod(p.x + 1.45, modD) - modD * 0.5, p.y, mod(p.z + 9.5, modD) - modD * 0.5 )
void main()
{             
	vec3 fragNormal = texture(gNormal, TexCoords).rgb;
	vec3 fragPosition = texture(gPosition, TexCoords).rgb;
	vec3 fragColor = texture(gColorSpec, TexCoords).rgb;
	float specularity = texture(gColorSpec, TexCoords).a;
	vec3 lightDir = normalize(vec3(0.3, -0.7, 0.3));
	vec3 viewDir = normalize(cameraPos - fragPosition);//normalize(vec3(10, 10, 10) - fragPos);
	
	float diffuse = max(0.0, dot(fragNormal, normalize(-lightDir)));
    vec4 ShadowCoords = depthBiasMVP * vec4(fragPosition,1.0);

    // And the diffuse per-fragment color
	float shadow = texture(shadowMap, ShadowCoords.xyz);
	if( ShadowCoords.x > 1 || ShadowCoords.x < 0 || ShadowCoords.y > 1 || ShadowCoords.y < 0 || texture(gPosition, TexCoords).a == 0) {
		shadow = 1.0;
	}


	shadow = CalcShadowFactor(fragPosition);
	diffuse *= shadow;
	//float specular = getSpecular(fragNormal, lightDir, viewDir, 100);
   // FragColor = vec4((0.1 + 0.7*diffuse + 2*specular)*fragColor, 1.0);


//    float shadow = texture(gPosition, TexCoords).w;
	float sf = 0.2 + 0.8*shadow;
	vec3 lgt = (0.1)*fragColor * (sf);
	for(int i = 0; i < numLights; i++){
		float diff = clamp(dot(fragNormal, normalize( lightPos[i] - fragPosition)),0,1);
		float specc = getSpecular(fragNormal, -normalize( lightPos[i] - fragPosition), viewDir, 100);
		float l = length(lightPos[i] - fragPosition);
		float str = 1 / (0.01 + 0.1 * l + 0.01*pow(l,2));
		
		vec3 clr = normalize(lightColor[i]);
		//lgt += lightStrength[i]*(diff + specc)*str*clr;

		vec3 Lnorm = (lightPos[i]-fragPosition)/l;
		float dir = max(0.01, dot(Lnorm, lightDirs[i]));
		//lgt += (lightStrength[i]*diff*str*clr*fragColor + lightStrength[i]*specc*str*clr * specularity) * pow(dir, lightDirPows[i]);
		lgt += (lightStrength[i]*diff*str*clr*fragColor + lightStrength[i]*specc*str*clr * specularity) * pow(dir, lightDirPows[i]) * sf;
	}
	
	vec3 modLightPos = vec3(0.0, 6.1, 0.0);
	float modD = 10;
	vec3 modLightCol = vec3(1.0, 0.9, 0.5);
	vec3 modDir = normalize(vec3(0.0, 1.0, 0.0));
	{ // "mod" lightning
		vec3 pos = MOD_POS(fragPosition);
		float diff = clamp(dot(fragNormal, normalize( modLightPos - pos + vec3(modD * 0.5))), 0, 1);
		float specc = getSpecular(fragNormal, -normalize( modLightPos - pos), viewDir, 100);
		float l = length(modLightPos - pos);
		float str = 1 / (0.01 + 0.1 * l + 0.01*pow(l,2));
		vec3 clr = normalize(modLightCol);
		vec3 Lnorm = (modLightPos-pos)/l;
		float dir = max(0.01, dot(Lnorm, modDir));
		lgt += 0.2 * (diff*str*clr*fragColor + specc*str*clr * specularity) * pow(dir, 3.0);
	}


	FragColor = vec4(lgt * (1 - smoothstep(100, 200, length(cameraPos - fragPosition))), 1.0);
	
	// Volumetric lightning
	float t = 0.0;
	vec3 scatteredLight = vec3(0.0);
	float transmittance = 1.0;
	float fogAmount = 0.004; // 0.06;
	float minDistance = 0.0;
	vec3 p = vec3(-1.0, -1.0, -1.0);
	vec3 rd = normalize(fragPosition - cameraPos);
	float dis = length(fragPosition - cameraPos);
	dis = min(dis, 100);
	float strenght = 30.0;
	while (t < dis) {
		p = cameraPos + rd * t;

		minDistance = 999999;
		vec3 light = vec3(0.0);
		for(int i = 0; i < numVolumetricLights; i++){
			vec3 l = lightPos[i] - p;
			float disToLight = length(l);
			minDistance = min(minDistance, disToLight);
			vec3 pointLight = lightStrength[i]*lightColor[i] * strenght / (disToLight * disToLight);
			vec3 Lnorm = l/disToLight;
			float dir = max(0.01, dot(Lnorm, lightDirs[i]));
			light += pointLight * pow(dir, lightDirPows[i]);
		}
		// "mod" volumetric lightning
		vec3 pos = MOD_POS(p);
		vec3 L = modLightPos-pos;
		float distanceToL = length(L);
		vec3 point = modLightCol * 0.4 * strenght/pow(distanceToL,3);
		vec3 Lnorm = L/distanceToL;
		float dir = max(0.01, dot(Lnorm, modDir));
		light += point * pow(dir, 1);
		minDistance = min(minDistance, distanceToL);
		// end "mod" volumetric lightning

		minDistance = clamp(minDistance * 0.5, 0.2, 1.0 + max(t - 15, 0) * 3.0);
		vec3 lightIntegrated = light - light * exp(-fogAmount * minDistance);
		scatteredLight += transmittance * lightIntegrated;

		transmittance *= exp(-fogAmount * minDistance);

		t += minDistance;
	}
	FragColor.rgb = FragColor.rgb * transmittance + scatteredLight;
	// end volumetric
	
	// Reinhard tone mapping
    FragColor.rgb = FragColor.rgb / (FragColor.rgb + vec3(1.0));
	
	float gamma = 1.0;
	FragColor.rgb = pow(FragColor.rgb, vec3(1.0/gamma)) * 1.0 ;


	//float closestDepth = texture(cubeShadowMap, LightDirection).r;;
	//FragColor = vec4(vec3(closestDepth / 150.0), 1.0);
}  
