#version 330

in vec2 fragUV;
in vec3 fragNormal;
in vec3 fragPos;
in float isConstructing;
in vec4 shadowCoord;


out vec4 outColor;

uniform sampler2D modelTexture;
uniform sampler2D noiseP;
uniform float tick;
uniform vec2 mousePos;
uniform vec3 color;
uniform bool effects;
uniform float colorMix;
uniform bool isUnit;
uniform bool underConstruction;
uniform vec2 mapSize;
uniform float meshBottom;
uniform float meshTop;
uniform float portionConstructed;

uniform sampler2D fogTexture;
uniform sampler2DShadow shadowMap;


SHARED_OJ

#define PI 3.1415
void main()
{

	float a = atan(fragPos.z, fragPos.x);
	float h = atan(fragPos.y, length(fragPos.xz));
	a += 0.5 * PI;
	a /= PI;
	h += 0.5 * PI;
	h /= PI;
	vec3 color = smoothstep(0.45, 0.6, h) * vec3(0.3, 0.3, 1);
	outColor = vec4(color, 1.0);

}
