#version 330

in vec2 fragUV;
in vec3 fragNormal;
in vec3 fragPos;
in vec4 shadowCoord;

out vec4 outColor;

uniform sampler2D modelTexture;
uniform sampler2DShadow shadowMap;
uniform sampler2D fogTexture;

uniform int tick;
uniform vec2 mousePos;
uniform vec3 color;
uniform bool effects;
uniform float colorMix;
uniform vec2 mapSize;



SHARED_OJ



void main()
{    
	vec3 lightDir = normalize(vec3(0.5, 0, -1));
 
	vec4 tc = texture(modelTexture, fragUV);
	float k = 0.2;
	float g1 = texture(modelTexture, (fragPos.zx + 128)* 0.003).x;
	float g15 = texture(modelTexture, (fragPos.xz + 128)* 0.04*k).x;
	float g2 = texture(modelTexture, (fragPos.xz + 128)* 0.1*k).x;
	float g3 = texture(modelTexture, (fragPos.xz + 128)* 0.15*k).x;
	float g4 = texture(modelTexture, (fragPos.xz + 128)* 0.2*k).x;
	float g5 = texture(modelTexture, (fragPos.xz + 128)* 0.5*k).x;
	float g6 = texture(modelTexture, (fragPos.xz + 128)* 0.8*k + vec2(0.5, 0.6)).x;
	float g7 = texture(modelTexture, (fragPos.xz + 128)* 3*k).x;
	


	vec3 viewDir = normalize(vec3(10, 1000, 10) - fragPos);
	float spec = min(1, specular(fragNormal, lightDir, viewDir, 1));
	
	vec3 c1 = 0.03*vec3(0.7f,0.8f,0.3f) +  vec3(0.3,0.3,0.3) + vec3(0.01 * (g1 + g2 + g3 + g4)); //Sand
	c1 = 0.7*c1;
	vec3 grassColor = vec3(0.33, 0.44, 0.33)*(0.80 - 0.4*g1 - 0.2*g4 + 0.07*g6 + 0.01*g5 - 0.08*g7);
	vec3 c2 = mix(grassColor, vec3(0.2,0.1,0.05), 0.2*smoothstep(0.6, 0.9, g15)); //Land
	vec3 c3 = 0.5*vec3(0.4f,0.4f,0.4f) + vec3(0.01 * (g1 + g2 + g3 + g4)) ; //Mountain
	vec3 c4 = 0.5*vec3(0.9f,0.9f,0.9f) + vec3(0.01 * (g1 + g2 + g3 + g4)) ; //Snow
	
	
	vec3 b1 = c1;
	vec3 b2 = mix(b1, c1, smoothstep(-0.1,0, fragPos.y));
	vec3 b3 = mix(b2, c2, smoothstep(-0.6,-0.1, fragPos.y));

	vec3 mountainColor = vec3(0.36,0.36,0.36)*(0.7 + 0.2*g5);
	vec3 b4 = mix(b3, mountainColor, smoothstep(0.5, 10, fragPos.y));
	vec3 b5 = mix(b4, vec3(0.8,0.8,0.8)*(0.6  + 0.5*spec + 0.1*g5), smoothstep(10, 16, fragPos.y));
	float snow = 0;
	if(fragPos.z > 10){
		snow = pow(fragNormal.z ,8)*(1- 0.7*g6 );
	}
	b5 = mix(b4, b4 + 0.5*snow , smoothstep(10,15,fragPos.y));

	float shadow = texture(shadowMap, shadowCoord.xyz);
	if( shadowCoord.x > 1 || shadowCoord.x < 0 || shadowCoord.y > 1 || shadowCoord.y < 0  ) {
		shadow = 1.0;
	}

	lightDir = normalize(vec3(0.6, 0.9, 0.6));
	float df = max(0.0, dot(fragNormal, normalize(-lightDir)));

	outColor = vec4(b5*(0.7 + 2*df), 1);
	//outColor = addLight(vec4(b5,1), fragNormal, fragPos, lightDir, shadow);
	float depthDarkening = clamp((fragPos.y + 17.0) * 0.055, 0.0, 1.0); // If constant transparency is used for the water this can be used to make the sea bottom darker TODO the values might need to be tweaked
	outColor.xyz *= depthDarkening;
	outColor.xyz = mix(outColor.xyz, vec3(0.7), 1-smoothstep(-10, 0,fragPos.y));
	outColor.w = 1.0;
}
