
#version 330

layout ( location = 0) in vec3 position;
layout ( location = 1) in vec2 uv;
layout ( location = 2) in vec3 normal;

out vec2 fragUV;
out vec3 fragNormal;
out vec3 fragPos;
out float isConstructing;
out vec4 shadowCoord;

uniform mat4 PV;
uniform mat4 M;
uniform bool isUnit;
uniform float tick;
uniform bool underConstruction;
uniform int id;
uniform mat4 depthBiasMVP;
uniform float meshBottom;
uniform float meshTop;
uniform float portionConstructed;

void main()
{
	vec3 realPos = (M*vec4(position, 1.0)).xyz;
    gl_Position = PV*vec4(realPos.x, realPos.y, realPos.z, 1);
    fragUV = vec2(uv.x, 1 - uv.y);
    fragNormal = normalize(mat3(M)*normal);
    
    fragPos = realPos;
    shadowCoord = depthBiasMVP * M *vec4(position,1.0);
}
