!cpu 6510
; ______________________________________________________________________
; ____________ DEFINES
num_lines           = $07-2
SPEED               = $02

; ____________ ZEROPAGE ADRESSES
savea               = $02
savex               = $03
savey               = $04
fade_line           = $05
fade_line_overflow  = $06
fade_ready          = $07
irq_ready           = $08
line_ready          = $09
scroll_val          = $0a
hardcopy_noetig     = $0b

; ____________ RAM ADRESSES
music_init          = $0d00
music_play          = music_init+3

vidmem0             = $8400
sprites             = $8000
charset             = $8800

scrolltext          = $5000

screen_source       = $2000
colram_source       = screen_source + $3e8
screen_source_myd   = colram_source + ($3e8*2)
colram_source_myd   = screen_source_myd + $3e8
screen_source_apo   = colram_source_myd + $3e8
colram_source_apo   = screen_source_apo + $3e8

irq_start           = $4100
; ______________________________________________________________________
; ______________________________________________ INCLUDES
*= music_init
    !bin "bunker2017.sid",,$7e

*= screen_source
    !bin "05-poop-screendata000.bin"
*= colram_source
colram_grey:
    !bin "05-poop-colordata001.bin" 
colram_colored:
    !bin "05-poop-colordata000.bin",(23*40)
    !fi 40, $0e
    !fi 40, $04
*= screen_source_myd:
    !bin "06-linelogo-screendata000.bin"
*= colram_source_myd:
    !bin "06-linelogo-colordata000.bin"
*= screen_source_apo:
    !bin "12-zombie-screendata000.bin"
*= colram_source_apo:
    !bin "12-zombie-colordata000.bin"
colram_dgrey:
    !fi $3e8, $0b
screen_text:
   ;!scr "          1         2         3
   ;!scr "0123456789012345678901234567890123456789"
    !scr "         for bunkerparty 2017           "
    !scr "                                        "
    !scr "           'apoopkacklypse'             "
    !scr "                                        "
    !scr "    aka 'for jailbird with love' ;)     "
    !scr "                                        "

*= sprites
    !bin "bun.spr",,2+(64*254)
*= sprites + (1*$40)
    !bin "nker.spr",,2+(64*254)
*= sprites + (2*$40)
    !bin "rpa.spr",,2+(64*254)
*= sprites + (3*$40)
    !bin "rt.spr",,2+(64*254)
*= sprites + (4*$40)
sprites_sterne:
    !bin "sterne.spr"
    !fi $40, 0
    
*= scrolltext
    !src "scrolltext.asm"

*= charset
    !bin "01-font_1x2+32.bin"

*= vidmem0
    !fi $3e8, $20
; ______________________________________________________________________
; ______________________________________________ CODE START
*= $0810
code_start:
    sei
    lda #$7f
    sta $dc0d
    sta $dd0d
    lda $dc0d
    lda $dd0d
    
    lda #$35
    sta $01
    
    lda #0
    jsr music_init
    
    lda $d020
    sta d020_save
    lda $d021
    sta d021_save
    
    lda #$02
    sta fade_line
    lda #$00
    sta fade_line_overflow
    sta fade_ready
    sta scroll_val
    sta hardcopy_noetig
    
    lda star_tab_x
    sta $d000+(2*4)
    lda star_tab_y
    sta $d001+(2*4)
    
    lda #$01
    sta $d01a
    
    lda #$08
    sta $d016
    
    lda #$00
    sta $d012
    lda #$1b
    sta $d011
    
    lda #<fade_irq0
    sta $fffe
    lda #>fade_irq0
    sta $ffff
    
    asl $d019
    
    cli
    
mainloop:
-
    lda fade_ready
    beq -
    
    sei
    lda #<irq_main
    sta $fffe
    lda #>irq_main
    sta $ffff
    
    lda #$00
    sta $d012
    
    lda #$1b
    sta $d011
    
    lda $dd00
    and #%11111100
    ora #%00000001
    sta $dd00
    
    asl $d019
    
    cli
    
    jsr wait_irq
    
    ldx #0
    lda #$01
-    
    sta $d800+$000,x
    sta $d800+$100,x
    sta $d800+$200,x
    sta $d800+$300,x
    inx
    bne -
    
    jsr wait_irq
    
    lda #$08
    sta $d016
    lda #$1b
    sta $d011
    
    ldy #num_lines
-    
    jsr show_one_line
    dey
    bpl -

    ldx #0
-   
    lda colram_grey+$000,x
    sta $d800+$000,x
    lda colram_grey+$100,x
    sta $d800+$100,x
    lda colram_grey+$200,x
    sta $d800+$200,x
    lda colram_grey+$2e8,x
    sta $d800+$2e8,x
    inx
    bne -
    
    jsr blend_screen
    
    jsr wait_irq
    
    jsr blend_colram
    
    jsr wait_irq

    lda #$04
    sta wait_hi
    lda #$f0
    sta wait_lo
    jsr wait_some_time
    
    jsr clear_logo
    
    jsr show_apo
    
    lda #$02
    sta wait_hi
    lda #$de
    sta wait_lo
    jsr wait_some_time
    
    jsr clear_apo
    
    lda #$00
    sta mod_screen
    lda #>vidmem0
    sta mod_screen+1
    lda #<$d800+(24*40)
    sta mod_colram
    lda #>$d800+(24*40)
    sta mod_colram+1
    
    lda #<screen_source
    sta mod_screen_source
    lda #>screen_source
    sta mod_screen_source+1
    
    lda #<colram_colored+(24*40)
    sta mod_colram_source
    lda #>colram_colored+(24*40)
    sta mod_colram_source+1
    
    ldx #0
-   
    lda colram_grey+$000,x
    sta $d800+$000,x
    lda colram_grey+$100,x
    sta $d800+$100,x
    lda colram_grey+$200,x
    sta $d800+$200,x
    lda colram_grey+$2e8,x
    sta $d800+$2e8,x
    inx
    bne -
    
    jsr wait_irq
    
    jsr blend_screen
    
    jsr wait_irq
    
    lda #$03
    sta wait_hi
    lda #$7f
    sta wait_lo
    jsr wait_some_time
    
    jsr blend_colram
    
    jsr wait_irq
    
    jsr install_scroller_irq
    
    lda #$06
    sta wait_hi
    lda #$7f
    sta wait_lo
    jsr wait_some_time
    
-        
    jsr toggle_screens
    clv
    bvc -
; ______________________________________________________________________
show_one_line:
    lda line_ready
    beq +
    
    lda #0
    sta line_ready
    rts
+
    jsr show_one_char
    jmp show_one_line
    
show_one_char:
    ldx #SPEED
- 
    jsr wait_irq   
    dex
    bne -
.xmod =*+1
    ldx #0
.mod0 =*+1    
    lda screen_text,x
    sta vidmem0+(12*40),x
    
    inc .xmod
    
    lda .xmod
    cmp #$28
    bne +
    
    lda #0
    sta .xmod
    
    clc
    lda .mod0
    adc #$28
    sta .mod0
    lda .mod0+1
    adc #0
    sta .mod0+1
    
    lda #1
    sta line_ready
    
+
    rts
; ______________________________________________________________________
wait_irq:
    lda #0
    sta irq_ready
-    
    lda irq_ready
    beq -
    rts
; ______________________________________________________________________
clear_logo:
    ldx #0
--    
    lda #$20
    sta vidmem0+(10*40),x
    sta vidmem0+(11*40),x
    sta vidmem0+(12*40),x
    ldy #SPEED
-
    jsr wait_irq
    dey
    bne -
    inx
    cpx #40
    bne --
    rts
; ______________________________________________________________________
blend_screen:
    ldy #24
---
    ldx #0
--
mod_screen_source = *+1
    lda screen_source_myd,x
mod_screen = *+1    
    sta vidmem0,x
    
    inx
    cpx #$28
    bne --
    
    clc
    lda mod_screen
    adc #$28
    sta mod_screen
    lda mod_screen+1
    adc #0
    sta mod_screen+1

    clc
    lda mod_screen_source
    adc #$28
    sta mod_screen_source
    lda mod_screen_source+1
    adc #0
    sta mod_screen_source+1
    
    ldx #SPEED
-    
    jsr wait_irq
    dex
    bne -
    
    dey
    bpl --

    rts
; ______________________________________________________________________
install_scroller_irq:
    jsr wait_irq
    
    lda #$d3+16
    sta irqline
    
    lda #<irq_scroller
    sta irqlo
    lda #>irq_scroller
    sta irqhi
    rts

; ______________________________________________________________________  
blend_colram:
    ldy #24
--
    ldx #0
-
mod_colram_source = *+1
    lda colram_source_myd+(24*40),x
mod_colram = *+1    
    sta $d800+(24*40),x
    
    inx
    cpx #$28
    bne -
    
    sec
    lda mod_colram
    sbc #$28
    sta mod_colram
    lda mod_colram+1
    sbc #0
    sta mod_colram+1

    sec
    lda mod_colram_source
    sbc #$28
    sta mod_colram_source
    lda mod_colram_source+1
    sbc #0
    sta mod_colram_source+1
    
    ldx #SPEED
-    
    jsr wait_irq
    dex
    bne -
    
    dey
    bpl --

    rts
; ______________________________________________________________________
show_apo:
    ldx #0
    
    ldy random_tab,x
    lda screen_source_apo,y
    sta vidmem0,y
    lda screen_source_apo+$100,y
    sta vidmem0+$100,y
    lda screen_source_apo+$200,y
    sta vidmem0+$200,y
    lda screen_source_apo+$300,y
    sta vidmem0+$300,y
    
    lda colram_source_apo,y
    sta $d800,y
    lda colram_source_apo+$100,y
    sta $d800+$100,y
    lda colram_source_apo+$200,y
    sta $d800+$200,y
    lda colram_source_apo+$300,y
    sta $d800+$300,y
    
    dec show_apo+1
    lda show_apo+1
    beq +
    ldx #SPEED
-
    jsr wait_irq
    dex
    bne -
    jmp show_apo
+
    rts
; ______________________________________________________________________    
clear_apo:    
    ldx #0
    
    lda #$20
    ldy random_tab,x
    sta vidmem0+$000,y
    sta vidmem0+$100,y
    sta vidmem0+$200,y
    sta vidmem0+$300,y
    
    dec clear_apo+1
    lda clear_apo+1
    beq +
    ldx #(SPEED*2)
-
    jsr wait_irq
    dex
    bne -
    jmp clear_apo
+    
    rts
; ______________________________________________________________________

clear_screen:
    ldy #22
.lalaloop    
    ldx #$27
    lda #$20
.mblabla    
    sta vidmem0,x
    dex
    bpl .mblabla
    ldx #SPEED
-
    jsr wait_irq
    dex
    bne -
    
    clc
    lda .mblabla+1
    adc #$28
    sta .mblabla+1
    lda .mblabla+2
    adc #0
    sta .mblabla+2
    
    dey
    bne .lalaloop
    
    lda #<vidmem0
    sta .mblabla+1
    lda #>vidmem0
    sta .mblabla+2
    
    ldx #0
-   
    lda colram_dgrey+$000,x
    sta $d800+$000,x
    lda colram_dgrey+$100,x
    sta $d800+$100,x
    lda colram_dgrey+$200,x
    sta $d800+$200,x
    lda colram_dgrey+$2e8-(2*40),x
    sta $d800+$2e8-(2*40),x
    inx
    bne -    
    
    rts
; ______________________________________________________________________
hardcopy:

.xmoda = *+1    
    lda scrolltext
    cmp #$ff
    bne +
    lda #<scrolltext
    sta .xmoda
    lda #>scrolltext
    sta .xmoda+1
    lda #$20
+    
    sta vidmem0+(23*40)+39
    clc
    lda .xmoda
    adc #01
    sta .xmoda
    bcc +
    inc .xmoda+1
+    
    ldx #$00
-    
    lda vidmem0+(23*40)+1,x
    sta vidmem0+(23*40),x
    ora #$40
    sta vidmem0+(24*40),x
    
    inx
    cpx #39
    bne -
    
    lda #0
    sta hardcopy_noetig
    rts
; ______________________________________________________________________  
toggle_screens:
    lda #21
    sta blend_colram+1
    sta blend_screen+1

    ldx current_screen
    
    lda scr_srcs_lo,x
    sta mod_screen_source
    lda scr_srcs_hi,x
    sta mod_screen_source+1
    
    lda col_srcs_lo,x
    sta mod_colram_source
    lda col_srcs_hi,x
    sta mod_colram_source+1
    
    lda #0
    sta mod_screen
    lda #>vidmem0
    sta mod_screen+1
    
    lda #<($d800+(21*40))
    sta mod_colram
    lda #>($d800+(21*40))
    sta mod_colram+1
    
    jsr clear_screen
    
    lda #$01
    sta wait_hi
    lda #$7f
    sta wait_lo
    jsr wait_some_time
    
    jsr blend_screen
    
    jsr wait_some_time
    
    jsr blend_colram
    
    lda #$06
    sta wait_hi
    lda #$7f
    sta wait_lo
    jsr wait_some_time
    
    inc current_screen

    lda current_screen
    cmp #3
    bne +
    lda #0
    sta current_screen
+
    rts

current_screen:
    !byte 0
scr_srcs_lo:
    !byte <screen_source_apo, <screen_source_myd, <screen_source
scr_srcs_hi:
    !byte >screen_source_apo, >screen_source_myd, >screen_source
col_srcs_lo:
    !byte <colram_source_apo+(21*40), <colram_source_myd+(21*40), <colram_colored+(21*40)
col_srcs_hi:
    !byte >colram_source_apo+(21*40), >colram_source_myd+(21*40), >colram_colored+(21*40)
; ______________________________________________________________________
wait_some_time:
wait_hi =*+1
    ldx #$00
--
wait_lo =*+1
    ldy #$00
-    
    jsr wait_irq
    dey
    bne -
    dex
    bne --
    rts
; ______________________________________________________________________
colram_shift:
.cols_ct =*+1
    lda #3
    beq +
    dec .cols_ct
    rts
+    
    lda #3
    sta .cols_ct
.cols_x =*+1
    ldx #<(colram_tab_end-colram_tab1)-1
    
    lda colram_tab1,x
    sta $d800+(23*40)
    lda colram_tab2,x
    sta $d800+(24*40)
    
    ldy #$26
-    
    lda $d800+(23*40),y
    sta $d800+(23*40)+1,y
    lda $d800+(24*40),y
    sta $d800+(24*40)+1,y
    dey
    bpl -
    
    dec .cols_x
    lda .cols_x
    cmp #$ff
    bne +
    lda #<(colram_tab_end-colram_tab1)-1
    sta .cols_x
+    
    rts
; ______________________________________________________________________    
END_CODE:
; ______________________________________________________________________
*= irq_start
fade_irq0:
    sta savea
    stx savex
    sty savey
    
    lda #$00
    sta $d020
    sta $d021
    
    lda #%01011011
    ora fade_line_overflow
    sta $d011
    
    lda #%00011000
    sta $d016
    
    lda #<fade_irq1
    sta $fffe
    lda #>fade_irq1
    sta $ffff
    
    lda fade_line
    sta $d012
    
    asl $d019
    
    lda savea
    ldx savex
    ldy savey
    rti

fade_irq1:
    sta savea
    stx savex
    sty savey
    
    jsr fake
    jsr fake
    bit $ea
    nop
    nop
    
d021_save =*+1     
    lda #0   
    sta $d021
d020_save =*+1    
    lda #0
    sta $d020
    
    lda #$1b
    sta $d011
    lda #$08
    sta $d016
    
    clc
    lda fade_line
    adc #$02
    sta fade_line
    bcc +
    
    lda #%10000000
    sta fade_line_overflow
    
    lda #$20
    sta enable_check_fade_in_ready
+
enable_check_fade_in_ready
    bit check_fade_in_ready
    
    lda #<fade_irq0
    sta $fffe
    lda #>fade_irq0
    sta $ffff
    
    lda #$00
    sta $d012
    
    asl $d019
    
    lda savea
    ldx savex
    ldy savey
    rti
fake:
    rts

check_fade_in_ready:
    lda $d012
    cmp #$21
    beq +
    rts
+
    lda #$01
    sta fade_ready
    rts
; ______________________________________________________________________
!align 255,0
irq_main:
    sta savea
    stx savex
    sty savey
    
    lda #$00
    sta $d020
    sta $d021 
    
    lda music_init+$4B
    cmp #$02
    bne +
    lda #$07
    sta $d020
    sta $d021
+
    lda #%00010100
    sta $d018
    
    lda hardcopy_noetig
    beq +
    jsr hardcopy
+
    jsr music_play
    
irqlo = *+1    
    lda #<irq_main
    sta $fffe
irqhi = *+1    
    lda #>irq_main
    sta $ffff
    
    lda #$01
    sta irq_ready
    
irqline = *+1    
    lda #$00
    sta $d012
    
    lda #$1b
    sta $d011
    
    asl $d019
    
    lda savea
    ldx savex
    ldy savey
    rti
    
irq_scroller:
    sta savea
    stx savex
    sty savey
    
    clc
    lda $d012
    adc #$28
    sta .kack
    
    lda #%00010010
    sta $d018
    
    lda $d016
    and #%11110000
    ora scroll_val
    sta $d016
    
    sec
    lda scroll_val
    sbc #$02
    sta scroll_val
    bcs +
    lda #7
    sta scroll_val
    
    lda #1
    sta hardcopy_noetig
+
    
.kack = *+1    
    lda #0
-    
    cmp $d012
    bne -
    
    lda #$08
    sta $d016
    
    lda #$00
    sta vidmem0 + $03f8
    lda #$01
    sta vidmem0 + $03f9
    lda #$02
    sta vidmem0 + $03fa
    lda #$03
    sta vidmem0 + $03fb

.x0 = *+1    
    lda #$20
    sta $d000
.x1 = *+1        
    lda #$20+(1*48)
    sta $d000+2
.x2 = *+1
    lda #$20+(2*48)
    sta $d000+4
.x3 = *+1        
    lda #$20+(3*48)
    sta $d000+6

.y0 =*+1    
    lda #$50
    sta $d001
.y1 =*+1
    lda #$50
    sta $d001+2
.y2 =*+1    
    lda #$50
    sta $d001+4
.y3 =*+1    
    lda #$50
    sta $d001+6
    
sprite_color =*+1    
    lda #$01
    sta $d027+0
    sta $d027+1
    sta $d027+2
    sta $d027+3
    
    lda #$01
    sta $d027+4
    
    lda #%00001111
    sta $d017
    sta $d01d
    lda #%00011111
    sta $d015
.taby_index =*+1
    ldx #0
    
    lda table_y,x
    sta .y0 
    sta .y1 
    sta .y2 
    sta .y3 
    
    inc .taby_index
.bl0
    inc .x0
.bl1    
    inc .x1
.bl2    
    inc .x2
.bl3    
    inc .x3
    
    lda .x3
    cmp #$ff
    bne +
    lda #$ce
    sta .bl0
    sta .bl1
    sta .bl2
    sta .bl3
+   
    lda .x0
    cmp #$30
    bne +
    lda #$ee
    sta .bl0
    sta .bl1
    sta .bl2
    sta .bl3
+    
    lda music_init+$4c
    cmp #$03
    bne +
    lda sprite_color
    eor #($01 XOR $04)
    sta sprite_color
+    
    jsr colram_shift
    
    lda #$05
    sta $d026
    lda #$0b
    sta $d025
    
    lda #%00010000
    sta $d01c
    
    jsr anim_star
      
    lda #<irq_main
    sta $fffe
    lda #>irq_main
    sta $ffff
    
    lda #$01
    sta irq_ready
    
    lda #%00010100
    sta $d018
    
    lda #$00
    sta $d012
    
    lda #$1b
    sta $d011
    
    asl $d019
    
    lda savea
    ldx savex
    ldy savey
    rti
; ______________________________________________________________________
anim_star:
    lda star_done
    bne .star_done
    
.anim_speed =*+1    
    lda #4
    beq .exec_anim
    dec .anim_speed
    rts
.exec_anim
    lda #4
    sta .anim_speed
    jsr .the_anim
    rts
.star_done
    lda #$3f
    beq +
    dec .star_done+1
    rts  
+    
    lda #$3f
    sta .star_done+1
    lda #0
    sta star_done
    jsr pos_star
    rts
star_done:
    !byte $00
.the_anim    
.xpoint =*+1
    ldx #0

    lda sterne_anim_tab,x
    sta vidmem0 + $03fc
    
    inc .xpoint
    lda .xpoint
    cmp #7
    bne +
    lda #0
    sta .xpoint
    lda #1
    sta star_done
+    
    rts
    
pos_star:
    ldx #31
    
    lda star_tab_x,x
    sta $d000+8
    lda star_tab_y,x
    sta $d001+8
    lda star_tab_d010,x
    beq +
    lda #%00010000
    !byte $2c
+    
    lda #0
    sta $d010
    
    dec pos_star+1
    lda pos_star+1
    cmp #$ff
    beq +
    rts  
+
    lda #31
    sta pos_star+1
    rts
; ______________________________________________________________________
!align 255,0
table_y:
!byte 120,109,98,89,81,74,69,67,66,67,71,76,82,90,98,107
!byte 115,123,130,135,139,142,142,141,138,134,128,122,115,108,101,95
!byte 91,87,86,86,88,92,97,105,113,122,132,142,152,160,168,173
!byte 177,179,179,177,173,166,159,149,140,129,119,109,100,92,86,82
!byte 79,79,80,83,88,94,100,108,115,122,128,133,137,139,139,138
!byte 135,130,124,117,110,102,94,87,81,76,73,72,72,75,80,86
!byte 94,104,114,125,135,146,155,163,170,174,177,177,176,172,167,160
!byte 152,143,133,124,116,108,102,97,93,92,92,95,98,103,109,116
!byte 123,130,136,141,144,147,147,146,142,137,131,123,115,106,96,87
!byte 79,72,67,63,62,62,65,69,76,84,93,104,114,125,135,145
!byte 153,159,164,167,167,166,163,158,152,145,137,129,122,115,109,104
!byte 101,100,100,102,106,111,117,124,131,139,145,151,156,159,160,160
!byte 157,153,147,139,130,120,110,99,90,80,73,66,62,60,60,62
!byte 66,71,79,87,97,107,117,126,134,142,147,151,153,153,152,148
!byte 144,138,131,124,117,111,105,101,98,97,97,100,104,109,116,124
!byte 132,141,149,157,163,168,172,173,172,170,165,158,150,141,130,120
; ______________________________________________________________________
!align 255,0
random_tab:
  !byte 208, 029, 189, 225, 145, 054, 196, 045
  !byte 091, 136, 126, 165, 236, 103, 128, 106
  !byte 019, 217, 026, 174, 032, 021, 245, 043
  !byte 147, 059, 134, 255, 206, 101, 068, 241
  !byte 016, 015, 035, 067, 239, 024, 227, 011
  !byte 040, 042, 215, 117, 139, 052, 100, 137
  !byte 243, 231, 049, 232, 234, 164, 074, 214
  !byte 194, 072, 150, 030, 143, 069, 046, 051
  !byte 033, 114, 082, 080, 075, 183, 003, 056
  !byte 159, 066, 177, 124, 209, 009, 249, 154
  !byte 031, 093, 008, 077, 251, 004, 220, 195
  !byte 211, 250, 235, 017, 071, 120, 237, 138
  !byte 254, 070, 109, 104, 187, 125, 155, 110
  !byte 179, 127, 204, 170, 178, 006, 153, 201
  !byte 229, 212, 146, 240, 084, 047, 028, 228
  !byte 115, 092, 007, 148, 210, 224, 197, 144
  !byte 246, 090, 089, 062, 001, 161, 121, 184
  !byte 157, 172, 087, 050, 002, 005, 058, 198
  !byte 036, 149, 108, 168, 248, 132, 173, 041
  !byte 095, 202, 158, 186, 166, 130, 116, 238
  !byte 203, 111, 076, 044, 020, 140, 012, 023
  !byte 105, 160, 099, 112, 247, 022, 083, 034
  !byte 135, 025, 244, 096, 185, 060, 053, 102
  !byte 061, 167, 233, 057, 131, 119, 190, 085
  !byte 223, 252, 182, 129, 107, 226, 013, 253
  !byte 133, 010, 200, 169, 063, 181, 175, 221
  !byte 207, 171, 037, 141, 205, 098, 018, 055
  !byte 113, 027, 222, 219, 065, 152, 156, 039
  !byte 123, 142, 038, 081, 199, 162, 216, 078
  !byte 192, 118, 191, 014, 094, 230, 218, 073
  !byte 048, 122, 088, 242, 188, 176, 086, 163
  !byte 000, 180, 213, 079, 151, 064, 097, 193
; ______________________________________________________________________
colram_tab1:
    !fi 60, $0e
    !byte $0c, $07, $01, $07, $0c
colram_tab_end:    
colram_tab2:
    !fi 60, $04
    !byte $05, $0d, $01, $0d, $05
; ______________________________________________________________________
star_tab_x:
!byte 91, 46, 61, 230, 214, 182, 234, 254, 208, 33, 31, 48, 193, 148, 115, 195, 201, 26, 111, 42, 14, 216, 138, 60, 151, 141, 36, 37, 190, 106, 26, 150
star_tab_y:
!byte 79, 105, 174, 84, 147, 58, 52, 143, 175, 57, 126, 198, 207, 189, 145, 186, 155, 150, 165, 85, 122, 93, 107, 116, 95, 193, 150, 85, 218, 119, 82, 156
star_tab_d010:
!byte 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0
sterne_anim_tab:
    !byte $07, $06, $05, $04, $05, $06, $07
END_DATA:
