/*
 * Decompiled with CFR 0.152.
 */
package com.iceberg.graphics3d;

import com.iceberg.graphics3d.Graphics3D;
import com.iceberg.graphics3d.RenderObject;
import com.iceberg.graphics3d.Texture;
import com.iceberg.graphics3d.Texturing;
import com.iceberg.graphics3d.Vertex;
import com.iceberg.math.MathUtils;
import com.iceberg.math.Vector3D;

public class Polygon3V
extends RenderObject {
    public short nx;
    public short ny;
    public short nz;
    public Vertex a;
    public Vertex b;
    public Vertex c;
    public byte au;
    public byte av;
    public byte bu;
    public byte bv;
    public byte cu;
    public byte cv;
    private Graphics3D g3d;
    public short tex = 0;
    public byte mode = 0;

    public Polygon3V(Vertex vertex, byte by, byte by2, Vertex vertex2, byte by3, byte by4, Vertex vertex3, byte by5, byte by6) {
        this.a = vertex;
        this.au = by;
        this.av = by2;
        this.b = vertex2;
        this.bu = by3;
        this.bv = by4;
        this.c = vertex3;
        this.cu = by5;
        this.cv = by6;
        Vector3D vector3D = new Vector3D(vertex.x, vertex.y, vertex.z);
        Vector3D vector3D2 = new Vector3D(vertex2.x, vertex2.y, vertex2.z);
        Vector3D vector3D3 = new Vector3D(vertex3.x, vertex3.y, vertex3.z);
        Vector3D vector3D4 = MathUtils.createNormal(vector3D, vector3D2, vector3D3);
        this.nx = (short)vector3D4.x;
        this.ny = (short)vector3D4.y;
        this.nz = (short)vector3D4.z;
    }

    public boolean isVisible(int n, int n2, int n3, int n4) {
        this.sz = this.a.rz;
        if (this.c.rz < this.sz) {
            this.sz = this.c.rz;
        }
        if (this.b.rz < this.sz) {
            this.sz = this.b.rz;
        }
        if (this.sz > 0) {
            return false;
        }
        this.sz = (this.a.rz + this.b.rz + this.c.rz) * 4 / 3;
        if (this.a.sx < n && this.b.sx < n && this.c.sx < n) {
            return false;
        }
        if (this.a.sx > n3 && this.b.sx > n3 && this.c.sx > n3) {
            return false;
        }
        if (this.a.sy < n2 && this.b.sy < n2 && this.c.sy < n2) {
            return false;
        }
        if (this.a.sy > n4 && this.b.sy > n4 && this.c.sy > n4) {
            return false;
        }
        if (-Graphics3D.drawDist > this.sz) {
            return false;
        }
        return (this.a.sx - this.b.sx) * (this.b.sy - this.c.sy) + this.a.sx >= (this.a.sy - this.b.sy) * (this.b.sx - this.c.sx);
    }

    public void render(Graphics3D graphics3D, Texture texture) {
        if (texture.perspectiveCorrection && (Polygon3V.size(this.a.sx, this.b.sx, this.c.sx) > 32 || Polygon3V.size(this.a.sy, this.b.sy, this.c.sy) > 40)) {
            int n = 24;
            if (this.ny > 4000 || this.ny < -4000) {
                n = 666666666;
            }
            Texturing.paintPers(graphics3D, texture, this.a, this.au & 0xFF, this.av & 0xFF, this.b, this.bu & 0xFF, this.bv & 0xFF, this.c, this.cu & 0xFF, this.cv & 0xFF, 1, this.mode, n);
        } else {
            Texturing.paintAffine(graphics3D, texture, this.a, this.au & 0xFF, this.av & 0xFF, this.b, this.bu & 0xFF, this.bv & 0xFF, this.c, this.cu & 0xFF, this.cv & 0xFF, 1, this.mode, 1);
        }
    }

    private static final int size(int n, int n2, int n3) {
        int n4;
        if (n2 < n) {
            n4 = n;
            n = n2;
            n2 = n4;
        }
        if (n3 < n) {
            n4 = n3;
            n3 = n;
            n = n4;
        }
        if (n3 < n2) {
            n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        return n3 - n;
    }
}

