/*
 * Decompiled with CFR 0.152.
 */
package com.iceberg.graphics3d;

import com.iceberg.graphics3d.Graphics3D;
import com.iceberg.graphics3d.RenderObject;
import com.iceberg.graphics3d.Texture;
import com.iceberg.graphics3d.Texturing;
import com.iceberg.graphics3d.Vertex;
import com.iceberg.math.MathUtils;
import com.iceberg.math.Vector3D;

public class Polygon4V
extends RenderObject {
    public short nx;
    public short ny;
    public short nz;
    public Vertex a;
    public Vertex b;
    public Vertex c;
    public Vertex d;
    public byte au;
    public byte av;
    public byte bu;
    public byte bv;
    public byte cu;
    public byte cv;
    public byte du;
    public byte dv;
    private Graphics3D g3d;
    public short tex = 0;
    public byte mode = 0;

    public Polygon4V(Vertex vertex, byte by, byte by2, Vertex vertex2, byte by3, byte by4, Vertex vertex3, byte by5, byte by6, Vertex vertex4, byte by7, byte by8) {
        this.a = vertex;
        this.au = by;
        this.av = by2;
        this.b = vertex2;
        this.bu = by3;
        this.bv = by4;
        this.c = vertex3;
        this.cu = by5;
        this.cv = by6;
        this.d = vertex4;
        this.du = by7;
        this.dv = by8;
        Vector3D vector3D = new Vector3D(vertex.x, vertex.y, vertex.z);
        Vector3D vector3D2 = new Vector3D(vertex2.x, vertex2.y, vertex2.z);
        Vector3D vector3D3 = new Vector3D(vertex4.x, vertex4.y, vertex4.z);
        Vector3D vector3D4 = MathUtils.createNormal(vector3D, vector3D2, vector3D3);
        this.nx = (short)vector3D4.x;
        this.ny = (short)vector3D4.y;
        this.nz = (short)vector3D4.z;
    }

    public boolean isVisible(int n, int n2, int n3, int n4) {
        this.sz = this.a.rz;
        if (this.d.rz < this.sz) {
            this.sz = this.d.rz;
        }
        if (this.c.rz < this.sz) {
            this.sz = this.c.rz;
        }
        if (this.b.rz < this.sz) {
            this.sz = this.b.rz;
        }
        if (this.sz > 0) {
            return false;
        }
        this.sz = this.a.rz + this.b.rz + this.c.rz + this.d.rz;
        if ((this.a.sx - this.b.sx) * (this.b.sy - this.d.sy) <= (this.a.sy - this.b.sy) * (this.b.sx - this.d.sx) && (this.c.sx - this.d.sx) * (this.d.sy - this.b.sy) <= (this.c.sy - this.d.sy) * (this.d.sx - this.b.sx)) {
            return false;
        }
        if (this.a.sx < n && this.b.sx < n && this.c.sx < n && this.d.sx < n) {
            return false;
        }
        if (this.a.sx > n3 && this.b.sx > n3 && this.c.sx > n3 && this.d.sx > n3) {
            return false;
        }
        if (this.a.sy < n2 && this.b.sy < n2 && this.c.sy < n2 && this.d.sy < n2) {
            return false;
        }
        if (this.a.sy > n4 && this.b.sy > n4 && this.c.sy > n4 && this.d.sy > n4) {
            return false;
        }
        return -Graphics3D.drawDist <= this.sz;
    }

    public void render(Graphics3D graphics3D, Texture texture) {
        this.render(graphics3D, texture, this.mode);
    }

    public void render(Graphics3D graphics3D, Texture texture, byte by) {
        if (texture.perspectiveCorrection && (this.size(this.a.sx, this.b.sx, this.c.sx, this.d.sx) > 30 || this.size(this.a.sy, this.b.sy, this.c.sy, this.d.sy) > 30)) {
            int n = 24;
            if (this.ny > 4000 || this.ny < -4000) {
                n = 666666666;
            }
            Texturing.paintPers(graphics3D, texture, this.a, this.au & 0xFF, this.av & 0xFF, this.b, this.bu & 0xFF, this.bv & 0xFF, this.d, this.du & 0xFF, this.dv & 0xFF, 1, by, n);
            Texturing.paintPers(graphics3D, texture, this.b, this.bu & 0xFF, this.bv & 0xFF, this.c, this.cu & 0xFF, this.cv & 0xFF, this.d, this.du & 0xFF, this.dv & 0xFF, 1, by, n);
        } else {
            Texturing.paintAffine(graphics3D, texture, this.a, this.au & 0xFF, this.av & 0xFF, this.b, this.bu & 0xFF, this.bv & 0xFF, this.d, this.du & 0xFF, this.dv & 0xFF, 1, by, 1);
            Texturing.paintAffine(graphics3D, texture, this.b, this.bu & 0xFF, this.bv & 0xFF, this.c, this.cu & 0xFF, this.cv & 0xFF, this.d, this.du & 0xFF, this.dv & 0xFF, 1, by, 1);
        }
    }

    private int size(int n, int n2, int n3, int n4) {
        int n5;
        if (n2 < n) {
            n5 = n;
            n = n2;
            n2 = n5;
        }
        if (n3 < n) {
            n5 = n3;
            n3 = n;
            n = n5;
        }
        if (n3 < n2) {
            n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        int n6 = n < n4 ? n : n4;
        int n7 = n3 > n4 ? n3 : n4;
        return n7 - n6;
    }
}

