/*
 * Decompiled with CFR 0.152.
 */
package com.gameutils.mycanvas;

import javax.microedition.lcdui.Canvas;

public class Keyboard {
    public final int LEFT;
    public final int RIGHT;
    public final int UP;
    public final int DOWN;
    public final int FIRE;
    public final int SOFT_LEFT;
    public final int SOFT_RIGHT;
    private boolean up;
    private boolean down;
    private boolean left;
    private boolean right;
    private boolean fire;
    private boolean key7;
    private boolean key9;
    private boolean key1;
    private boolean key3;

    Keyboard(Canvas canvas) {
        if (Keyboard.isSelect(canvas, -26)) {
            this.LEFT = -61;
            this.RIGHT = -62;
            this.DOWN = -60;
            this.UP = -59;
            this.FIRE = -26;
            this.SOFT_LEFT = -1;
            this.SOFT_RIGHT = -4;
        } else if (Keyboard.isSelect(canvas, -20)) {
            this.LEFT = -2;
            this.RIGHT = -5;
            this.DOWN = -6;
            this.UP = -1;
            this.FIRE = -20;
            this.SOFT_LEFT = -21;
            this.SOFT_RIGHT = -22;
        } else {
            this.LEFT = -3;
            this.RIGHT = -4;
            this.DOWN = -2;
            this.UP = -1;
            this.FIRE = -5;
            this.SOFT_LEFT = -6;
            this.SOFT_RIGHT = -7;
        }
        this.reset();
    }

    private static boolean isSelect(Canvas canvas, int n) {
        try {
            return canvas.getKeyName(n).toUpperCase().indexOf("SELECT") != -1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void reset() {
        this.key3 = false;
        this.key1 = false;
        this.key9 = false;
        this.key7 = false;
        this.fire = false;
        this.right = false;
        this.left = false;
        this.down = false;
        this.up = false;
    }

    void keyPressed(int n) {
        if (n == 50 || n == this.UP) {
            this.up = true;
        } else if (n == 56 || n == this.DOWN) {
            this.down = true;
        } else if (n == 52 || n == this.LEFT) {
            this.left = true;
        } else if (n == 54 || n == this.RIGHT) {
            this.right = true;
        } else if (n == 53 || n == this.FIRE) {
            this.fire = true;
        } else if (n == 49) {
            this.key1 = true;
        } else if (n == 51) {
            this.key3 = true;
        } else if (n == 55) {
            this.key7 = true;
        } else if (n == 57) {
            this.key9 = true;
        }
    }

    void keyReleased(int n) {
        if (n == 50 || n == this.UP) {
            this.up = false;
        } else if (n == 56 || n == this.DOWN) {
            this.down = false;
        } else if (n == 52 || n == this.LEFT) {
            this.left = false;
        } else if (n == 54 || n == this.RIGHT) {
            this.right = false;
        } else if (n == 53 || n == this.FIRE) {
            this.fire = false;
        } else if (n == 49) {
            this.key1 = false;
        } else if (n == 51) {
            this.key3 = false;
        } else if (n == 55) {
            this.key7 = false;
        } else if (n == 57) {
            this.key9 = false;
        }
    }

    public boolean up() {
        return this.up;
    }

    public boolean down() {
        return this.down;
    }

    public boolean left() {
        return this.left;
    }

    public boolean right() {
        return this.right;
    }

    public boolean fire() {
        return this.fire;
    }

    public boolean key1() {
        return this.key1;
    }

    public boolean key3() {
        return this.key3;
    }

    public boolean key7() {
        return this.key7;
    }

    public boolean key9() {
        return this.key9;
    }

    public boolean isUp(int n) {
        return n == 50 || n == this.UP;
    }

    public boolean isDown(int n) {
        return n == 56 || n == this.DOWN;
    }

    public boolean isleft(int n) {
        return n == 52 || n == this.LEFT;
    }

    public boolean isRight(int n) {
        return n == 54 || n == this.RIGHT;
    }

    public boolean isFire(int n) {
        return n == 53 || n == this.FIRE;
    }
}

