/*
 * Decompiled with CFR 0.152.
 */
package com.iceberg.collide;

import com.iceberg.collide.Ray;
import com.iceberg.graphics3d.Mesh;
import com.iceberg.graphics3d.Polygon3V;
import com.iceberg.graphics3d.Polygon4V;
import com.iceberg.graphics3d.RenderObject;
import com.iceberg.graphics3d.Vertex;
import com.iceberg.math.MathUtils;
import com.iceberg.math.Vector3D;

public class RayCast {
    private static final Vector3D colPoint = new Vector3D();
    private static final Vector3D v1 = new Vector3D();
    private static final Vector3D v2 = new Vector3D();
    private static final Vector3D v3 = new Vector3D();
    private static final Vector3D v4 = new Vector3D();
    private static final Vector3D normal = new Vector3D();

    public static boolean isRayAABBCollision(Ray ray, int n, int n2, int n3, int n4) {
        Vector3D vector3D = ray.getStart();
        Vector3D vector3D2 = ray.getDir();
        int n5 = Math.min(vector3D.x, vector3D.x + vector3D2.x);
        int n6 = Math.min(vector3D.z, vector3D.z + vector3D2.z);
        int n7 = Math.max(vector3D.x, vector3D.x + vector3D2.x);
        int n8 = Math.max(vector3D.z, vector3D.z + vector3D2.z);
        return n5 <= n2 && n6 <= n4 && n7 >= n && n8 >= n3;
    }

    public static void rayCast(Mesh mesh, Ray ray) {
        RenderObject[] renderObjectArray = mesh.getPolygons();
        Vector3D vector3D = ray.start;
        Vector3D vector3D2 = ray.dir;
        int n = vector3D.x;
        int n2 = vector3D.y;
        int n3 = vector3D.z;
        int n4 = n + vector3D2.x;
        int n5 = n2 + vector3D2.y;
        int n6 = n3 + vector3D2.z;
        int n7 = RayCast.min(n, n4);
        int n8 = RayCast.min(n2, n5);
        int n9 = RayCast.min(n3, n6);
        int n10 = RayCast.max(n, n4);
        int n11 = RayCast.max(n2, n5);
        int n12 = RayCast.max(n3, n6);
        int n13 = vector3D2.length();
        for (int i = 0; i < renderObjectArray.length; ++i) {
            int n14;
            Vertex vertex;
            Vertex vertex2;
            Vertex vertex3;
            RenderObject renderObject = renderObjectArray[i];
            int n15 = Integer.MAX_VALUE;
            if (renderObject instanceof Polygon3V) {
                Polygon3V polygon3V = (Polygon3V)renderObject;
                vertex3 = polygon3V.a;
                vertex2 = polygon3V.b;
                vertex = polygon3V.c;
                if (RayCast.max(vertex3.x, vertex2.x, vertex.x) < n7 || RayCast.min(vertex3.x, vertex2.x, vertex.x) > n10 || RayCast.max(vertex3.z, vertex2.z, vertex.z) < n9 || RayCast.min(vertex3.z, vertex2.z, vertex.z) > n12 || RayCast.max(vertex3.y, vertex2.y, vertex.y) < n8 || RayCast.min(vertex3.y, vertex2.y, vertex.y) > n11) continue;
                normal.set(polygon3V.nx, polygon3V.ny, polygon3V.nz);
                v1.set(vertex3.x, vertex3.y, vertex3.z);
                v2.set(vertex2.x, vertex2.y, vertex2.z);
                v3.set(vertex.x, vertex.y, vertex.z);
                n15 = RayCast.rayCast(v1, v2, v3, normal, vector3D, vector3D2, colPoint);
            } else if (renderObject instanceof Polygon4V) {
                Polygon4V polygon4V = (Polygon4V)renderObject;
                vertex3 = polygon4V.a;
                vertex2 = polygon4V.b;
                vertex = polygon4V.c;
                Vertex vertex4 = polygon4V.d;
                if (RayCast.max(vertex3.x, vertex2.x, vertex.x, vertex4.x) < n7 || RayCast.min(vertex3.x, vertex2.x, vertex.x, vertex4.x) > n10 || RayCast.max(vertex3.z, vertex2.z, vertex.z, vertex4.z) < n9 || RayCast.min(vertex3.z, vertex2.z, vertex.z, vertex4.z) > n12 || RayCast.max(vertex3.y, vertex2.y, vertex.y, vertex4.y) < n8 || RayCast.min(vertex3.y, vertex2.y, vertex.y, vertex4.y) > n11) continue;
                normal.set(polygon4V.nx, polygon4V.ny, polygon4V.nz);
                v1.set(vertex3.x, vertex3.y, vertex3.z);
                v2.set(vertex2.x, vertex2.y, vertex2.z);
                v3.set(vertex.x, vertex.y, vertex.z);
                v4.set(vertex4.x, vertex4.y, vertex4.z);
                n15 = RayCast.rayCast(v1, v2, v3, v4, normal, vector3D, vector3D2, colPoint);
            }
            if (n15 == Integer.MAX_VALUE || (n14 = n13 * n15 >> 12) >= ray.distance) continue;
            ray.set(true, n14, colPoint, renderObject);
        }
    }

    private static final int max(int n, int n2, int n3, int n4) {
        return RayCast.max(RayCast.max(n, n2), RayCast.max(n3, n4));
    }

    private static final int min(int n, int n2, int n3, int n4) {
        return RayCast.min(RayCast.min(n, n2), RayCast.min(n3, n4));
    }

    private static final int max(int n, int n2, int n3) {
        return RayCast.max(n, RayCast.max(n2, n3));
    }

    private static final int min(int n, int n2, int n3) {
        return RayCast.min(n, RayCast.min(n2, n3));
    }

    private static final int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    private static final int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    private static int rayCast(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4, Vector3D vector3D5, Vector3D vector3D6, Vector3D vector3D7) {
        vector3D7.set(vector3D5.x - vector3D.x, vector3D5.y - vector3D.y, vector3D5.z - vector3D.z);
        int n = vector3D6.dot(vector3D4) >> 12;
        if (n <= 0) {
            return Integer.MAX_VALUE;
        }
        n = -vector3D7.dot(vector3D4) / n;
        if (n < 0 || n > 4096) {
            return Integer.MAX_VALUE;
        }
        vector3D7.set(vector3D5.x + (vector3D6.x * n >> 12), vector3D5.y + (vector3D6.y * n >> 12), vector3D5.z + (vector3D6.z * n >> 12));
        if (MathUtils.isPointOnPolygon(vector3D7, vector3D, vector3D2, vector3D3, vector3D4)) {
            return n;
        }
        return Integer.MAX_VALUE;
    }

    private static int rayCast(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4, Vector3D vector3D5, Vector3D vector3D6, Vector3D vector3D7, Vector3D vector3D8) {
        vector3D8.set(vector3D6.x - vector3D.x, vector3D6.y - vector3D.y, vector3D6.z - vector3D.z);
        int n = vector3D7.dot(vector3D5) >> 12;
        if (n <= 0) {
            return Integer.MAX_VALUE;
        }
        n = -vector3D8.dot(vector3D5) / n;
        if (n < 0 || n > 4096) {
            return Integer.MAX_VALUE;
        }
        vector3D8.set(vector3D6.x + (vector3D7.x * n >> 12), vector3D6.y + (vector3D7.y * n >> 12), vector3D6.z + (vector3D7.z * n >> 12));
        if (MathUtils.isPointOnPolygon(vector3D8, vector3D, vector3D2, vector3D3, vector3D4, vector3D5)) {
            return n;
        }
        return Integer.MAX_VALUE;
    }
}

