/*
 * Decompiled with CFR 0.152.
 */
package com.iceberg.graphics3d;

import com.iceberg.graphics3d.Graphics3D;
import com.iceberg.graphics3d.RenderObject;
import com.iceberg.graphics3d.Texture;
import com.iceberg.graphics3d.Vertex;
import com.iceberg.math.Matrix;

public class Sprite
extends RenderObject {
    public static final int fp = 10;
    public static final int FP = 1024;
    private Texture texture;
    private Vertex pos = new Vertex();
    private Vertex size = new Vertex();
    private boolean mirX = false;
    private boolean mirY = false;
    public boolean lowq = true;
    private int scale;
    private int offsetX = 0;
    private int offsetY = 0;
    public static int alpha = 256;
    public boolean fade = true;

    public Sprite(Texture texture) {
        this(texture, 1, 0, 0, 0);
    }

    public Sprite(Texture texture, int n, int n2, int n3, int n4) {
        this.texture = texture;
        this.scale = n;
        this.pos.set(n2, n3, n4);
    }

    public void setTexture(Texture texture) {
        this.texture = texture;
        this.scale = this.scale;
    }

    public void destroy() {
        this.texture = null;
        this.pos = null;
        this.size = null;
    }

    public void setOffset(int n, int n2) {
        this.offsetX = n;
        this.offsetY = n2;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public void setAlpha(int n) {
        alpha = n;
    }

    public int getScale() {
        return this.scale;
    }

    public void setMirror(boolean bl, boolean bl2) {
        this.mirX = bl;
        this.mirY = bl2;
    }

    public boolean isMirX() {
        return this.mirX;
    }

    public boolean isMirY() {
        return this.mirY;
    }

    public void mirrorX() {
        this.mirX = !this.mirX;
    }

    public void mirrorY() {
        this.mirY = !this.mirY;
    }

    public void setPosition(int n, int n2, int n3) {
        this.pos.set(n, n2, n3);
    }

    public Vertex getPosition() {
        return this.pos;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public int getWidth() {
        return this.texture.w * this.scale;
    }

    public int getHeight() {
        return this.texture.h * this.scale;
    }

    public boolean isVisible(int n, int n2, int n3, int n4) {
        this.sz = this.pos.rz * 4;
        if (this.pos.rz > this.getWidth() + this.getHeight()) {
            return false;
        }
        if (this.pos.sx >= n3 || this.pos.sy >= n4) {
            return false;
        }
        return this.size.sx > n && this.size.sy > n2;
    }

    public void project(Graphics3D graphics3D, Matrix matrix) {
        this.pos.transform(matrix);
        this.pos.sx = this.pos.sx - this.getWidth() / 2 + this.offsetX;
        this.pos.sy = this.pos.sy + this.getHeight() + this.offsetY;
        this.size.sx = this.pos.sx + this.getWidth();
        this.size.sy = this.pos.sy - this.getHeight();
        this.size.rz = this.pos.rz;
        graphics3D.project(this.pos);
        graphics3D.project(this.size);
    }

    public void render(Graphics3D graphics3D, Texture texture) {
        if (this.lowq) {
            this.render(graphics3D, this.getTexture(), this.pos.sx, this.pos.sy, this.size.sx, this.size.sy, this.mirX, this.mirY);
        }
        if (!this.lowq) {
            this.render2(graphics3D, this.getTexture(), this.pos.sx, this.pos.sy, this.size.sx, this.size.sy, this.mirX, this.mirY);
        }
    }

    private void render(Graphics3D graphics3D, Texture texture, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5;
        int n6 = alpha;
        if (this.sz > 0 && this.fade) {
            n6 = alpha * (256 - Math.min(256, this.sz * 4 * 256 / (this.getWidth() + this.getHeight()))) >> 8;
        }
        if (n > n3) {
            n5 = n;
            n = n3;
            n3 = n5;
        }
        if (n2 > n4) {
            n5 = n2;
            n2 = n4;
            n4 = n5;
        }
        int[] nArray = texture.pixels;
        int n7 = texture.w;
        int n8 = texture.h;
        int n9 = nArray.length;
        int[] nArray2 = graphics3D.display;
        int n10 = graphics3D.width;
        int n11 = 0;
        int n12 = n7;
        int n13 = 0;
        int n14 = n8;
        if (bl) {
            n11 = n7;
            n12 = 0;
        }
        if (bl2) {
            n13 = n8;
            n14 = 0;
        }
        n11 <<= 12;
        n12 <<= 12;
        n13 <<= 12;
        n14 <<= 12;
        if (n3 == n || n4 == n2) {
            return;
        }
        int n15 = (n12 - n11) / (n3 - n);
        int n16 = (n14 - n13) / (n4 - n2);
        int n17 = n11;
        int n18 = n13;
        if (n2 < 0) {
            n18 -= n16 * n2;
            n2 = 0;
        }
        if (n4 > graphics3D.height) {
            n4 = graphics3D.height;
        }
        if (n < 0) {
            n17 -= n15 * n;
            n = 0;
        }
        if (n3 > n10) {
            n3 = n10;
        }
        while (n2 < n4) {
            int n19;
            int n20;
            int n21;
            int n22 = n + n10 * n2;
            int n23 = n3 + n10 * n2;
            int n24 = (n18 & 0xFFFFF000) * n7 + n17;
            while (n23 - n22 >= 2) {
                n21 = nArray[(n24 >> 12 & Integer.MAX_VALUE) % n9];
                n20 = (n21 >> 24 & 0xFF) * n6 >> 8;
                n19 = nArray2[n22];
                nArray2[n22] = n19 = ((n21 & 0xFF00FF) * n20 + (n19 & 0xFF00FF) * (256 - n20) & 0xFF00FF00 | (n21 & 0xFF00) * n20 + (n19 & 0xFF00) * (256 - n20) & 0xFF0000) >>> 8;
                nArray2[n22 + 1] = n19;
                n22 += 2;
                n24 += n15 * 2;
            }
            while (n22 < n23) {
                n21 = nArray[(n24 >> 12 & Integer.MAX_VALUE) % n9];
                n20 = (n21 >> 24 & 0xFF) * n6 >> 8;
                n19 = nArray2[n22];
                nArray2[n22] = ((n21 & 0xFF00FF) * n20 + (n19 & 0xFF00FF) * (256 - n20) & 0xFF00FF00 | (n21 & 0xFF00) * n20 + (n19 & 0xFF00) * (256 - n20) & 0xFF0000) >>> 8;
                ++n22;
                n24 += n15;
            }
            ++n2;
            n18 += n16;
        }
    }

    private void render2(Graphics3D graphics3D, Texture texture, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5;
        int n6 = alpha;
        if (this.sz > 0 && this.fade) {
            n6 = alpha * (256 - Math.min(256, this.sz * 4 * 256 / (this.getWidth() + this.getHeight()))) >> 8;
        }
        if (n > n3) {
            n5 = n;
            n = n3;
            n3 = n5;
        }
        if (n2 > n4) {
            n5 = n2;
            n2 = n4;
            n4 = n5;
        }
        int[] nArray = texture.pixels;
        int n7 = texture.w;
        int n8 = texture.h;
        int n9 = nArray.length;
        int[] nArray2 = graphics3D.display;
        int n10 = graphics3D.width;
        int n11 = 0;
        int n12 = n7;
        int n13 = 0;
        int n14 = n8;
        if (bl) {
            n11 = n7;
            n12 = 0;
        }
        if (bl2) {
            n13 = n8;
            n14 = 0;
        }
        n11 <<= 12;
        n12 <<= 12;
        n13 <<= 12;
        n14 <<= 12;
        if (n3 == n || n4 == n2) {
            return;
        }
        int n15 = (n12 - n11) / (n3 - n);
        int n16 = (n14 - n13) / (n4 - n2);
        int n17 = n11;
        int n18 = n13;
        if (n2 < 0) {
            n18 -= n16 * n2;
            n2 = 0;
        }
        if (n4 > graphics3D.height) {
            n4 = graphics3D.height;
        }
        if (n < 0) {
            n17 -= n15 * n;
            n = 0;
        }
        if (n3 > n10) {
            n3 = n10;
        }
        while (n2 < n4) {
            int n19 = n + n10 * n2;
            int n20 = n3 + n10 * n2;
            int n21 = (n18 & 0xFFFFF000) * n7 + n17;
            while (n19 < n20) {
                int n22 = nArray[(n21 >> 12 & Integer.MAX_VALUE) % n9];
                int n23 = (n22 >> 24 & 0xFF) * n6 >> 8;
                int n24 = nArray2[n19];
                nArray2[n19] = ((n22 & 0xFF00FF) * n23 + (n24 & 0xFF00FF) * (256 - n23) & 0xFF00FF00 | (n22 & 0xFF00) * n23 + (n24 & 0xFF00) * (256 - n23) & 0xFF0000) >>> 8;
                ++n19;
                n21 += n15;
            }
            ++n2;
            n18 += n16;
        }
    }
}

