/*
 * Decompiled with CFR 0.152.
 */
package com.iceberg.graphics3d;

import com.iceberg.graphics3d.Graphics3D;
import com.iceberg.graphics3d.RenderObject;
import com.iceberg.graphics3d.Texture;
import com.iceberg.graphics3d.Vertex;
import com.iceberg.math.Matrix;

public class SpriteAdd
extends RenderObject {
    public static final int fp = 10;
    public static final int FP = 1024;
    private Texture texture;
    private Vertex pos = new Vertex();
    private Vertex size = new Vertex();
    private boolean mirX = false;
    private boolean mirY = false;
    private int scale;
    private int rad;
    private int offsetX = 0;
    private int offsetY = 0;

    public SpriteAdd(Texture texture) {
        this(texture, 1, 0, 0, 0);
    }

    public SpriteAdd(Texture texture, int n, int n2, int n3, int n4) {
        this.texture = texture;
        this.scale = n;
        this.rad = n / 2;
        this.pos.set(n2, n3, n4);
    }

    public void destroy() {
        this.texture = null;
        this.pos = null;
        this.size = null;
    }

    public void setOffset(int n, int n2) {
        this.offsetX = n;
        this.offsetY = n2;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public int getScale() {
        return this.scale;
    }

    public void setMirror(boolean bl, boolean bl2) {
        this.mirX = bl;
        this.mirY = bl2;
    }

    public boolean isMirX() {
        return this.mirX;
    }

    public boolean isMirY() {
        return this.mirY;
    }

    public void mirrorX() {
        this.mirX = !this.mirX;
    }

    public void mirrorY() {
        this.mirY = !this.mirY;
    }

    public void setPosition(int n, int n2, int n3) {
        this.pos.set(n, n2, n3);
    }

    public Vertex getPosition() {
        return this.pos;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public int getWidth() {
        return this.texture.w * this.scale >> 10;
    }

    public int getHeight() {
        return this.texture.h * this.scale >> 10;
    }

    public boolean isVisible(int n, int n2, int n3, int n4) {
        this.sz = this.pos.rz;
        if (this.sz > this.scale) {
            return false;
        }
        if (this.pos.sx - this.scale >= n3 || this.pos.sy - this.scale >= n4) {
            return false;
        }
        return this.size.sx + this.scale > n && this.size.sy + this.scale > n2;
    }

    public void project(Graphics3D graphics3D, Matrix matrix) {
        this.pos.transform(matrix);
        this.pos.sx = this.pos.sx - this.getWidth() / 2 + this.offsetX;
        this.pos.sy = this.pos.sy + this.getHeight() + this.offsetY;
        this.size.sx = this.pos.sx + this.getWidth();
        this.size.sy = this.pos.sy - this.getHeight();
        this.size.rz = this.pos.rz;
        if (this.pos.rz > 0) {
            this.size.sy += this.pos.rz;
        }
        graphics3D.project(this.pos);
        graphics3D.project(this.size);
    }

    public void render(Graphics3D graphics3D, Texture texture) {
        this.render(graphics3D, this.getTexture(), this.pos.sx, this.pos.sy, this.size.sx, this.size.sy, this.mirX, this.mirY);
    }

    private void render(Graphics3D graphics3D, Texture texture, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5;
        if (n > n3) {
            n5 = n;
            n = n3;
            n3 = n5;
        }
        if (n2 > n4) {
            n5 = n2;
            n2 = n4;
            n4 = n5;
        }
        int[] nArray = texture.pixels;
        int n6 = texture.w;
        int n7 = texture.h;
        int n8 = nArray.length;
        int[] nArray2 = graphics3D.display;
        int n9 = graphics3D.width;
        int n10 = 0;
        int n11 = n6;
        int n12 = 0;
        int n13 = n7;
        if (bl) {
            n10 = n6;
            n11 = 0;
        }
        if (bl2) {
            n12 = n7;
            n13 = 0;
        }
        n10 <<= 12;
        n11 <<= 12;
        n12 <<= 12;
        n13 <<= 12;
        if (n3 == n || n4 == n2) {
            return;
        }
        int n14 = (n11 - n10) / (n3 - n);
        int n15 = (n13 - n12) / (n4 - n2);
        int n16 = n10;
        int n17 = n12;
        if (n2 < 0) {
            n17 -= n15 * n2;
            n2 = 0;
        }
        if (n4 > graphics3D.height) {
            n4 = graphics3D.height;
        }
        if (n < 0) {
            n16 -= n14 * n;
            n = 0;
        }
        if (n3 > n9) {
            n3 = n9;
        }
        while (n2 < n4) {
            int n18 = n + n9 * n2;
            int n19 = n3 + n9 * n2;
            int n20 = (n17 & 0xFFFFF000) * n6 + n16;
            while (n18 < n19 - 1) {
                int n21 = nArray[(n20 >> 12 & Integer.MAX_VALUE) % n8];
                if (n21 != 0) {
                    int n22 = nArray2[n18];
                    n21 &= 0xFEFEFE;
                    n21 += (n22 &= 0xFEFEFE);
                    n21 |= (n21 >> 8 & 0x10101) * 255;
                    nArray2[n18] = n21;
                    nArray2[n18 + 1] = n21;
                }
                n18 += 2;
                n20 += n14 * 2;
            }
            ++n2;
            n17 += n15;
        }
    }
}

