/*
 * Decompiled with CFR 0.152.
 */
package com.iceberg.math;

import com.iceberg.math.Vector3D;

public class MathUtils {
    public static final int NORMAL_FP_BITS = 12;
    public static final short[] ArcTan = new short[]{0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60, 64, 68, 72, 76, 80, 84, 88, 92, 96, 100, 104, 108, 112, 116, 120, 124, 128, 132, 136, 140, 144, 148, 151, 155, 159, 163, 167, 171, 175, 179, 183, 187, 191, 194, 198, 202, 206, 210, 214, 218, 221, 225, 229, 233, 237, 240, 244, 248, 252, 256, 259, 263, 267, 271, 274, 278, 282, 286, 289, 293, 297, 300, 304, 308, 311, 315, 319, 322, 326, 329, 333, 337, 340, 344, 347, 351, 355, 358, 362, 365, 369, 372, 376, 379, 383, 386, 390, 393, 397, 400, 403, 407, 410, 414, 417, 420, 424, 427, 430, 434, 437, 440, 444, 447, 450, 454, 457, 460, 463, 467, 470, 473, 476, 480, 483, 486, 489, 492, 495, 499, 502, 505, 508, 511, 514, 517, 520, 523, 526, 529, 532, 535, 538, 541, 544, 547, 550, 553, 556, 559, 562, 565, 568, 571, 574, 577, 580, 582, 585, 588, 591, 594, 597, 599, 602, 605, 608, 610, 613, 616, 619, 621, 624, 627, 629, 632, 635, 637, 640, 643, 645, 648, 651, 653, 656, 658, 661, 663, 666, 669, 671, 674, 676, 679, 681, 684, 686, 688, 691, 693, 696, 698, 701, 703, 705, 708, 710, 713, 715, 717, 720, 722, 724, 727, 729, 731, 734, 736, 738, 740, 743, 745, 747, 749, 752, 754, 756, 758, 760, 762, 765, 767, 769, 771, 773, 775, 777, 780, 782, 784, 786, 788, 790, 792, 794, 796, 798, 800, 802, 804};
    private static final short[] sin = new short[360];
    private static final short[] cos = new short[360];

    public static int cos(int n) {
        n = MathUtils.fixDegree(n);
        return cos[n];
    }

    public static int sin(int n) {
        n = MathUtils.fixDegree(n);
        return sin[n];
    }

    public static int fixDegree(int n) {
        while (n < 0) {
            n += 360;
        }
        while (n >= 360) {
            n -= 360;
        }
        return n;
    }

    public static float invSqrt(float f) {
        float f2 = 0.5f * f;
        int n = Float.floatToIntBits(f);
        n = 1597463007 - (n >> 1);
        f = Float.intBitsToFloat(n);
        return f * (1.5f - f2 * f * f);
    }

    public static final int squared(int n) {
        return n * n;
    }

    public static final long squared(long l) {
        return l * l;
    }

    public static Vector3D createNormal(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        Vector3D vector3D4 = new Vector3D();
        MathUtils.computeNormal(vector3D4, vector3D, vector3D2, vector3D3);
        return vector3D4;
    }

    public static void computeNormal(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4) {
        long l = (long)(vector3D2.y - vector3D3.y) * (long)(vector3D2.z - vector3D4.z) - (long)(vector3D2.z - vector3D3.z) * (long)(vector3D2.y - vector3D4.y);
        long l2 = (long)(vector3D2.z - vector3D3.z) * (long)(vector3D2.x - vector3D4.x) - (long)(vector3D2.x - vector3D3.x) * (long)(vector3D2.z - vector3D4.z);
        long l3 = (long)(vector3D2.x - vector3D3.x) * (long)(vector3D2.y - vector3D4.y) - (long)(vector3D2.y - vector3D3.y) * (long)(vector3D2.x - vector3D4.x);
        double d = Math.sqrt(l * l + l2 * l2 + l3 * l3) / 4096.0;
        vector3D.set((int)((double)l / d), (int)((double)l2 / d), (int)((double)l3 / d));
    }

    public static int distanceToLine(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        int n = vector3D3.x - vector3D2.x;
        int n2 = vector3D3.y - vector3D2.y;
        int n3 = vector3D3.z - vector3D2.z;
        int n4 = vector3D.x - vector3D2.x;
        int n5 = vector3D.y - vector3D2.y;
        int n6 = vector3D.z - vector3D2.z;
        long l = (long)n * (long)n + (long)(n2 * n2) + (long)(n3 * n3);
        long l2 = 0L;
        if (l != 0L) {
            l2 = ((long)n4 * (long)n + (long)(n5 * n2) + (long)(n6 * n3) << 14) / l;
        }
        if (l2 < 0L) {
            l2 = 0L;
        }
        if (l2 > 16384L) {
            l2 = 16384L;
        }
        n = vector3D2.x + (int)((long)n * l2 >> 14);
        n2 = vector3D2.y + (int)((long)n2 * l2 >> 14);
        n3 = vector3D2.z + (int)((long)n3 * l2 >> 14);
        return (n -= vector3D.x) * n + (n2 -= vector3D.y) * n2 + (n3 -= vector3D.z) * n3;
    }

    public static int distanceToRay(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        int n = vector3D3.x;
        int n2 = vector3D3.y;
        int n3 = vector3D3.z;
        int n4 = vector3D.x - vector3D2.x;
        int n5 = vector3D.y - vector3D2.y;
        int n6 = vector3D.z - vector3D2.z;
        long l = n * n + n2 * n2 + n3 * n3;
        long l2 = 0L;
        if (l != 0L) {
            l2 = ((long)n4 * (long)n + (long)(n5 * n2) + (long)(n6 * n3) << 14) / l;
        }
        if (l2 < 0L) {
            l2 = 0L;
        }
        if (l2 > 16384L) {
            l2 = 16384L;
        }
        n = vector3D2.x + (int)((long)n * l2 >> 14);
        n2 = vector3D2.y + (int)((long)n2 * l2 >> 14);
        n3 = vector3D2.z + (int)((long)n3 * l2 >> 14);
        return (n -= vector3D.x) * n + (n2 -= vector3D.y) * n2 + (n3 -= vector3D.z) * n3;
    }

    public static boolean isPointOnPolygon(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4, Vector3D vector3D5, Vector3D vector3D6) {
        int n;
        int n2 = vector3D6.x > 0 ? vector3D6.x : -vector3D6.x;
        int n3 = vector3D6.y > 0 ? vector3D6.y : -vector3D6.y;
        int n4 = n = vector3D6.z > 0 ? vector3D6.z : -vector3D6.z;
        if (n2 >= n3 && n2 >= n) {
            if (vector3D6.x >= 0) {
                return MathUtils.isPointOnPolygon(vector3D.z, vector3D.y, vector3D2.z, vector3D2.y, vector3D3.z, vector3D3.y, vector3D4.z, vector3D4.y, vector3D5.z, vector3D5.y);
            }
            return MathUtils.isPointOnPolygon(vector3D.z, vector3D.y, vector3D5.z, vector3D5.y, vector3D4.z, vector3D4.y, vector3D3.z, vector3D3.y, vector3D2.z, vector3D2.y);
        }
        if (n3 >= n2 && n3 >= n) {
            if (vector3D6.y >= 0) {
                return MathUtils.isPointOnPolygon(vector3D.x, vector3D.z, vector3D2.x, vector3D2.z, vector3D3.x, vector3D3.z, vector3D4.x, vector3D4.z, vector3D5.x, vector3D5.z);
            }
            return MathUtils.isPointOnPolygon(vector3D.x, vector3D.z, vector3D5.x, vector3D5.z, vector3D4.x, vector3D4.z, vector3D3.x, vector3D3.z, vector3D2.x, vector3D2.z);
        }
        if (n >= n2 && n >= n3) {
            if (vector3D6.z <= 0) {
                return MathUtils.isPointOnPolygon(vector3D.x, vector3D.y, vector3D2.x, vector3D2.y, vector3D3.x, vector3D3.y, vector3D4.x, vector3D4.y, vector3D5.x, vector3D5.y);
            }
            return MathUtils.isPointOnPolygon(vector3D.x, vector3D.y, vector3D5.x, vector3D5.y, vector3D4.x, vector3D4.y, vector3D3.x, vector3D3.y, vector3D2.x, vector3D2.y);
        }
        return true;
    }

    public static boolean isPointOnPolygon(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4, Vector3D vector3D5) {
        int n;
        int n2 = vector3D5.x > 0 ? vector3D5.x : -vector3D5.x;
        int n3 = vector3D5.y > 0 ? vector3D5.y : -vector3D5.y;
        int n4 = n = vector3D5.z > 0 ? vector3D5.z : -vector3D5.z;
        if (n2 >= n3 && n2 >= n) {
            if (vector3D5.x >= 0) {
                return MathUtils.isPointOnPolygon(vector3D.z, vector3D.y, vector3D2.z, vector3D2.y, vector3D3.z, vector3D3.y, vector3D4.z, vector3D4.y);
            }
            return MathUtils.isPointOnPolygon(vector3D.z, vector3D.y, vector3D4.z, vector3D4.y, vector3D3.z, vector3D3.y, vector3D2.z, vector3D2.y);
        }
        if (n3 >= n2 && n3 >= n) {
            if (vector3D5.y >= 0) {
                return MathUtils.isPointOnPolygon(vector3D.x, vector3D.z, vector3D2.x, vector3D2.z, vector3D3.x, vector3D3.z, vector3D4.x, vector3D4.z);
            }
            return MathUtils.isPointOnPolygon(vector3D.x, vector3D.z, vector3D4.x, vector3D4.z, vector3D3.x, vector3D3.z, vector3D2.x, vector3D2.z);
        }
        if (n >= n2 && n >= n3) {
            if (vector3D5.z <= 0) {
                return MathUtils.isPointOnPolygon(vector3D.x, vector3D.y, vector3D2.x, vector3D2.y, vector3D3.x, vector3D3.y, vector3D4.x, vector3D4.y);
            }
            return MathUtils.isPointOnPolygon(vector3D.x, vector3D.y, vector3D4.x, vector3D4.y, vector3D3.x, vector3D3.y, vector3D2.x, vector3D2.y);
        }
        return true;
    }

    public static boolean isPointOnPolygon(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        if (n11 > 0) {
            return MathUtils.isPointOnPolygon(n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
        }
        if (n11 < 0) {
            return MathUtils.isPointOnPolygon(n, n2, n9, n10, n7, n8, n5, n6, n3, n4);
        }
        return false;
    }

    public static boolean isPointOnPolygon(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (n9 > 0) {
            return MathUtils.isPointOnPolygon(n, n2, n3, n4, n5, n6, n7, n8);
        }
        if (n9 < 0) {
            return MathUtils.isPointOnPolygon(n, n2, n7, n8, n5, n6, n3, n4);
        }
        return false;
    }

    public static boolean isPointOnPolygon(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return (n5 - n3) * (n2 - n4) <= (n - n3) * (n6 - n4) && (n7 - n5) * (n2 - n6) <= (n - n5) * (n8 - n6) && (n9 - n7) * (n2 - n8) <= (n - n7) * (n10 - n8) && (n3 - n9) * (n2 - n10) <= (n - n9) * (n4 - n10);
    }

    public static boolean isPointOnPolygon(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return (n5 - n3) * (n2 - n4) <= (n - n3) * (n6 - n4) && (n7 - n5) * (n2 - n6) <= (n - n5) * (n8 - n6) && (n3 - n7) * (n2 - n8) <= (n - n7) * (n4 - n8);
    }

    public static float atan(int n) {
        return 0.0f;
    }

    public static float atan2(int n, int n2) {
        float f = 0.0f;
        f = n == 0 && n2 == 0 ? 0.0f : (n >= n2 ? (n >= -n2 ? MathUtils.atan(n2 / n) : -1.58f - MathUtils.atan(n / n2)) : (n >= -n2 ? 1.58f - MathUtils.atan(n / n2) : (n2 >= 0 ? 3.16f + MathUtils.atan(n2 / n) : -3.16f + MathUtils.atan(n2 / n))));
        return f;
    }

    public static float atan2_deg(int n, int n2) {
        float f = 0.0f;
        f = n == 0 && n2 == 0 ? 0.0f : (n >= n2 ? (n >= -n2 ? MathUtils.atan(n2 / n) : -1.58f - MathUtils.atan(n / n2)) : (n >= -n2 ? 1.58f - MathUtils.atan(n / n2) : (n2 >= 0 ? 3.16f + MathUtils.atan(n2 / n) : -3.16f + MathUtils.atan(n2 / n))));
        return (float)Math.toDegrees(f);
    }

    public static int getAnglez(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = Math.abs(n - n3) + Math.abs(n2 - n4);
        int n7 = (n - n3) * 4000 / n6;
        int n8 = (n2 - n4) * 4000 / n6;
        if (n7 < 4000 && n7 > 0 && n8 > 0) {
            n7 = 0;
        }
        if (n7 > 0) {
            n5 += n7 * 360;
        }
        if (n7 < 0) {
            n5 -= n7 * 180;
        }
        if (n8 > 0) {
            n5 += n8 * 90;
        }
        if (n8 < 0) {
            n5 -= n8 * 270;
        }
        n5 /= 4000;
        n5 -= 90;
        n5 = MathUtils.fixDegree(n5);
        return n5;
    }

    static {
        for (int i = 0; i < 360; ++i) {
            MathUtils.sin[i] = (short)(Math.sin(Math.toRadians(i)) * 16384.0);
            MathUtils.cos[i] = (short)(Math.cos(Math.toRadians(i)) * 16384.0);
        }
    }
}

